/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.lsp.impl.visitors.ReferenceScope;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.member.variable.Variable;
import java.util.List;

public class ReferenceLocationsVisitor
extends AstVisitor<ReferenceScope> {
    private static final ReferenceLocationsVisitor INSTANCE = new ReferenceLocationsVisitor();

    public static ReferenceLocationsVisitor get() {
        return INSTANCE;
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(VariableExpression node, ReferenceScope scope) {
        super.visitEnd(node, scope);
        Variable expressionVariable = node.getVariable();
        if (expressionVariable != null && scope.getVariable().getLoc().equals(expressionVariable.getLoc())) {
            scope.getMatchingLocations().add(node.getLoc());
        }
    }

    @Override
    public void visitEnd(Method node, ReferenceScope scope) {
        super.visitEnd(node, scope);
        node.getMethodInfo().getParameters().stream().filter(param -> scope.getVariable().getLoc().equals(param.getLoc())).forEach(param -> scope.getMatchingLocations().add(param.getLoc()));
    }

    @Override
    public void visitEnd(ReferenceExpression node, ReferenceScope scope) {
        super.visitEnd(node, scope);
        List<Identifier> names = node.getNames();
        List<Variable> referenceVariables = node.getVariables();
        List<Identifier> variableNames = names.subList(names.size() - referenceVariables.size(), names.size());
        for (Identifier name : variableNames) {
            for (Variable referenceVariable : referenceVariables) {
                if (!scope.getVariable().getLoc().equals(referenceVariable.getLoc())) continue;
                scope.getMatchingLocations().add(name.getLoc());
            }
        }
    }

    @Override
    public void visitEnd(CatchBlockStatement catchStatement, ReferenceScope scope) {
        super.visitEnd(catchStatement, scope);
        Location excNameLocation = catchStatement.getVariable().getLoc();
        if (scope.getVariable().getLoc().equals(excNameLocation)) {
            scope.getMatchingLocations().add(excNameLocation);
        }
    }

    @Override
    public void visitEnd(TypeWhenBlock typeWhenBlock, ReferenceScope scope) {
        super.visitEnd(typeWhenBlock, scope);
        if (scope.getVariable().getLoc().equals(typeWhenBlock.getVariable().getLoc())) {
            scope.getMatchingLocations().add(typeWhenBlock.getVariable().getLoc());
        }
    }
}

