/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Location;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import java.util.Optional;
import org.objectweb.asm.FieldVisitor;

public class Field
implements AstNode {
    private final TypeInfo definingType;
    private final AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo> builder;
    private final ModifierNode modifiers;
    private FieldInfo fieldInfo;

    public Field(AstNode definingNode, AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo> builder) {
        this.definingType = definingNode.getDefiningType();
        this.builder = builder;
        this.modifiers = new ModifierNode(this, builder.getModifiers());
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        TypeStack.TypeContext context = emitter.getTypeStack().peek();
        ModifierGroup modifiers = context.getType().getUnitType() == UnitType.TRIGGER ? this.fieldInfo.getModifiers().copy().removeModifiers(ModifierTypeInfos.STATIC).build().resolve() : this.fieldInfo.getModifiers();
        Object constantValue = modifiers.all(ModifierTypeInfos.STATIC, ModifierTypeInfos.FINAL) && this.fieldInfo.getType().getBasicType() == BasicType.STRING ? this.fieldInfo.getValue() : null;
        FieldVisitor fieldVisitor = context.getClassWriter().visitField(modifiers.getJavaModifiers(), this.fieldInfo.getBytecodeName(), this.fieldInfo.getEmitType().getTypeSignature(), null, constantValue);
        emitter.getAnnotationVisitor().set(fieldVisitor);
        new ModifierNode(this, modifiers).emit(emitter);
        emitter.getAnnotationVisitor().unset();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    public TypeRef getTypeRef() {
        return this.builder.getTypeRef();
    }

    @Override
    public Location getLoc() {
        return this.builder.getLoc();
    }

    public FieldInfo getFieldInfo() {
        assert (this.fieldInfo != null);
        return this.fieldInfo;
    }

    public void resolve(SymbolResolver symbols) {
        assert (this.fieldInfo == null);
        this.fieldInfo = this.builder.build(symbols);
    }

    public ModifierGroup getModifierInfo() {
        return this.modifiers.getModifiers();
    }

    public ModifierNode getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return Optional.ofNullable(this.fieldInfo).map(Object::toString).orElse(this.builder.toString());
    }
}

