/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerFieldInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class FieldFactory {
    private FieldFactory() {
    }

    public static List<Field> createEnumFields(AstNode definingNode, ModifierGroup modifiers, Collection<Identifier> names) {
        TypeInfo definingType = definingNode.getDefiningType();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Identifier name : names) {
            Field field;
            switch (definingType.getUnitType()) {
                case TRIGGER: {
                    field = new Field(definingNode, (AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo>)((TriggerFieldInfo.Builder)((TriggerFieldInfo.Builder)((TriggerFieldInfo.Builder)TriggerFieldInfo.builder().setName(name)).setType(definingType)).setModifiers(modifiers)).setDefiningType(definingType));
                    break;
                }
                default: {
                    field = new Field(definingNode, (AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo>)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(name)).setType(definingType)).setModifiers(modifiers)).setDefiningType(definingType));
                }
            }
            builder.add(field);
        }
        return builder.build();
    }

    public static List<Field> createFields(AstNode definingNode, VariableDecls fields) {
        TypeInfo definingType = definingNode.getDefiningType();
        ModifierGroupBuilder modifiersBuilder = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addAstModifiers(fields.modifiers);
        if (definingType.getUnitType() == UnitType.ANONYMOUS || definingType.getUnitType() == UnitType.TRIGGER) {
            modifiersBuilder.removeModifiers(ModifierTypeInfos.STATIC);
            modifiersBuilder.addModifiers(ModifierTypeInfos.STATIC);
        }
        ModifierGroup modifiers = modifiersBuilder.build();
        TypeRef typeRef = fields.type;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (VariableDecl variable : fields.decls) {
            Field field;
            ModifierGroup myModifiers = modifiers.copy().setLoc(variable.name.getLoc()).build();
            switch (definingType.getUnitType()) {
                case TRIGGER: {
                    field = new Field(definingNode, (AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo>)((TriggerFieldInfo.Builder)((TriggerFieldInfo.Builder)((TriggerFieldInfo.Builder)((TriggerFieldInfo.Builder)TriggerFieldInfo.builder().setName(variable.name)).setTypeRef(typeRef)).setValue(variable.assignment)).setModifiers(myModifiers)).setDefiningType(definingType));
                    break;
                }
                default: {
                    field = new Field(definingNode, (AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo>)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(variable.name)).setTypeRef(typeRef)).setValue(variable.assignment)).setModifiers(myModifiers)).setDefiningType(definingType));
                }
            }
            builder.add(field);
        }
        return builder.build();
    }

    public static Field createAccessorField(Property definingNode, TypeRef fieldType, ModifierGroup fieldModifiers, Identifier name) {
        return new Field(definingNode, (AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo>)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(name)).setDefiningType(definingNode.getDefiningType())).setTypeRef(fieldType)).setModifiers(fieldModifiers));
    }
}

