/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.SymbolVisitor;
import apex.jorje.semantic.ast.visitor.reference.ReferenceVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilerContext;
import apex.jorje.semantic.compiler.CompilerOperation;
import apex.jorje.semantic.compiler.MemoryProfiled;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

final class CompilerOperations {
    private CompilerOperations() {
    }

    static class EmitOperation
    implements CompilerOperation {
        EmitOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            Emitter emitter = context.getEmitter();
            emitter.setCodeUnit(codeUnit);
            try {
                codeUnit.emit(context.getEmitter());
            }
            finally {
                emitter.setCodeUnit(null);
            }
        }
    }

    static class ReferencesOperation
    implements CompilerOperation {
        ReferencesOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            TypeInfo type = codeUnit.getType();
            if (codeUnit.getErrors().isEmpty() && CodeUnitDetailsProvider.isUserSourced(type.getCodeUnitDetails())) {
                SymbolScope scope = SymbolScope.create(context, codeUnit);
                ReferenceVisitor referenceVisitor = new ReferenceVisitor(type, scope.getSymbols());
                codeUnit.traverse(referenceVisitor, scope);
                codeUnit.setReferences(referenceVisitor.getReferences());
                codeUnit.setReferencesForErrorPropagation(referenceVisitor.calculateReferencesForErrorPropagation());
            } else {
                codeUnit.setReferences(ImmutableList.of());
                codeUnit.setReferencesForErrorPropagation(ImmutableSet.of());
            }
        }
    }

    static class AdditionalValidateOperation
    implements CompilerOperation {
        AdditionalValidateOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            if (context.getAdditionalPassVisitor() != null) {
                codeUnit.additionalValidate(context.getAdditionalPassVisitor());
            }
        }
    }

    static class ValidateOperation
    implements CompilerOperation {
        ValidateOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            codeUnit.validate(context.getSymbolResolver(), context.getValidationSettings());
        }
    }

    static class PostTypeResolveOperation
    implements CompilerOperation {
        PostTypeResolveOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            codeUnit.traverse(context.getPostTypeResolveVisitor(), SymbolScope.create(context, codeUnit));
        }
    }

    static class MemberResolveOperation
    implements CompilerOperation {
        MemberResolveOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            codeUnit.traverse(context.getMemberResolveVisitor(), SymbolScope.create(context, codeUnit));
        }
    }

    static class ParentOperation
    implements CompilerOperation {
        ParentOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            codeUnit.traverse(context.getParentVisitor(), SymbolScope.create(context, codeUnit));
        }
    }

    static class SymbolsOperation
    implements CompilerOperation {
        private final SymbolVisitor symbolVisitor = new SymbolVisitor();

        SymbolsOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            codeUnit.traverse(this.symbolVisitor, SymbolScope.create(context, codeUnit));
        }
    }

    static class ParseOperation
    implements CompilerOperation {
        ParseOperation() {
        }

        @Override
        @MemoryProfiled
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            codeUnit.parse(context.getHiddenTokensBehavior());
        }
    }
}

