/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import apex.jorje.semantic.matchers.IsCompilationException;
import apex.jorje.semantic.matchers.IsMultiMapWithValues;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.MoreLists;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ErrorMatchers {
    private ErrorMatchers() {
    }

    public static IsMultiMapWithValues<CompilationException> containsMultiErrors(String ... expected) {
        return ErrorMatchers.containsMultiErrors(MoreLists.asImmutableList(expected));
    }

    public static IsMultiMapWithValues<CompilationException> containsMultiErrors(List<String> expected) {
        return IsMultiMapWithValues.hasMultiValues(ErrorMatchers.containsErrors(expected));
    }

    public static Matcher<Iterable<? extends CompilationException>> containsErrors(String ... expected) {
        return ErrorMatchers.containsErrors(MoreLists.asImmutableList(expected));
    }

    public static Matcher<Iterable<? extends CompilationException>> containsErrors(List<String> expected) {
        return Matchers.contains(expected.stream().map(IsCompilationException::error).collect(MoreLists.toImmutableList()));
    }
}

