/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsMultiMapWithValues<V>
extends TypeSafeDiagnosingMatcher<Multimap<?, V>> {
    private final Matcher<Iterable<? extends V>> matcher;

    private IsMultiMapWithValues(Matcher<Iterable<? extends V>> matcher) {
        this.matcher = matcher;
    }

    @SafeVarargs
    public static <V> IsMultiMapWithValues<V> hasMultiValues(V ... values) {
        return IsMultiMapWithValues.hasMultiValues(Matchers.contains((Object[])values));
    }

    @SafeVarargs
    public static <V> IsMultiMapWithValues<V> hasMultiValues(Matcher<V> ... values) {
        return IsMultiMapWithValues.hasMultiValues(Matchers.contains(values));
    }

    public static <V> IsMultiMapWithValues<V> hasMultiValues(Matcher<Iterable<? extends V>> matcher) {
        return new IsMultiMapWithValues<V>(matcher);
    }

    protected boolean matchesSafely(Multimap<?, V> item, Description mismatchDescription) {
        Collection<V> values = item.values();
        mismatchDescription.appendText("multimap with values ");
        this.matcher.describeMismatch(values, mismatchDescription);
        return this.matcher.matches(values);
    }

    public void describeTo(Description description) {
        description.appendText("multimap with values ");
        this.matcher.describeTo(description);
    }
}

