/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.annotation.InternalApi;
import org.apache.commons.io.IOUtils;

@Deprecated
@InternalApi
public class AnalysisResult {
    private final long fileChecksum;
    private final List<RuleViolation> violations;

    public AnalysisResult(long fileChecksum, List<RuleViolation> violations) {
        this.fileChecksum = fileChecksum;
        this.violations = violations;
    }

    public AnalysisResult(File sourceFile) {
        this(AnalysisResult.computeFileChecksum(sourceFile), new ArrayList<RuleViolation>());
    }

    private static long computeFileChecksum(File sourceFile) {
        long l;
        CheckedInputStream stream = new CheckedInputStream(new BufferedInputStream(Files.newInputStream(sourceFile.toPath(), new OpenOption[0])), new Adler32());
        try {
            IOUtils.skipFully((InputStream)stream, (long)sourceFile.length());
            l = stream.getChecksum().getValue();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return System.currentTimeMillis();
            }
        }
        stream.close();
        return l;
    }

    public long getFileChecksum() {
        return this.fileChecksum;
    }

    public List<RuleViolation> getViolations() {
        return this.violations;
    }

    public void addViolations(List<RuleViolation> violations) {
        this.violations.addAll(violations);
    }

    public void addViolation(RuleViolation ruleViolation) {
        this.violations.add(ruleViolation);
    }
}

