/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.Objects;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.cli.PMDParameters;

public final class PmdParametersParseResult {
    private final PMDParameters result;
    private final ParameterException error;

    PmdParametersParseResult(PMDParameters result) {
        this.result = Objects.requireNonNull(result);
        this.error = null;
    }

    PmdParametersParseResult(ParameterException error) {
        this.result = null;
        this.error = Objects.requireNonNull(error);
    }

    public boolean isError() {
        return this.result == null;
    }

    public boolean isHelp() {
        return !this.isError() && this.result.isHelp();
    }

    public ParameterException getError() {
        return this.error;
    }

    public PMDConfiguration toConfiguration() {
        return this.result != null && !this.isHelp() ? this.result.toConfiguration() : null;
    }

    public static PmdParametersParseResult extractParameters(String ... args) {
        Objects.requireNonNull(args, "Null parameter array");
        PMDParameters result = new PMDParameters();
        JCommander jcommander = new JCommander((Object)result);
        jcommander.setProgramName("pmd");
        try {
            jcommander.parse(args);
            return new PmdParametersParseResult(result);
        }
        catch (ParameterException e) {
            return new PmdParametersParseResult(e);
        }
    }
}

