/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import net.sourceforge.pmd.cpd.AnyLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.internal.LanguageServiceBase;

public final class LanguageFactory
extends LanguageServiceBase<Language> {
    public static final String EXTENSION = "extension";
    public static final String BY_EXTENSION = "by_extension";
    private static final Comparator<Language> LANGUAGE_COMPARATOR = new Comparator<Language>(){

        @Override
        public int compare(Language o1, Language o2) {
            return o1.getTerseName().compareToIgnoreCase(o2.getTerseName());
        }
    };
    private static final LanguageServiceBase.NameExtractor<Language> NAME_EXTRACTOR = new LanguageServiceBase.NameExtractor<Language>(){

        @Override
        public String getName(Language language) {
            return language.getTerseName().toLowerCase(Locale.ROOT);
        }
    };
    private static LanguageFactory instance = new LanguageFactory();
    public static String[] supportedLanguages = LanguageFactory.instance.languages.keySet().toArray(new String[LanguageFactory.instance.languages.size()]);

    private LanguageFactory() {
        super(Language.class, LANGUAGE_COMPARATOR, NAME_EXTRACTOR);
    }

    public static Language createLanguage(String language) {
        return LanguageFactory.createLanguage(language, new Properties());
    }

    public static Language createLanguage(String language, Properties properties) {
        Language implementation = BY_EXTENSION.equals(language) ? instance.getLanguageByExtension(properties.getProperty(EXTENSION)) : (Language)LanguageFactory.instance.languages.get(instance.languageAliases(language).toLowerCase(Locale.ROOT));
        if (implementation == null) {
            implementation = new AnyLanguage(language);
        }
        implementation.setProperties(properties);
        return implementation;
    }

    private String languageAliases(String language) {
        if ("c".equals(language)) {
            return "cpp";
        }
        return language;
    }

    private Language getLanguageByExtension(String extension) {
        Language result = null;
        for (Language language : this.languages.values()) {
            if (!language.getExtensions().contains(extension)) continue;
            result = language;
            break;
        }
        return result;
    }
}

