/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import net.sourceforge.pmd.cache.internal.ClasspathEntryFingerprinter;
import net.sourceforge.pmd.cache.internal.NoopFingerprinter;
import net.sourceforge.pmd.cache.internal.RawFileFingerprinter;
import net.sourceforge.pmd.cache.internal.ZipFileFingerprinter;

public class ClasspathFingerprinter {
    private static final Logger LOG = Logger.getLogger(ClasspathFingerprinter.class.getName());
    private static final List<ClasspathEntryFingerprinter> FINGERPRINTERS = Collections.unmodifiableList(Arrays.asList(new ZipFileFingerprinter(), new RawFileFingerprinter(), new NoopFingerprinter()));

    public long fingerprint(URL ... classpathEntry) {
        Adler32 adler32 = new Adler32();
        try {
            block2: for (URL url : classpathEntry) {
                String extension = this.getExtension(url);
                for (ClasspathEntryFingerprinter f : FINGERPRINTERS) {
                    if (!f.appliesTo(extension)) continue;
                    f.fingerprint(url, adler32);
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Incremental analysis can't fingerprint classpath contents", e);
            throw new RuntimeException(e);
        }
        return adler32.getValue();
    }

    private String getExtension(URL url) {
        String file = url.getFile();
        int lastDot = file.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return file.substring(lastDot + 1);
    }
}

