/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.XPathRule;

public abstract class DeprecatedAttrLogger {
    private static final Logger LOG = Logger.getLogger(Attribute.class.getName());

    public abstract void recordUsageOf(Attribute var1);

    public static DeprecatedAttrLogger create(XPathRule rule) {
        if (LOG.isLoggable(Level.WARNING)) {
            return new AttrLoggerImpl(rule);
        }
        return DeprecatedAttrLogger.noop();
    }

    public static DeprecatedAttrLogger createAdHocLogger() {
        if (LOG.isLoggable(Level.WARNING)) {
            return new AdhocLoggerImpl();
        }
        return DeprecatedAttrLogger.noop();
    }

    public static Noop noop() {
        return Noop.INSTANCE;
    }

    private static String getLoggableAttributeName(Attribute attr) {
        return attr.getParent().getXPathNodeName() + "/@" + attr.getName();
    }

    private static class AdhocLoggerImpl
    extends DeprecatedAttrLogger {
        private AdhocLoggerImpl() {
        }

        @Override
        public void recordUsageOf(Attribute attribute) {
            String replacement = attribute.replacementIfDeprecated();
            if (replacement != null) {
                String name = DeprecatedAttrLogger.getLoggableAttributeName(attribute);
                String msg = "Use of deprecated attribute '" + name + "' in a findChildNodesWithXPath navigation";
                if (!replacement.isEmpty()) {
                    msg = msg + ", please use " + replacement + " instead";
                }
                LOG.log(Level.WARNING, msg, new RuntimeException(msg));
            }
        }
    }

    private static class AttrLoggerImpl
    extends DeprecatedAttrLogger {
        private final ConcurrentMap<String, Boolean> deprecated = new ConcurrentHashMap<String, Boolean>();
        private final XPathRule rule;

        private AttrLoggerImpl(XPathRule rule) {
            this.rule = rule;
        }

        @Override
        public void recordUsageOf(Attribute attribute) {
            String name;
            Boolean b;
            String replacement = attribute.replacementIfDeprecated();
            if (replacement != null && (b = this.deprecated.putIfAbsent(name = DeprecatedAttrLogger.getLoggableAttributeName(attribute), Boolean.TRUE)) == null) {
                String msg = "Use of deprecated attribute '" + name + "' by XPath rule " + this.ruleToString();
                if (!replacement.isEmpty()) {
                    msg = msg + ", please use " + replacement + " instead";
                }
                LOG.warning(msg);
            }
        }

        public String ruleToString() {
            String name = "'" + this.rule.getName() + "'";
            if (this.rule.getRuleSetName() != null) {
                name = name + " (in ruleset '" + this.rule.getRuleSetName() + "')";
            }
            return name;
        }
    }

    private static class Noop
    extends DeprecatedAttrLogger {
        static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public void recordUsageOf(Attribute attribute) {
        }
    }
}

