/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.treeexport;

import java.io.IOException;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.AbstractPropertySource;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.treeexport.TreeRenderer;
import net.sourceforge.pmd.util.treeexport.TreeRendererDescriptor;

@Experimental
public class TextTreeRenderer
implements TreeRenderer {
    static final TreeRendererDescriptor DESCRIPTOR = new TreeRendererDescriptor(){
        private final PropertyDescriptor<Boolean> onlyAscii = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty("onlyAsciiChars").defaultValue(false)).desc("Use only ASCII characters in the structure")).build();
        private final PropertyDescriptor<Integer> maxLevel = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty("maxLevel").defaultValue(-1)).desc("Max level on which to recurse. Negative means unbounded")).build();

        @Override
        public PropertySource newPropertyBundle() {
            AbstractPropertySource bundle = new AbstractPropertySource(){

                @Override
                protected String getPropertySourceType() {
                    return "tree renderer";
                }

                @Override
                public String getName() {
                    return "text";
                }
            };
            bundle.definePropertyDescriptor(this.onlyAscii);
            bundle.definePropertyDescriptor(this.maxLevel);
            return bundle;
        }

        @Override
        public String id() {
            return "text";
        }

        @Override
        public String description() {
            return "Text renderer";
        }

        @Override
        public TreeRenderer produceRenderer(PropertySource properties) {
            return new TextTreeRenderer(properties.getProperty(this.onlyAscii), properties.getProperty(this.maxLevel));
        }
    };
    private final Strings str;
    private final int maxLevel;

    public TextTreeRenderer(boolean onlyAscii, int maxLevel) {
        this.str = onlyAscii ? Strings.ASCII : Strings.UNICODE;
        this.maxLevel = maxLevel;
    }

    @Override
    public void renderSubtree(Node node, Appendable out) throws IOException {
        this.printInnerNode(node, out, 0, "", true);
    }

    private String childPrefix(String prefix, boolean isTail) {
        return prefix + (isTail ? this.str.gap : this.str.verticalEdge);
    }

    protected final void appendIndent(Appendable out, String prefix, boolean isTail) throws IOException {
        out.append(prefix).append(isTail ? this.str.tailFork : this.str.fork);
    }

    protected void appendNodeInfoLn(Appendable out, Node node) throws IOException {
        out.append(node.getXPathNodeName()).append("\n");
    }

    private void printInnerNode(Node node, Appendable out, int level, String prefix, boolean isTail) throws IOException {
        this.appendIndent(out, prefix, isTail);
        this.appendNodeInfoLn(out, node);
        if (level == this.maxLevel) {
            if (node.getNumChildren() > 0) {
                this.appendBoundaryForNodeLn(node, out, this.childPrefix(prefix, isTail));
            }
        } else {
            int n = node.getNumChildren() - 1;
            String childPrefix = this.childPrefix(prefix, isTail);
            for (int i = 0; i < node.getNumChildren(); ++i) {
                Node child = node.getChild(i);
                this.printInnerNode(child, out, level + 1, childPrefix, i == n);
            }
        }
    }

    protected void appendBoundaryForNodeLn(Node node, Appendable out, String indentStr) throws IOException {
        this.appendIndent(out, indentStr, true);
        if (node.getNumChildren() == 1) {
            out.append("1 child is not shown");
        } else {
            out.append(String.valueOf(node.getNumChildren())).append(" children are not shown");
        }
        out.append('\n');
    }

    private static final class Strings {
        private static final Strings ASCII = new Strings("+- ", "+- ", "|  ", "   ");
        private static final Strings UNICODE = new Strings("\u2514\u2500 ", "\u251c\u2500 ", "\u2502  ", "   ");
        private final String tailFork;
        private final String fork;
        private final String verticalEdge;
        private final String gap;

        private Strings(String tailFork, String fork, String verticalEdge, String gap) {
            this.tailFork = tailFork;
            this.fork = fork;
            this.verticalEdge = verticalEdge;
            this.gap = gap;
        }
    }
}

