/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.ConstructorPreambleStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;

public class UserClassMethods
implements AstNode {
    private final TypeInfo definingType;
    private final Location loc;
    private Method emptyConstructor;

    UserClassMethods(AstNode definingNode, Location loc) {
        this.definingType = definingNode.getDefiningType();
        this.loc = loc;
    }

    private Method createInit() {
        ConstructorPreambleStatement root = new ConstructorPreambleStatement(this, this.loc, Statement.NOOP){

            @Override
            public void emit(Emitter emitter) {
                Emit body = x -> {
                    x.emitVar(Locations.NONE, 25, 0);
                    x.emit(Locations.NONE, ObjectEmitMethods.constructor(UserClassMethods.this.definingType.parents().superType()));
                };
                SystemModeEmit.emitter().withType(UserClassMethods.this.definingType).withBody(body).emit(emitter);
                super.emit(emitter);
                emitter.emit(Locations.NONE, 177);
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().setLoc(this.definingType.getModifiers().getLoc()).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.GLOBAL).build();
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setName("<init>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    public void createMethods() {
        if (!TypeInfoUtil.isConstructable(this.definingType)) {
            this.emptyConstructor = this.createInit();
        }
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope) && this.emptyConstructor != null) {
            this.emptyConstructor.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (this.emptyConstructor != null) {
            this.emptyConstructor.validate(symbols, scope);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.emptyConstructor != null) {
            this.emptyConstructor.emit(emitter);
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Location getLoc() {
        throw new UnexpectedCodePathException();
    }
}

