/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class InterfaceErasedBridge
implements Bridge {
    private static final InterfaceErasedBridge INSTANCE = new InterfaceErasedBridge();
    private static final Set<ModifierTypeInfo> STATIC_AND_ABSTRACT = ImmutableSet.of(ModifierTypeInfos.STATIC, ModifierTypeInfos.ABSTRACT);

    private InterfaceErasedBridge() {
    }

    public static InterfaceErasedBridge get() {
        return INSTANCE;
    }

    @Override
    public List<Supplier<Method>> create(BridgeMethodCreator definingNode, MethodInfo methodImpl) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MethodInfo methodInterface : methodImpl.getMethodInterfaces()) {
            MethodInfo unreifiedMethod = MethodUtil.getUnreifiedMethod(methodInterface);
            if (!MethodUtil.isReifiedMethod(methodInterface) || GenericTypeInfoUtil.isReifiedType(unreifiedMethod.getReturnType()) || TypeInfoEquivalence.isEquivalent(methodImpl.getReturnType(), TypeInfos.OBJECT) || TypeInfoEquivalence.isEquivalent(methodImpl.getReturnType(), TypeInfos.VOID)) continue;
            builder.add(new InterfaceErasedSupplier(definingNode, methodImpl, unreifiedMethod));
        }
        return builder.build();
    }

    private static class InterfaceErasedSupplier
    implements Supplier<Method> {
        private final AstNode definingNode;
        private final MethodInfo methodImpl;
        private final MethodInfo unreifiedMethod;

        private InterfaceErasedSupplier(BridgeMethodCreator definingNode, MethodInfo methodImpl, MethodInfo unreifiedMethod) {
            this.definingNode = definingNode;
            this.methodImpl = methodImpl;
            this.unreifiedMethod = unreifiedMethod;
        }

        @Override
        public Method get() {
            TypeInfo definingType = this.definingNode.getDefiningType();
            int i = 0;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Parameter parameter : this.unreifiedMethod.getParameters()) {
                builder.add(Parameter.builder().setDefiningType(definingType).setType(ArgumentTypeInfoConverter.convertType(parameter.getType())).setName("arg" + i++).setModifiers(parameter.getModifierInfo()).build());
            }
            ImmutableCollection reifiedParameters = builder.build();
            ModifierGroup modifiers = this.methodImpl.getModifiers().copy().removeModifiers(STATIC_AND_ABSTRACT).addModifiers(ModifierTypeInfos.BRIDGE).build();
            SimpleStatement root = new SimpleStatement(this.definingNode, SimpleStatement.Returnable.YES){

                @Override
                public void emit(Emitter emitter) {
                    if (!methodImpl.getModifiers().has(ModifierTypeInfos.STATIC)) {
                        emitter.emitVar(Locations.NONE, 25, 0);
                    }
                    for (int i = 0; i < methodImpl.getParameterTypes().size(); ++i) {
                        emitter.emitVar(Locations.NONE, 25, i + 1);
                    }
                    int opcode = methodImpl.getModifiers().has(ModifierTypeInfos.STATIC) ? 184 : 183;
                    AsmMethod bridge = AsmMethod.builder().setOpcode(opcode).setDefiningTypeAsBytecodeMethodName(methodImpl.getDefiningType()).setFunction(MethodNameMangler.getMangledCanonicalName(methodImpl)).setSignature(methodImpl.getSignature()).build();
                    emitter.emit(Locations.NONE, bridge);
                    emitter.emit(Locations.NONE, MethodUtil.returnsNonVoid(methodImpl) ? 176 : 177);
                }
            };
            String name = MethodNameMangler.getMangledName(this.unreifiedMethod.getCanonicalName(), TypeInfos.OBJECT, this.unreifiedMethod.getParameterTypes());
            return MethodFactory.create(this.definingNode, StandardMethodInfo.builder().setDefiningType(definingType).setReturnType(TypeInfos.OBJECT).setName(name).setModifiers(modifiers).setGenerated(Generated.BRIDGE).setParameters((List<Parameter>)((Object)reifiedParameters)), root);
        }
    }
}

