/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.I18nSupport;
import com.google.common.annotations.VisibleForTesting;

public class NamespaceGuardContextRule
implements AnnotationContextRule {
    private static final NamespaceGuardContextRule INSTANCE = new NamespaceGuardContextRule();

    @Override
    public void validate(MethodContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @VisibleForTesting
    NamespaceGuardContextRule() {
    }

    public static NamespaceGuardContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(TypeContext context) {
        if (context.getDefiningType().getUnitType() != UnitType.CLASS) {
            return;
        }
        for (MethodInfo methodInfo : context.getDefiningType().methods().getInstance()) {
            if (!methodInfo.getGenerated().isUserDefined()) continue;
            context.addNodeError(I18nSupport.getLabel("namespace.guard.static.only"));
            return;
        }
        if (context.getDefiningType().methods().getUserConstructors().size() == 0) {
            context.addNodeError(I18nSupport.getLabel("namespace.guard.one.private.constructor"));
            return;
        }
        for (MethodInfo userConstructor : context.getDefiningType().methods().getUserConstructors()) {
            if (userConstructor.getModifiers().has(ModifierTypeInfos.PRIVATE)) continue;
            context.addNodeError(I18nSupport.getLabel("namespace.guard.private.constructor"));
            return;
        }
    }
}

