/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.VisibilityUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.MoreLists;
import java.util.List;

public class FieldDeclarationStatements
extends Statement {
    private final TypeRef typeRef;
    private final Location loc;
    private final List<FieldDeclaration> declarations;
    private final ModifierGroup modifiersInfo;
    private final ModifierNode modifiers;
    private TypeInfo type;

    public FieldDeclarationStatements(AstNode definingNode, Stmnt.VariableDeclStmnt stmnt) {
        super(definingNode);
        this.typeRef = stmnt.variableDecls.type;
        this.loc = Locations.from(stmnt);
        this.declarations = stmnt.variableDecls.decls.stream().filter(AstNodes.VARIABLE_DECLS_FILTER).map(variable -> new FieldDeclaration(this, (VariableDecl)variable)).collect(MoreLists.toImmutableList(stmnt.variableDecls.decls.size()));
        this.modifiersInfo = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addAstModifiers(stmnt.variableDecls.modifiers).build();
        this.modifiers = new ModifierNode(this, this.modifiersInfo);
    }

    public TypeRef getTypeName() {
        return this.typeRef;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.modifiers.traverse(visitor, scope);
            for (FieldDeclaration declaration : this.declarations) {
                declaration.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        if (this.typeRef == null) {
            errors.markInvalid(this);
            return;
        }
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved()) {
            errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (TypeInfoEquivalence.isEquivalent(this.type, TypeInfos.VOID) && Version.V168.isLessThanOrEqual(VersionUtil.get(this))) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.void.variable"));
            return;
        }
        if (!VisibilityUtil.isTypeSfdcOnlyVisible(symbols, this.getDefiningType(), this.type) || !Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, Visibility.ReferencedFromTestMethod.NO, Visibility.CheckGenericTypeArguments.YES)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        this.modifiers.validate(symbols, scope);
        for (FieldDeclaration declaration : this.declarations) {
            declaration.validate(symbols, scope);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        for (FieldDeclaration declaration : this.declarations) {
            declaration.emit(emitter);
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public TypeInfo getType() {
        assert (this.type != null);
        return this.type;
    }

    public List<FieldDeclaration> getDeclarations() {
        return this.declarations;
    }

    public ModifierGroup getModifiers() {
        return this.modifiersInfo;
    }
}

