/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.semantic.symbol.type.FlowInterviewTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;

class ReferencedTypeVisitor
extends TypeInfoVisitor.Default<Boolean> {
    private static final ReferencedTypeVisitor INSTANCE = new ReferencedTypeVisitor();

    private ReferencedTypeVisitor() {
    }

    public static ReferencedTypeVisitor get() {
        return INSTANCE;
    }

    @Override
    protected Boolean _default(TypeInfo type) {
        return false;
    }

    @Override
    public Boolean visit(StandardTypeInfo type) {
        return CodeUnitDetailsProvider.isUserSourced(type.getCodeUnitDetails()) || TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SYSTEM_LABEL, type);
    }

    @Override
    public Boolean visit(GenericTypeInfo type) {
        assert (!GenericTypeInfoUtil.isReifiedType(type)) : "This should be the unreified type foo<t>";
        switch (type.getBasicType()) {
            case LIST: 
            case SET: 
            case MAP: {
                return false;
            }
            case APEX_OBJECT: {
                return !type.getCodeUnitDetails().isFileBased();
            }
        }
        return false;
    }

    @Override
    public Boolean visit(SObjectTypeInfo type) {
        return true;
    }

    @Override
    public Boolean visit(VfComponentTypeInfo type) {
        return type.getId() != null;
    }

    @Override
    public Boolean visit(FlowInterviewTypeInfo type) {
        return true;
    }
}

