/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.Namespace;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

public class Namespaces {
    public static final Namespace EMPTY = Namespaces.create("", "");
    public static final Namespace SYSTEM = Namespaces.create("System", "");
    public static final Namespace SCHEMA = Namespaces.create("Schema", "");
    public static final Namespace VF_COMPONENT = Namespaces.create("Component", "");
    public static final Namespace VF = Namespaces.create("c", "");
    public static final Namespace APEX_PAGES = Namespaces.create("ApexPages", "");
    public static final Namespace APEX = Namespaces.create("Apex", "");
    public static final Namespace DATABASE = Namespaces.create("Database", "");
    public static final Namespace FLOW = Namespaces.create("Flow", "");
    public static final Namespace CONNECT_API = Namespaces.create("ConnectApi", "");
    public static final Namespace CUSTOM_METADATA = Namespaces.create("CustomMetadata", "");
    public static final Namespace MESSAGING = Namespaces.create("Messaging", "");
    private static final Interner<Namespace> NAMESPACES = Interners.newWeakInterner();

    public static Namespace parse(String fullNamespace) {
        int index = fullNamespace.indexOf("__");
        Namespace namespace = index > -1 ? Namespaces.create(fullNamespace.substring(0, index), fullNamespace.substring(index + 2, fullNamespace.length())) : Namespaces.create(fullNamespace);
        return NAMESPACES.intern(namespace);
    }

    public static Namespace create(String global) {
        return Namespaces.create(global, "");
    }

    public static Namespace create(String global, String module) {
        Namespace namespace = new Namespace(global, module);
        if (Namespace.isEmptyOrNull(namespace)) {
            return EMPTY;
        }
        return namespace;
    }
}

