/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTableFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldTables;
import apex.jorje.semantic.symbol.member.variable.PropertyFactory;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.DynamicTypeNameFactory;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class VfComponentTypeInfo
extends AbstractTypeInfo {
    private final Set<String> facets;
    private final String id;

    private VfComponentTypeInfo(Builder builder) {
        super(builder);
        assert (TypeInfoEquivalence.isEquivalent(this.parents().superType(), InternalTypeInfos.APEX_PAGES_COMPONENT));
        this.facets = builder.facets;
        this.id = builder.id;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static TypeInfo createExpressionsType(VfComponentTypeInfo type) {
        return ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName(InternalTypeInfos.APEX_PAGES_EXPRESSIONS.getApexName())).setBytecodeName(InternalTypeInfos.APEX_PAGES_EXPRESSIONS.getBytecodeName())).setNamespace(Namespaces.APEX_PAGES)).setFields(DynamicFieldTables.createExpressionsTable(type))).buildResolved();
    }

    private static TypeInfo createFacetsType(VfComponentTypeInfo type) {
        return ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName(InternalTypeInfos.APEX_PAGES_FACETS.getApexName())).setBytecodeName(InternalTypeInfos.APEX_PAGES_FACETS.getBytecodeName())).setNamespace(Namespaces.APEX_PAGES)).setFields(DynamicFieldTables.createFacetsTable(type))).buildResolved();
    }

    @SfdcCalled
    public String getId() {
        return this.id;
    }

    public boolean hasFacet(String name) {
        return this.facets.contains(name);
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, VfComponentTypeInfo> {
        private String vfComponentName;
        private Set<String> facets = ImmutableSet.of();
        private String id;

        private Builder() {
        }

        public Builder setFacets(Set<String> facets) {
            this.facets = facets;
            return this;
        }

        public Builder setVfComponentName(String vfComponentName) {
            this.vfComponentName = vfComponentName;
            return this;
        }

        @SfdcCalled
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public VfComponentTypeInfo build() {
            assert (this.vfComponentName != null) : "vf component name must be defined";
            Initializer<MethodTable, TypeInfo> methods = Initializers.memoize(type -> MethodTableFactory.newMethodTableWithSuperTypeVirtualMethodTable(type.parents().superType(), StandardMethodInfo.builder().setDefiningType((TypeInfo)type).setName("<init>").setConstructor().setGenerated(Generated.BUILT_IN).setModifiers(ModifierGroups.ONLY_GLOBAL).build()));
            this.setApexName(DynamicTypeNameFactory.createVfComponentApexName(this.getNamespace(), this.vfComponentName));
            this.setBytecodeName(DynamicTypeNameFactory.createVfComponentBytecodeName(this.getNamespace(), this.vfComponentName));
            this.setBasicType(BasicType.VF_COMPONENT);
            this.setUnitType(UnitType.CLASS);
            this.setModifiers(ModifierGroups.ONLY_GLOBAL);
            this.setMethods(methods);
            this.setFields(Initializers.memoize(type -> {
                assert (type instanceof VfComponentTypeInfo);
                StandardFieldTable table = new StandardFieldTable();
                VfComponentTypeInfo vfComponentType = (VfComponentTypeInfo)type;
                table.add(PropertyFactory.create(InternalTypeInfos.APEX_PAGES_COMPONENT, VfComponentTypeInfo.createExpressionsType(vfComponentType), "expressions", ModifierGroups.ONLY_GLOBAL, ModifierGroups.ONLY_GLOBAL, ModifierGroups.ONLY_PRIVATE));
                table.add(PropertyFactory.create(InternalTypeInfos.APEX_PAGES_COMPONENT, VfComponentTypeInfo.createFacetsType(vfComponentType), "facets", ModifierGroups.ONLY_GLOBAL, ModifierGroups.ONLY_GLOBAL, ModifierGroups.ONLY_PRIVATE));
                return table;
            }));
            return new VfComponentTypeInfo(this);
        }
    }
}

