/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import java.util.ArrayDeque;
import java.util.Deque;
import net.sourceforge.pmd.lang.modelica.ast.ASTClassDefinition;
import net.sourceforge.pmd.lang.modelica.ast.ASTComponentDeclaration;
import net.sourceforge.pmd.lang.modelica.ast.ASTStoredDefinition;
import net.sourceforge.pmd.lang.modelica.ast.InternalModelicaNodeApi;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaNode;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaParserVisitorAdapter;
import net.sourceforge.pmd.lang.modelica.resolver.AbstractModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassScope;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaComponentDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaSourceFileScope;
import net.sourceforge.pmd.lang.modelica.resolver.RootScope;

public class ScopeAndDeclarationFinder
extends ModelicaParserVisitorAdapter {
    private final Deque<AbstractModelicaScope> scopes = new ArrayDeque<AbstractModelicaScope>();

    ScopeAndDeclarationFinder() {
        this.scopes.push(new RootScope());
    }

    private void pushScope(ModelicaNode node, AbstractModelicaScope ownScope) {
        AbstractModelicaScope prevTop = this.scopes.peek();
        ownScope.setParent(prevTop);
        this.scopes.push(ownScope);
        InternalModelicaNodeApi.setNodeOwnScope(node, ownScope);
    }

    private void createClassDeclaration(ASTClassDefinition node) {
        ModelicaScope containingScope = ((ModelicaNode)node.getParent()).getMostSpecificScope();
        ModelicaClassDeclaration declaration = new ModelicaClassDeclaration(node);
        ((AbstractModelicaScope)containingScope).addDeclaration(declaration);
        this.pushScope(node, new ModelicaClassScope(declaration));
    }

    private void createFileDeclaration(ASTStoredDefinition node) {
        RootScope rootScope = (RootScope)this.scopes.peek();
        ModelicaSourceFileScope scope = new ModelicaSourceFileScope(node);
        rootScope.addSourceFile(scope);
        this.pushScope(node, scope);
    }

    private void createComponentDeclaration(ASTComponentDeclaration node) {
        ModelicaComponentDeclaration declaration = new ModelicaComponentDeclaration(node);
        declaration.setContainingScope((ModelicaClassScope)this.scopes.peek());
        ((AbstractModelicaScope)node.getMostSpecificScope()).addDeclaration(declaration);
    }

    @Override
    public Object visit(ASTStoredDefinition node, Object data) {
        this.createFileDeclaration(node);
        return this.cont(node);
    }

    @Override
    public Object visit(ASTClassDefinition node, Object data) {
        this.createClassDeclaration(node);
        return this.cont(node);
    }

    @Override
    public Object visit(ASTComponentDeclaration node, Object data) {
        this.createComponentDeclaration(node);
        return super.visit(node, data);
    }

    private Object cont(ModelicaNode node) {
        super.visit(node, null);
        this.scopes.pop();
        return null;
    }
}

