/*
 * Decompiled with CFR 0.152.
 */
package apex.common.tuple;

import apex.common.base.ObjectHash;
import apex.common.tuple.IntPairInterner;
import com.google.common.base.MoreObjects;
import java.io.Serializable;

public final class IntPair
implements Serializable {
    private static final IntPairInterner<IntPair> INTERNER = new IntPairInterner<IntPair>(IntPair::new);
    private final int x;
    private final int y;

    IntPair(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public static IntPair tuple(int x, int y) {
        return INTERNER.intern(x, y);
    }

    public int hashCode() {
        return ObjectHash.hash(this.x, this.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntPair other = (IntPair)obj;
        return this.x == other.x && this.y == other.y;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("x", this.x).add("y", this.y).toString();
    }

    public int value0() {
        return this.x;
    }

    public int value1() {
        return this.y;
    }
}

