/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.Namespaces;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.ConstructorContextUtil;
import apex.jorje.lsp.impl.utils.MembersContextUtil;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SystemNamespaceCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SystemNamespaceCompletionStrategy.class);
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;
    private final ConstructorContextUtil constructorUtil;
    private final MembersContextUtil membersContextUtil;

    @Inject
    SystemNamespaceCompletionStrategy(ApexDocumentService documentService, CompletionActivationFactory factory, ConstructorContextUtil constructorUtil, MembersContextUtil membersContextUtil) {
        this.documentService = documentService;
        this.factory = factory;
        this.constructorUtil = constructorUtil;
        this.membersContextUtil = membersContextUtil;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        ArrayList<CompletionItem> items = Lists.newArrayList();
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        optDoc.ifPresent(doc -> {
            try {
                if (this.constructorUtil.isConstructorContext((Document)doc, params.getPosition()) || this.membersContextUtil.isMemberContext((Document)doc, params.getPosition())) {
                    return;
                }
                PrefixCompletionActivationStrategy strategy = this.factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
                if (strategy.getCompletionPrefix().isPresent()) {
                    String prefix = strategy.getCompletionPrefix().get();
                    if (prefix.isEmpty()) {
                        items.addAll(CompletionItemTransformer.transformNamespaces(Namespaces.NAMESPACES));
                    } else {
                        items.addAll(CompletionItemTransformer.transformNamespaces(Namespaces.NAMESPACES).stream().filter(ns -> StringUtils.startsWith((CharSequence)ns.getLabel().toLowerCase(), (CharSequence)prefix.toLowerCase())).collect(Collectors.toList()));
                    }
                }
            }
            catch (BadLocationException e) {
                logger.error("Encountered a bad location while providing namespace completion", (Throwable)e);
            }
        });
        return items;
    }
}

