/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Location;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.AnnotationParameterContext;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationProperty;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import java.util.Comparator;

public class AnnotationParameter
implements AstNode {
    static final Comparator<AnnotationParameter> NAME_COMPARATOR = Comparator.comparing(left -> left.property.getName());
    private static final AnnotationValue.MatchBlock<String> GET_VALUE = new AnnotationValue.MatchBlock<String>(){

        @Override
        public String _case(AnnotationValue.TrueAnnotationValue x) {
            return "true";
        }

        @Override
        public String _case(AnnotationValue.FalseAnnotationValue x) {
            return "false";
        }

        @Override
        public String _case(AnnotationValue.StringAnnotationValue x) {
            return x.value;
        }
    };
    private static final AnnotationValue.MatchBlock<Boolean> IS_TRUE = new AnnotationValue.MatchBlock<Boolean>(){

        @Override
        public Boolean _case(AnnotationValue.TrueAnnotationValue x) {
            return true;
        }

        @Override
        public Boolean _case(AnnotationValue.FalseAnnotationValue x) {
            return false;
        }

        @Override
        public Boolean _case(AnnotationValue.StringAnnotationValue x) {
            return Boolean.parseBoolean(x.value);
        }
    };
    private static final AnnotationValue.MatchBlock<Boolean> IS_BOOLEAN = new AnnotationValue.MatchBlock<Boolean>(){

        @Override
        public Boolean _case(AnnotationValue.TrueAnnotationValue x) {
            return true;
        }

        @Override
        public Boolean _case(AnnotationValue.FalseAnnotationValue x) {
            return true;
        }

        @Override
        public Boolean _case(AnnotationValue.StringAnnotationValue x) {
            return true;
        }
    };
    private static final AnnotationValue.MatchBlock<Boolean> IS_INTEGER = new AnnotationValue.MatchBlock<Boolean>(){

        @Override
        public Boolean _case(AnnotationValue.TrueAnnotationValue x) {
            return false;
        }

        @Override
        public Boolean _case(AnnotationValue.FalseAnnotationValue x) {
            return false;
        }

        @Override
        public Boolean _case(AnnotationValue.StringAnnotationValue x) {
            try {
                Integer.parseInt(x.value);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    };
    private static final AnnotationValue.MatchBlock<Boolean> IS_VALID_STRING = new AnnotationValue.MatchBlock<Boolean>(){

        @Override
        public Boolean _case(AnnotationValue.TrueAnnotationValue x) {
            return false;
        }

        @Override
        public Boolean _case(AnnotationValue.FalseAnnotationValue x) {
            return false;
        }

        @Override
        public Boolean _case(AnnotationValue.StringAnnotationValue x) {
            return x.value != null;
        }
    };
    private static final AnnotationValue.MatchBlock<Integer> GET_INTEGER = new AnnotationValue.MatchBlockWithDefault<Integer>(){

        @Override
        public Integer _case(AnnotationValue.StringAnnotationValue x) {
            return Integer.parseInt(x.value);
        }

        @Override
        protected Integer _default(AnnotationValue x) {
            throw new UnexpectedCodePathException();
        }
    };
    private static final AnnotationValue.MatchBlock<String> GET_STRING = new AnnotationValue.MatchBlockWithDefault<String>(){

        @Override
        public String _case(AnnotationValue.StringAnnotationValue x) {
            return x.value;
        }

        @Override
        protected String _default(AnnotationValue x) {
            throw new UnexpectedCodePathException();
        }
    };
    private final Annotation annotation;
    private final Location loc;
    private final String name;
    private final AnnotationValue value;
    private final boolean isDefault;
    private Object rawValue;
    private AnnotationProperty property;

    private AnnotationParameter(Annotation annotation, Location loc, String name, AnnotationValue value, boolean isDefault) {
        this.annotation = annotation;
        this.loc = loc;
        this.name = name;
        this.value = value;
        this.isDefault = isDefault;
    }

    static AnnotationParameter create(Annotation annotation, Location loc, String name, AnnotationValue value) {
        return new AnnotationParameter(annotation, loc, name, value, false);
    }

    static AnnotationParameter createDefault(Annotation annotation, Location loc, String name, AnnotationValue value) {
        return new AnnotationParameter(annotation, loc, name, value, true);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (!scope.getErrors().isInvalid(this) && this.rawValue == null) {
            this.validate(new AnnotationParameterContext(this, scope));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        String name = this.annotation.getType().getBytecodeName() + "@" + this.property.getName();
        emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit(name, this.rawValue);
    }

    @Override
    public TypeInfo getDefiningType() {
        throw new UnsupportedOperationException();
    }

    public void validate(AnnotationContext context) {
        if (context.getErrors().isInvalid(this.annotation) || !this.annotation.getType().isResolved()) {
            return;
        }
        if (this.property == null) {
            context.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("annotation.property.not.supported", this.name, this.annotation.getType()));
            return;
        }
        if (this.value == null) {
            context.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("annotation.property.invalid.value", new Object[]{this.name, this.property.getType()}));
            return;
        }
        switch (this.property.getType()) {
            case BOOLEAN: {
                if (!this.value.match(IS_BOOLEAN).booleanValue()) {
                    context.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("annotation.property.invalid.value", this.name, TypeInfos.BOOLEAN));
                    return;
                }
                this.rawValue = this.value.match(IS_TRUE);
                break;
            }
            case INTEGER: {
                if (!this.value.match(IS_INTEGER).booleanValue()) {
                    context.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("annotation.property.invalid.value", this.name, TypeInfos.INTEGER));
                    return;
                }
                this.rawValue = this.value.match(GET_INTEGER);
                break;
            }
            case STRING: {
                if (!this.value.match(IS_VALID_STRING).booleanValue()) {
                    context.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("annotation.property.invalid.value", this.name, TypeInfos.STRING));
                    return;
                }
                this.rawValue = this.value.match(GET_STRING);
            }
        }
        this.property.getRules().validate(context, this);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public AnnotationValue getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.value.match(GET_VALUE);
    }

    public Boolean getBooleanValue() {
        assert (this.property.getType() == AnnotationProperty.Type.BOOLEAN) : "property is should be boolean: " + (Object)((Object)this.property.getType());
        return this.value.match(IS_TRUE);
    }

    public Integer getIntegerValue() {
        assert (this.property.getType() == AnnotationProperty.Type.INTEGER) : "property is should be integer: " + (Object)((Object)this.property.getType());
        return this.value.match(GET_INTEGER);
    }

    @SfdcCalled
    public String getStringValue() {
        assert (this.property.getType() == AnnotationProperty.Type.STRING) : "property is should be string: " + (Object)((Object)this.property.getType());
        return this.value.match(GET_STRING);
    }

    public void resolve() {
        this.property = this.annotation.getType().getProperties().get(this.name);
    }

    public AnnotationProperty getProperty() {
        return this.property;
    }

    public ModifierOrAnnotationTypeInfo getAnnotationType() {
        return this.annotation.getType();
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

