/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class UntypedExternalDependency
implements ExternalDependency {
    private final DependencyType dependencyType;
    private final Location loc;
    private final String dependencyValue;

    private UntypedExternalDependency(DependencyType dependencyType, Location loc, String dependencyValue) {
        this.dependencyType = dependencyType;
        this.loc = loc;
        this.dependencyValue = dependencyValue;
    }

    public static UntypedExternalDependency create(DependencyType dependencyType, Location loc, String dependencyValue) {
        return new UntypedExternalDependency(dependencyType, loc, dependencyValue);
    }

    public DependencyType getDependencyType() {
        return this.dependencyType;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public String getDependencyValue() {
        return this.dependencyValue;
    }

    public int hashCode() {
        return ObjectHash.hash((Object)this.dependencyType, this.loc, this.dependencyValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UntypedExternalDependency that = (UntypedExternalDependency)o;
        return Objects.equals((Object)this.dependencyType, (Object)that.dependencyType) && Objects.equals(this.loc, that.loc) && Objects.equals(this.dependencyValue, that.dependencyValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("dependencyType", (Object)this.dependencyType).add("loc", this.loc).add("dependencyValue", this.dependencyValue).toString();
    }

    @Override
    public <T> T accept(ExternalDependency.ExternalDependencyVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static enum DependencyType {
        LIGHTNING_WEB_COMPONENT_NAME;

    }
}

