/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import apex.jorje.data.ast.LiteralType;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class StringLiteralExpressionMatcher
extends TypeSafeDiagnosingMatcher<Expression> {
    private final String expectedString;

    private StringLiteralExpressionMatcher(String expectedString) {
        this.expectedString = expectedString;
    }

    public static StringLiteralExpressionMatcher stringLiteralExpression(String expectedString) {
        return new StringLiteralExpressionMatcher(expectedString);
    }

    protected boolean matchesSafely(Expression actualExpression, Description description) {
        description.appendText("Expression" + actualExpression.toString());
        if (!ExpressionUtil.isLiteralExpression(actualExpression)) {
            return false;
        }
        LiteralExpression actualLiteralExpression = ExpressionUtil.getLiteralExpression(actualExpression);
        description.appendText("Literal expression type: " + (Object)((Object)actualLiteralExpression.getLiteralType()));
        if (actualLiteralExpression.getLiteralType() != LiteralType.STRING) {
            return false;
        }
        description.appendText("Literal string: " + actualLiteralExpression.getLiteral());
        return Objects.equals(this.expectedString, actualLiteralExpression.getLiteral());
    }

    public void describeTo(Description description) {
        description.appendText("Literal string: " + this.expectedString);
    }
}

