/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.ast.Expr;
import java.math.BigDecimal;
import java.util.Optional;

public final class ConstantValue {
    private static final Expr.MatchBlock<Object> GET_VALUE = new Expr.MatchBlockWithDefault<Object>(){

        @Override
        public Object _case(Expr.PrefixExpr x) {
            switch (x.op) {
                case POSITIVE: {
                    return Optional.ofNullable(x.expr).map(expr -> expr.match(this)).orElse(null);
                }
                case NEGATIVE: {
                    return Optional.ofNullable(x.expr).map(expr -> expr.match(this)).map(this::negate).orElse(null);
                }
            }
            return null;
        }

        @Override
        public Object _case(Expr.LiteralExpr x) {
            return x.literal;
        }

        @Override
        public Object _case(Expr.NestedExpr x) {
            return Optional.ofNullable(x.expr).map(expr -> expr.match(this)).orElse(null);
        }

        @Override
        protected Object _default(Expr x) {
            return null;
        }

        private Object negate(Object value) {
            if (value instanceof Integer) {
                return -1 * (Integer)value;
            }
            if (value instanceof Long) {
                return -1L * (Long)value;
            }
            if (value instanceof Double) {
                return -1.0 * (Double)value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).negate();
            }
            return null;
        }
    };

    public static Object get(Optional<Expr> assignment) {
        return assignment.map(ConstantValue::get).orElse(null);
    }

    public static Object get(Expr assignment) {
        return assignment.match(GET_VALUE);
    }
}

