/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.symbol.member.variable.TriggerVariable;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.collect.MoreMaps;
import java.util.HashMap;
import java.util.Map;

public class TriggerVariableMap {
    static final Map<String, TriggerVariable> GENERIC_TABLE = TriggerVariableMap.create(TypeInfos.SOBJECT);
    private final Map<TypeInfo, Map<String, TriggerVariable>> map = new HashMap<TypeInfo, Map<String, TriggerVariable>>();

    private static Map<String, TriggerVariable> create(TypeInfo targetType) {
        assert (targetType != null);
        GenericTypeInfo sobjectList = TypeInfoEquivalence.isEquivalent(targetType, TypeInfos.SOBJECT) ? ReifiedTypeInfos.SOBJECT_LIST : GenericTypeInfoFactory.createList(targetType);
        GenericTypeInfo idToSObjectMap = TypeInfoEquivalence.isEquivalent(targetType, TypeInfos.SOBJECT) ? ReifiedTypeInfos.ID_TO_SOBJECT_MAP : GenericTypeInfoFactory.createMap(TypeInfos.ID, targetType);
        Map<String, TriggerVariable> builder = MoreMaps.newCaseInsensitiveMap();
        builder.put("isExecuting", new TriggerVariable("isExecuting", TypeInfos.BOOLEAN));
        builder.put("isInsert", new TriggerVariable("isInsert", TypeInfos.BOOLEAN));
        builder.put("isUpdate", new TriggerVariable("isUpdate", TypeInfos.BOOLEAN));
        builder.put("isDelete", new TriggerVariable("isDelete", TypeInfos.BOOLEAN));
        builder.put("isUndelete", new TriggerVariable("isUndelete", TypeInfos.BOOLEAN));
        builder.put("isAfter", new TriggerVariable("isAfter", TypeInfos.BOOLEAN));
        builder.put("isBefore", new TriggerVariable("isBefore", TypeInfos.BOOLEAN));
        builder.put("size", new TriggerVariable("getSize", TypeInfos.INTEGER));
        builder.put("old", new TriggerVariable("getOld", sobjectList, ReifiedTypeInfos.SOBJECT_LIST));
        builder.put("oldMap", new TriggerVariable("getOldMap", idToSObjectMap, ReifiedTypeInfos.STRING_TO_SOBJECT_MAP));
        builder.put("new", new TriggerVariable("getNew", sobjectList, ReifiedTypeInfos.SOBJECT_LIST));
        builder.put("newMap", new TriggerVariable("getNewMap", idToSObjectMap, ReifiedTypeInfos.STRING_TO_SOBJECT_MAP));
        builder.put("operationType", new TriggerVariable("operationType", InternalTypeInfos.SYSTEM_TRIGGER_OPERATION));
        return MoreMaps.toImmutableMap(builder);
    }

    Map<String, TriggerVariable> get(TypeInfo definingType) {
        return this.map.get(definingType);
    }

    public TriggerVariable get(TypeInfo definingType, TypeInfo targetType, String name) {
        assert (targetType.getBasicType() == BasicType.SOBJECT) : "target type not an sobject";
        TypeInfo topLevelType = TypeInfoUtil.getTopLevel(definingType);
        Map<String, TriggerVariable> variableMap = this.map.get(topLevelType);
        if (variableMap == null) {
            variableMap = TypeInfoEquivalence.isEquivalent(targetType, TypeInfos.SOBJECT) ? GENERIC_TABLE : TriggerVariableMap.create(targetType);
            this.map.put(topLevelType, variableMap);
        }
        return variableMap.get(name);
    }
}

