/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.QueryOption;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;

public class QueryOptionPrinter
implements Printer<QueryOption> {
    private static final Printer<QueryOption> INSTANCE = new QueryOptionPrinter();
    private static final QueryOption.MatchBlock<Boolean> IS_FOR_UPDATE = new QueryOption.MatchBlock<Boolean>(){

        @Override
        public Boolean _case(QueryOption.LockRows x) {
            return true;
        }

        @Override
        public Boolean _case(QueryOption.IncludeDeleted x) {
            return false;
        }
    };
    private static final QueryOption.MatchBlock<String> QUERY_OPTION = new QueryOption.MatchBlock<String>(){

        @Override
        public String _case(QueryOption.LockRows x) {
            return "FOR UPDATE";
        }

        @Override
        public String _case(QueryOption.IncludeDeleted x) {
            return "ALL ROWS";
        }
    };

    private QueryOptionPrinter() {
    }

    public static Printer<QueryOption> get() {
        return INSTANCE;
    }

    @Override
    public String print(QueryOption x, PrintContext ctx) {
        ctx.setForUpdate(x.match(IS_FOR_UPDATE));
        return x.match(QUERY_OPTION);
    }
}

