/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Properties;
import net.sourceforge.pmd.cpd.AntlrTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.token.AntlrToken;
import net.sourceforge.pmd.cpd.token.AntlrTokenFilter;
import net.sourceforge.pmd.lang.antlr.AntlrTokenManager;
import net.sourceforge.pmd.lang.lua.antlr4.LuaLexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;

public class LuaTokenizer
extends AntlrTokenizer {
    private boolean ignoreLiteralSequences = false;

    public void setProperties(Properties properties) {
        this.ignoreLiteralSequences = this.getBooleanProperty(properties, "net.sourceforge.pmd.cpd.Tokenizer.skipLiteralSequences");
    }

    private boolean getBooleanProperty(Properties properties, String property) {
        return Boolean.parseBoolean(properties.getProperty(property, Boolean.FALSE.toString()));
    }

    protected AntlrTokenManager getLexerForSource(SourceCode sourceCode) {
        CharStream charStream = AntlrTokenizer.getCharStreamFromSourceCode((SourceCode)sourceCode);
        return new AntlrTokenManager((Lexer)new LuaLexer(charStream), sourceCode.getFileName());
    }

    protected AntlrTokenFilter getTokenFilter(AntlrTokenManager tokenManager) {
        return new LuaTokenFilter(tokenManager, this.ignoreLiteralSequences);
    }

    private static class LuaTokenFilter
    extends AntlrTokenFilter {
        private final boolean ignoreLiteralSequences;
        private boolean discardingRequires = false;
        private boolean discardingNL = false;
        private AntlrToken discardingLiteralsUntil = null;
        private boolean discardCurrent = false;

        LuaTokenFilter(AntlrTokenManager tokenManager, boolean ignoreLiteralSequences) {
            super(tokenManager);
            this.ignoreLiteralSequences = ignoreLiteralSequences;
        }

        protected void analyzeToken(AntlrToken currentToken) {
            this.skipNewLines(currentToken);
        }

        protected void analyzeTokens(AntlrToken currentToken, Iterable<AntlrToken> remainingTokens) {
            this.discardCurrent = false;
            this.skipRequires(currentToken);
            this.skipLiteralSequences(currentToken, remainingTokens);
        }

        private void skipRequires(AntlrToken currentToken) {
            int type = currentToken.getKind();
            if (type == 59) {
                this.discardingRequires = true;
            } else if (type == 75 && this.discardingRequires) {
                this.discardingRequires = false;
                this.discardCurrent = true;
            }
        }

        private void skipNewLines(AntlrToken currentToken) {
            this.discardingNL = currentToken.getKind() == 76;
        }

        private void skipLiteralSequences(AntlrToken currentToken, Iterable<AntlrToken> remainingTokens) {
            if (this.ignoreLiteralSequences) {
                int type = currentToken.getKind();
                if (this.isDiscardingLiterals()) {
                    if (currentToken == this.discardingLiteralsUntil) {
                        this.discardingLiteralsUntil = null;
                        this.discardCurrent = true;
                    }
                } else if (type == 70 || type == 72 || type == 74) {
                    AntlrToken finalToken;
                    this.discardingLiteralsUntil = finalToken = this.findEndOfSequenceOfLiterals(remainingTokens);
                }
            }
        }

        private AntlrToken findEndOfSequenceOfLiterals(Iterable<AntlrToken> remainingTokens) {
            boolean seenLiteral = false;
            int braceCount = 0;
            int bracketCount = 0;
            int parenCount = 0;
            block12: for (AntlrToken token : remainingTokens) {
                switch (token.getKind()) {
                    case 60: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        seenLiteral = true;
                        continue block12;
                    }
                    case 77: {
                        continue block12;
                    }
                    case 76: {
                        continue block12;
                    }
                    case 57: {
                        continue block12;
                    }
                    case 70: {
                        ++braceCount;
                        continue block12;
                    }
                    case 71: {
                        if (--braceCount >= 0) continue block12;
                        return seenLiteral ? token : null;
                    }
                    case 72: {
                        ++bracketCount;
                        continue block12;
                    }
                    case 73: {
                        if (--bracketCount >= 0) continue block12;
                        return seenLiteral ? token : null;
                    }
                    case 74: {
                        ++parenCount;
                        continue block12;
                    }
                    case 75: {
                        if (--parenCount >= 0) continue block12;
                        return seenLiteral ? token : null;
                    }
                }
                return null;
            }
            return null;
        }

        public boolean isDiscardingLiterals() {
            return this.discardingLiteralsUntil != null;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingRequires || this.discardingNL || this.isDiscardingLiterals() || this.discardCurrent;
        }
    }
}

