/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.util.Predicate;

public class CPDReport {
    private final List<Match> matches;
    private final Map<String, Integer> numberOfTokensPerFile;

    CPDReport(List<Match> matches, Map<String, Integer> numberOfTokensPerFile) {
        this.matches = Collections.unmodifiableList(matches);
        this.numberOfTokensPerFile = Collections.unmodifiableMap(new TreeMap<String, Integer>(numberOfTokensPerFile));
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public Map<String, Integer> getNumberOfTokensPerFile() {
        return this.numberOfTokensPerFile;
    }

    @Experimental
    public CPDReport filterMatches(Predicate<Match> filter) {
        ArrayList<Match> filtered = new ArrayList<Match>();
        for (Match match : this.getMatches()) {
            if (!filter.test(match)) continue;
            filtered.add(match);
        }
        return new CPDReport(filtered, this.getNumberOfTokensPerFile());
    }
}

