/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.util.StringUtil;

public final class TokenMgrError
extends RuntimeException {
    private final int line;
    private final int column;
    private final String filename;
    @Deprecated
    public static final int LEXICAL_ERROR = 0;
    @Deprecated
    public static final int STATIC_LEXER_ERROR = 1;
    @Deprecated
    public static final int INVALID_LEXICAL_STATE = 2;
    @Deprecated
    public static final int LOOP_DETECTED = 3;

    @Deprecated
    public TokenMgrError() {
        this("NO_MESSAGE", 0);
    }

    @Deprecated
    public TokenMgrError(String message, int reason) {
        super(message);
        this.line = -1;
        this.column = -1;
        this.filename = null;
    }

    public TokenMgrError(int line, int column, String filename, String message, Throwable cause) {
        super(message, cause);
        this.line = line;
        this.column = column;
        this.filename = filename;
    }

    @Deprecated
    @InternalApi
    public TokenMgrError(boolean eofSeen, int lexStateName, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        super(TokenMgrError.makeReason(eofSeen, lexStateName, errorAfter, curChar));
        this.line = errorLine;
        this.column = errorColumn;
        this.filename = null;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getFilename() {
        return this.filename;
    }

    @Deprecated
    protected static String addEscapes(String str) {
        return StringUtil.escapeJava(str);
    }

    @Deprecated
    protected static String LexicalError(boolean eofSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
        return TokenMgrError.makeMessage(null, errorLine, errorColumn, TokenMgrError.makeReason(eofSeen, lexState, errorAfter, curChar));
    }

    @Override
    public String getMessage() {
        return TokenMgrError.makeMessage(this.filename, this.line, this.column, super.getMessage());
    }

    private static String makeMessage(String filename, int line, int column, String message) {
        String leader = filename != null ? "Lexical error in file " + filename : "Lexical error";
        return leader + " at line " + line + ", column " + column + ".  Encountered: " + message;
    }

    public TokenMgrError withFileName(String filename) {
        return new TokenMgrError(this.line, this.column, filename, this.getMessage(), this.getCause());
    }

    private static String makeReason(boolean eofseen, int lexStateName, String errorAfter, char curChar) {
        String message = eofseen ? "<EOF> " : "\"" + StringUtil.escapeJava(String.valueOf(curChar)) + "\" (" + curChar + "), ";
        message = message + "after : \"" + StringUtil.escapeJava(errorAfter) + "\" (in lexical state " + lexStateName + ")";
        return message;
    }
}

