/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.ParameterizedMetricKey;
import net.sourceforge.pmd.lang.metrics.ResultOption;

public final class MetricsUtil {
    static final String NULL_KEY_MESSAGE = "The metric key must not be null";
    static final String NULL_OPTIONS_MESSAGE = "The metric options must not be null";
    static final String NULL_NODE_MESSAGE = "The node must not be null";

    private MetricsUtil() {
    }

    public static <N extends Node> boolean supportsAll(N node, MetricKey<N> ... metrics) {
        for (MetricKey<N> metric : metrics) {
            if (metric.supports(node)) continue;
            return false;
        }
        return true;
    }

    public static <O extends Node> double computeAggregate(MetricKey<? super O> key, Iterable<? extends O> ops, ResultOption resultOption) {
        return MetricsUtil.computeAggregate(key, ops, MetricOptions.emptyOptions(), resultOption);
    }

    public static <O extends Node> double computeAggregate(MetricKey<? super O> key, Iterable<? extends O> ops, MetricOptions options, ResultOption resultOption) {
        Objects.requireNonNull(key, NULL_KEY_MESSAGE);
        Objects.requireNonNull(options, NULL_OPTIONS_MESSAGE);
        Objects.requireNonNull(ops, NULL_NODE_MESSAGE);
        Objects.requireNonNull(resultOption, "The result option must not be null");
        ArrayList<Double> values = new ArrayList<Double>();
        for (Node op : ops) {
            if (!key.supports(op)) continue;
            double val = MetricsUtil.computeMetric(key, op, options);
            values.add(val);
        }
        switch (resultOption) {
            case SUM: {
                return MetricsUtil.sum(values);
            }
            case HIGHEST: {
                return MetricsUtil.highest(values);
            }
            case AVERAGE: {
                return MetricsUtil.average(values);
            }
        }
        throw new IllegalArgumentException("Unknown result option " + (Object)((Object)resultOption));
    }

    public static <N extends Node> double computeMetric(MetricKey<? super N> key, N node) {
        return MetricsUtil.computeMetric(key, node, MetricOptions.emptyOptions());
    }

    @Deprecated
    public static <N extends Node> double computeMetricOrNaN(MetricKey<? super N> key, N node, MetricOptions options) {
        if (!key.supports(node)) {
            return Double.NaN;
        }
        return MetricsUtil.computeMetric(key, node, options, false);
    }

    public static <N extends Node> double computeMetric(MetricKey<? super N> key, N node, MetricOptions options) {
        return MetricsUtil.computeMetric(key, node, options, false);
    }

    public static <N extends Node> double computeMetric(MetricKey<? super N> key, N node, MetricOptions options, boolean forceRecompute) {
        Objects.requireNonNull(key, NULL_KEY_MESSAGE);
        Objects.requireNonNull(options, NULL_OPTIONS_MESSAGE);
        Objects.requireNonNull(node, NULL_NODE_MESSAGE);
        if (!key.supports(node)) {
            throw new IllegalArgumentException(key + " cannot be computed on " + node);
        }
        ParameterizedMetricKey<? super N> paramKey = ParameterizedMetricKey.getInstance(key, options);
        Double prev = (Double)node.getUserMap().get(paramKey);
        if (!forceRecompute && prev != null) {
            return prev;
        }
        double val = key.getCalculator().computeFor(node, options);
        node.getUserMap().set(paramKey, val);
        return val;
    }

    private static double sum(List<Double> values) {
        double sum = 0.0;
        for (double val : values) {
            sum += val;
        }
        return sum;
    }

    private static double highest(List<Double> values) {
        double highest = Double.NEGATIVE_INFINITY;
        for (double val : values) {
            if (!(val > highest)) continue;
            highest = val;
        }
        return highest == Double.NEGATIVE_INFINITY ? 0.0 : highest;
    }

    private static double average(List<Double> values) {
        return MetricsUtil.sum(values) / (double)values.size();
    }
}

