/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.treeexport;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.treeexport.TextTreeRenderer;
import net.sourceforge.pmd.util.treeexport.TreeRenderer;
import net.sourceforge.pmd.util.treeexport.TreeRendererDescriptor;
import net.sourceforge.pmd.util.treeexport.TreeRendererDescriptorImpl;
import net.sourceforge.pmd.util.treeexport.XmlTreeRenderer;

@Experimental
public final class TreeRenderers {
    static final PropertyDescriptor<Boolean> XML_RENDER_PROLOG = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty("renderProlog").desc("True to output a prolog")).defaultValue(true)).build();
    static final PropertyDescriptor<Boolean> XML_USE_SINGLE_QUOTES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty("singleQuoteAttributes").desc("Use single quotes to delimit attribute values")).defaultValue(true)).build();
    static final PropertyDescriptor<String> XML_LINE_SEPARATOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty("lineSeparator").desc("Line separator to use. The default is platform-specific. The values 'CR', 'CRLF', 'LF', '\\r', '\\r\\n' and '\\n' can be used to represent a carriage return, line feed and their combination more easily.")).defaultValue(System.lineSeparator())).build();
    static final PropertyDescriptor<Boolean> XML_RENDER_COMMON_ATTRIBUTES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty("renderCommonAttributes").desc("True to render attributes like BeginLine, EndLine, etc.")).defaultValue(false)).build();
    static final TreeRendererDescriptor XML = new TreeRendererDescriptorImpl("xml", "XML format with the same structure as the one used in XPath"){
        private final Set<PropertyDescriptor<?>> myDescriptors = Collections.unmodifiableSet(new LinkedHashSet<PropertyDescriptor>(Arrays.asList(XML_USE_SINGLE_QUOTES, XML_LINE_SEPARATOR, XML_RENDER_PROLOG, XML_RENDER_COMMON_ATTRIBUTES)));

        @Override
        protected Set<PropertyDescriptor<?>> availableDescriptors() {
            return this.myDescriptors;
        }

        @Override
        public TreeRenderer produceRenderer(final PropertySource properties) {
            XmlTreeRenderer.XmlRenderingConfig config = new XmlTreeRenderer.XmlRenderingConfig(){
                private final List<String> excluded = Arrays.asList("BeginLine", "BeginColumn", "EndLine", "EndColumn", "SingleLine", "FindBoundary");

                @Override
                protected boolean takeAttribute(Node node, Attribute attribute) {
                    if (!properties.getProperty(XML_RENDER_COMMON_ATTRIBUTES).booleanValue()) {
                        return !this.excluded.contains(attribute.getName());
                    }
                    return true;
                }
            }.singleQuoteAttributes(properties.getProperty(XML_USE_SINGLE_QUOTES)).renderProlog(properties.getProperty(XML_RENDER_PROLOG)).lineSeparator(properties.getProperty(XML_LINE_SEPARATOR));
            return new XmlTreeRenderer(config);
        }
    };
    private static final Map<String, TreeRendererDescriptor> REGISTRY = new ConcurrentHashMap<String, TreeRendererDescriptor>();

    private TreeRenderers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeRendererDescriptor findById(String id) {
        Map<String, TreeRendererDescriptor> map = REGISTRY;
        synchronized (map) {
            return REGISTRY.get(id);
        }
    }

    public static Collection<TreeRendererDescriptor> registeredRenderers() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean register(TreeRendererDescriptor descriptor) {
        Map<String, TreeRendererDescriptor> map = REGISTRY;
        synchronized (map) {
            if (REGISTRY.containsKey(descriptor.id())) {
                return false;
            }
            REGISTRY.put(descriptor.id(), descriptor);
        }
        return true;
    }

    static {
        List<TreeRendererDescriptor> builtinDescriptors = Arrays.asList(XML, TextTreeRenderer.DESCRIPTOR);
        for (TreeRendererDescriptor descriptor : builtinDescriptors) {
            REGISTRY.put(descriptor.id(), descriptor);
        }
    }
}

