/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.ast.PrefixOp;

public enum PrefixOperator {
    POSITIVE("+"),
    NEGATIVE("-"),
    LOGICAL_NOT("!"),
    BITWISE_NOT("~"),
    INCREMENT("++"),
    DECREMENT("--");

    private final String symbol;

    private PrefixOperator(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static PrefixOperator valueOf(PrefixOp op) {
        switch (op) {
            case POSITIVE: {
                return POSITIVE;
            }
            case NEGATIVE: {
                return NEGATIVE;
            }
            case NOT: {
                return LOGICAL_NOT;
            }
            case BITWISE_COMPLEMENT: {
                return BITWISE_NOT;
            }
            case INC: {
                return INCREMENT;
            }
            case DEC: {
                return DECREMENT;
            }
        }
        throw new IllegalArgumentException("Invalid prefix operator " + op);
    }
}

