/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

@Deprecated
public class VariableNamingConventionsRule
extends AbstractApexRule {
    private boolean checkMembers;
    private boolean checkLocals;
    private boolean checkParameters;
    private List<String> staticPrefixes;
    private List<String> staticSuffixes;
    private List<String> memberPrefixes;
    private List<String> memberSuffixes;
    private List<String> localPrefixes;
    private List<String> localSuffixes;
    private List<String> parameterPrefixes;
    private List<String> parameterSuffixes;
    private static final PropertyDescriptor<Boolean> CHECK_MEMBERS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkMembers").desc("Check member variables")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<Boolean> CHECK_LOCALS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkLocals").desc("Check local variables")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<Boolean> CHECK_PARAMETERS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkParameters").desc("Check constructor and method parameter variables")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<List<String>> STATIC_PREFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"staticPrefix").desc("Static variable prefixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();
    private static final PropertyDescriptor<List<String>> STATIC_SUFFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"staticSuffix").desc("Static variable suffixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();
    private static final PropertyDescriptor<List<String>> MEMBER_PREFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"memberPrefix").desc("Member variable prefixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();
    private static final PropertyDescriptor<List<String>> MEMBER_SUFFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"memberSuffix").desc("Member variable suffixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();
    private static final PropertyDescriptor<List<String>> LOCAL_PREFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"localPrefix").desc("Local variable prefixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();
    private static final PropertyDescriptor<List<String>> LOCAL_SUFFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"localSuffix").desc("Local variable suffixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();
    private static final PropertyDescriptor<List<String>> PARAMETER_PREFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"parameterPrefix").desc("Method parameter variable prefixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();
    private static final PropertyDescriptor<List<String>> PARAMETER_SUFFIXES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"parameterSuffix").desc("Method parameter variable suffixes")).defaultValues((Object)"", (Object[])new String[0]).delim(',').build();

    public VariableNamingConventionsRule() {
        this.definePropertyDescriptor(CHECK_MEMBERS_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_LOCALS_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_PARAMETERS_DESCRIPTOR);
        for (PropertyDescriptor<List<String>> property : VariableNamingConventionsRule.suffixOrPrefixProperties()) {
            this.definePropertyDescriptor(property);
        }
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Style"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 5);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    private static List<PropertyDescriptor<List<String>>> suffixOrPrefixProperties() {
        ArrayList<PropertyDescriptor<List<String>>> res = new ArrayList<PropertyDescriptor<List<String>>>();
        res.add(STATIC_PREFIXES_DESCRIPTOR);
        res.add(STATIC_SUFFIXES_DESCRIPTOR);
        res.add(MEMBER_PREFIXES_DESCRIPTOR);
        res.add(MEMBER_SUFFIXES_DESCRIPTOR);
        res.add(LOCAL_PREFIXES_DESCRIPTOR);
        res.add(LOCAL_SUFFIXES_DESCRIPTOR);
        res.add(PARAMETER_PREFIXES_DESCRIPTOR);
        res.add(PARAMETER_SUFFIXES_DESCRIPTOR);
        return res;
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    protected void init() {
        this.checkMembers = (Boolean)this.getProperty(CHECK_MEMBERS_DESCRIPTOR);
        this.checkLocals = (Boolean)this.getProperty(CHECK_LOCALS_DESCRIPTOR);
        this.checkParameters = (Boolean)this.getProperty(CHECK_PARAMETERS_DESCRIPTOR);
        this.staticPrefixes = (List)this.getProperty(STATIC_PREFIXES_DESCRIPTOR);
        this.staticSuffixes = (List)this.getProperty(STATIC_SUFFIXES_DESCRIPTOR);
        this.memberPrefixes = (List)this.getProperty(MEMBER_PREFIXES_DESCRIPTOR);
        this.memberSuffixes = (List)this.getProperty(MEMBER_SUFFIXES_DESCRIPTOR);
        this.localPrefixes = (List)this.getProperty(LOCAL_PREFIXES_DESCRIPTOR);
        this.localSuffixes = (List)this.getProperty(LOCAL_SUFFIXES_DESCRIPTOR);
        this.parameterPrefixes = (List)this.getProperty(PARAMETER_PREFIXES_DESCRIPTOR);
        this.parameterSuffixes = (List)this.getProperty(PARAMETER_SUFFIXES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTField node, Object data) {
        if (!this.checkMembers) {
            return data;
        }
        boolean isStatic = node.getModifiers().isStatic();
        boolean isFinal = node.getModifiers().isFinal();
        return this.checkName(isStatic ? this.staticPrefixes : this.memberPrefixes, isStatic ? this.staticSuffixes : this.memberSuffixes, node, isStatic, isFinal, data);
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        if (!this.checkLocals) {
            return data;
        }
        boolean isFinal = ((ASTVariableDeclarationStatements)node.getFirstParentOfType(ASTVariableDeclarationStatements.class)).getModifiers().isFinal();
        return this.checkName(this.localPrefixes, this.localSuffixes, node, false, isFinal, data);
    }

    @Override
    public Object visit(ASTParameter node, Object data) {
        if (!this.checkParameters) {
            return data;
        }
        boolean isFinal = node.getModifiers().isFinal();
        return this.checkName(this.parameterPrefixes, this.parameterSuffixes, node, false, isFinal, data);
    }

    private Object checkName(List<String> prefixes, List<String> suffixes, ApexNode<?> node, boolean isStatic, boolean isFinal, Object data) {
        String varName = node.getImage();
        if (varName == null || "serialVersionUID".equals(varName)) {
            return data;
        }
        if (isStatic && isFinal) {
            if (!varName.equals(varName.toUpperCase(Locale.ROOT))) {
                this.addViolationWithMessage(data, node, "Variables that are final and static should be all capitals, ''{0}'' is not all capitals.", new Object[]{varName});
            }
            return data;
        }
        if (!isFinal) {
            String normalizedVarName = this.normalizeVariableName(varName, prefixes, suffixes);
            if (normalizedVarName.indexOf(95) >= 0) {
                this.addViolationWithMessage(data, node, "Only variables that are final should contain underscores (except for underscores in standard prefix/suffix), ''{0}'' is not final.", new Object[]{varName});
            }
            if (Character.isUpperCase(varName.charAt(0))) {
                this.addViolationWithMessage(data, node, "Variables should start with a lowercase character, ''{0}'' starts with uppercase character.", new Object[]{varName});
            }
        }
        return data;
    }

    private String normalizeVariableName(String varName, List<String> prefixes, List<String> suffixes) {
        return this.stripSuffix(this.stripPrefix(varName, prefixes), suffixes);
    }

    private String stripSuffix(String varName, List<String> suffixes) {
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!varName.endsWith(suffix)) continue;
                return varName.substring(0, varName.length() - suffix.length());
            }
        }
        return varName;
    }

    private String stripPrefix(String varName, List<String> prefixes) {
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!varName.startsWith(prefix)) continue;
                return varName.substring(prefix.length());
            }
        }
        return varName;
    }

    public boolean hasPrefixesOrSuffixes() {
        for (PropertyDescriptor<List<String>> desc : VariableNamingConventionsRule.suffixOrPrefixProperties()) {
            if (((List)this.getProperty(desc)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String dysfunctionReason() {
        return this.hasPrefixesOrSuffixes() ? null : "No prefixes or suffixes specified";
    }
}

