/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.properties.IntegerProperty;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractRule {
    private int depth;
    private int depthLimit;
    private static final PropertyDescriptor problemDepthDescriptor = new IntegerProperty("problemDepth", "Maximum allowable statement depth", 0, 1.0f);
    private static final Map propertyDescriptorsByName = AvoidDeeplyNestedIfStmtsRule.asFixedMap(problemDepthDescriptor);

    public Object visit(ASTCompilationUnit node, Object data) {
        this.depth = 0;
        this.depthLimit = this.getIntProperty(problemDepthDescriptor);
        return super.visit(node, data);
    }

    public Object visit(ASTIfStatement node, Object data) {
        if (!node.hasElse()) {
            ++this.depth;
        }
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, node);
        }
        --this.depth;
        return data;
    }

    protected Map propertiesByName() {
        return propertyDescriptorsByName;
    }
}

