/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class BeanMembersShouldSerializeRule
extends AbstractRule {
    private String prefixProperty;
    private static final PropertyDescriptor prefixDescriptor = new StringProperty("prefix", "Prefix somethingorother?", "", 1.0f);
    private static final Map propertyDescriptorsByName = BeanMembersShouldSerializeRule.asFixedMap(prefixDescriptor);

    public Object visit(ASTCompilationUnit node, Object data) {
        this.prefixProperty = this.getStringProperty(prefixDescriptor);
        super.visit(node, data);
        return data;
    }

    private static String[] imagesOf(List simpleNodes) {
        String[] imageArray = new String[simpleNodes.size()];
        for (int i = 0; i < simpleNodes.size(); ++i) {
            imageArray[i] = ((SimpleNode)simpleNodes.get(i)).getImage();
        }
        return imageArray;
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map methods = node.getScope().getEnclosingClassScope().getMethodDeclarations();
        ArrayList<ASTMethodDeclarator> getSetMethList = new ArrayList<ASTMethodDeclarator>(methods.size());
        Iterator i = methods.keySet().iterator();
        while (i.hasNext()) {
            ASTMethodDeclarator mnd = ((MethodNameDeclaration)i.next()).getMethodNameDeclaratorNode();
            if (!this.isBeanAccessor(mnd)) continue;
            getSetMethList.add(mnd);
        }
        Object[] methNameArray = BeanMembersShouldSerializeRule.imagesOf(getSetMethList);
        Arrays.sort(methNameArray);
        Map vars = node.getScope().getVariableDeclarations();
        Iterator i2 = vars.keySet().iterator();
        while (i2.hasNext()) {
            boolean hasSetMethod;
            VariableNameDeclaration decl = (VariableNameDeclaration)i2.next();
            if (((List)vars.get(decl)).isEmpty() || decl.getAccessNodeParent().isTransient() || decl.getAccessNodeParent().isStatic()) continue;
            String varName = this.trimIfPrefix(decl.getImage());
            varName = varName.substring(0, 1).toUpperCase() + varName.substring(1, varName.length());
            boolean hasGetMethod = Arrays.binarySearch(methNameArray, "get" + varName) >= 0 || Arrays.binarySearch(methNameArray, "is" + varName) >= 0;
            boolean bl = hasSetMethod = Arrays.binarySearch(methNameArray, "set" + varName) >= 0;
            if (hasGetMethod && hasSetMethod) continue;
            this.addViolation(data, decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private String trimIfPrefix(String img) {
        if (this.prefixProperty != null && img.startsWith(this.prefixProperty)) {
            return img.substring(this.prefixProperty.length());
        }
        return img;
    }

    private boolean isBeanAccessor(ASTMethodDeclarator meth) {
        ASTResultType ret;
        List primitives;
        String methodName = meth.getImage();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return true;
        }
        return methodName.startsWith("is") && !(primitives = (ret = (ASTResultType)meth.jjtGetParent().jjtGetChild(0)).findChildrenOfType(ASTPrimitiveType.class)).isEmpty() && ((ASTPrimitiveType)primitives.get(0)).isBoolean();
    }

    protected Map propertiesByName() {
        return propertyDescriptorsByName;
    }
}

