/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.imports;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.rules.ImportWrapper;

public class DuplicateImportsRule
extends AbstractRule {
    private Set singleTypeImports;
    private Set importOnDemandImports;

    public Object visit(ASTCompilationUnit node, Object data) {
        this.singleTypeImports = new HashSet();
        this.importOnDemandImports = new HashSet();
        super.visit(node, data);
        Iterator i = this.importOnDemandImports.iterator();
        while (i.hasNext()) {
            ImportWrapper thisImportOnDemand = (ImportWrapper)i.next();
            Iterator j = this.singleTypeImports.iterator();
            while (j.hasNext()) {
                ImportWrapper thisSingleTypeImport = (ImportWrapper)j.next();
                String singleTypePkg = thisSingleTypeImport.getName().substring(0, thisSingleTypeImport.getName().lastIndexOf(46));
                if (!thisImportOnDemand.getName().equals(singleTypePkg)) continue;
                this.addViolation(data, thisSingleTypeImport.getNode(), thisSingleTypeImport.getName());
            }
        }
        this.singleTypeImports.clear();
        this.importOnDemandImports.clear();
        return data;
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        ImportWrapper wrapper = new ImportWrapper(node.getImportedName(), node.getImportedName(), node.getImportedNameNode());
        if (node.isImportOnDemand()) {
            if (this.importOnDemandImports.contains(wrapper)) {
                this.addViolation(data, node.getImportedNameNode(), node.getImportedNameNode().getImage());
            } else {
                this.importOnDemandImports.add(wrapper);
            }
        } else if (this.singleTypeImports.contains(wrapper)) {
            this.addViolation(data, node.getImportedNameNode(), node.getImportedNameNode().getImage());
        } else {
            this.singleTypeImports.add(wrapper);
        }
        return data;
    }
}

