/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.junit;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;

public class TestClassWithoutTestCases
extends AbstractRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isAbstract() || node.isInterface() || node.isNested()) {
            return data;
        }
        String className = node.getImage();
        if (className.endsWith("Test")) {
            List m = node.findChildrenOfType(ASTMethodDeclarator.class);
            boolean testsFound = false;
            if (m != null) {
                Iterator it = m.iterator();
                while (it.hasNext() && !testsFound) {
                    ASTMethodDeclarator md = (ASTMethodDeclarator)it.next();
                    if (this.isInInnerClassOrInterface(md) || !md.getImage().startsWith("test")) continue;
                    testsFound = true;
                }
            }
            if (!testsFound) {
                this.addViolation(data, node);
            }
        }
        return data;
    }

    private boolean isInInnerClassOrInterface(ASTMethodDeclarator md) {
        ASTClassOrInterfaceDeclaration p = (ASTClassOrInterfaceDeclaration)md.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        return p != null && p.isNested();
    }
}

