<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/logservice/log_service.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/api/api_base_pb.php';
}
namespace google\appengine\LogServiceError {
  class ErrorCode {
    const OK = 0;
    const INVALID_REQUEST = 1;
    const STORAGE_ERROR = 2;
  }
}
namespace google\appengine {
  class LogServiceError extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class UserAppLogLine extends \google\net\ProtocolMessage {
    public function getTimestampUsec() {
      if (!isset($this->timestamp_usec)) {
        return "0";
      }
      return $this->timestamp_usec;
    }
    public function setTimestampUsec($val) {
      if (is_double($val)) {
        $this->timestamp_usec = sprintf('%0.0F', $val);
      } else {
        $this->timestamp_usec = $val;
      }
      return $this;
    }
    public function clearTimestampUsec() {
      unset($this->timestamp_usec);
      return $this;
    }
    public function hasTimestampUsec() {
      return isset($this->timestamp_usec);
    }
    public function getLevel() {
      if (!isset($this->level)) {
        return "0";
      }
      return $this->level;
    }
    public function setLevel($val) {
      if (is_double($val)) {
        $this->level = sprintf('%0.0F', $val);
      } else {
        $this->level = $val;
      }
      return $this;
    }
    public function clearLevel() {
      unset($this->level);
      return $this;
    }
    public function hasLevel() {
      return isset($this->level);
    }
    public function getMessage() {
      if (!isset($this->message)) {
        return '';
      }
      return $this->message;
    }
    public function setMessage($val) {
      $this->message = $val;
      return $this;
    }
    public function clearMessage() {
      unset($this->message);
      return $this;
    }
    public function hasMessage() {
      return isset($this->message);
    }
    public function clear() {
      $this->clearTimestampUsec();
      $this->clearLevel();
      $this->clearMessage();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->timestamp_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->timestamp_usec);
      }
      if (isset($this->level)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->level);
      }
      if (isset($this->message)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->message));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->timestamp_usec)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->timestamp_usec);
      }
      if (isset($this->level)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->level);
      }
      if (isset($this->message)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->message);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setTimestampUsec($d->getVarInt64());
            break;
          case 16:
            $this->setLevel($d->getVarInt64());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setMessage(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->timestamp_usec)) return 'timestamp_usec';
      if (!isset($this->level)) return 'level';
      if (!isset($this->message)) return 'message';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTimestampUsec()) {
        $this->setTimestampUsec($x->getTimestampUsec());
      }
      if ($x->hasLevel()) {
        $this->setLevel($x->getLevel());
      }
      if ($x->hasMessage()) {
        $this->setMessage($x->getMessage());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->timestamp_usec) !== isset($x->timestamp_usec)) return false;
      if (isset($this->timestamp_usec) && !$this->integerEquals($this->timestamp_usec, $x->timestamp_usec)) return false;
      if (isset($this->level) !== isset($x->level)) return false;
      if (isset($this->level) && !$this->integerEquals($this->level, $x->level)) return false;
      if (isset($this->message) !== isset($x->message)) return false;
      if (isset($this->message) && $this->message !== $x->message) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->timestamp_usec)) {
        $res .= $prefix . "timestamp_usec: " . $this->debugFormatInt64($this->timestamp_usec) . "\n";
      }
      if (isset($this->level)) {
        $res .= $prefix . "level: " . $this->debugFormatInt64($this->level) . "\n";
      }
      if (isset($this->message)) {
        $res .= $prefix . "message: " . $this->debugFormatString($this->message) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class UserAppLogGroup extends \google\net\ProtocolMessage {
    private $log_line = array();
    public function getLogLineSize() {
      return sizeof($this->log_line);
    }
    public function getLogLineList() {
      return $this->log_line;
    }
    public function mutableLogLine($idx) {
      if (!isset($this->log_line[$idx])) {
        $val = new \google\appengine\UserAppLogLine();
        $this->log_line[$idx] = $val;
        return $val;
      }
      return $this->log_line[$idx];
    }
    public function getLogLine($idx) {
      if (isset($this->log_line[$idx])) {
        return $this->log_line[$idx];
      }
      if ($idx >= end(array_keys($this->log_line))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\UserAppLogLine();
    }
    public function addLogLine() {
      $val = new \google\appengine\UserAppLogLine();
      $this->log_line[] = $val;
      return $val;
    }
    public function clearLogLine() {
      $this->log_line = array();
    }
    public function clear() {
      $this->clearLogLine();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->log_line);
      $res += 1 * sizeof($this->log_line);
      foreach ($this->log_line as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->log_line);
      foreach ($this->log_line as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addLogLine()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->log_line as $value) {
        if (!$value->isInitialized()) return 'log_line';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getLogLineList() as $v) {
        $this->addLogLine()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->log_line) !== sizeof($x->log_line)) return false;
      foreach (array_map(null, $this->log_line, $x->log_line) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->log_line as $value) {
        $res .= $prefix . "log_line <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class FlushRequest extends \google\net\ProtocolMessage {
    public function getLogs() {
      if (!isset($this->logs)) {
        return '';
      }
      return $this->logs;
    }
    public function setLogs($val) {
      $this->logs = $val;
      return $this;
    }
    public function clearLogs() {
      unset($this->logs);
      return $this;
    }
    public function hasLogs() {
      return isset($this->logs);
    }
    public function clear() {
      $this->clearLogs();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->logs)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->logs));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->logs)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->logs);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setLogs(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasLogs()) {
        $this->setLogs($x->getLogs());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->logs) !== isset($x->logs)) return false;
      if (isset($this->logs) && $this->logs !== $x->logs) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->logs)) {
        $res .= $prefix . "logs: " . $this->debugFormatString($this->logs) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class SetStatusRequest extends \google\net\ProtocolMessage {
    public function getStatus() {
      if (!isset($this->status)) {
        return '';
      }
      return $this->status;
    }
    public function setStatus($val) {
      $this->status = $val;
      return $this;
    }
    public function clearStatus() {
      unset($this->status);
      return $this;
    }
    public function hasStatus() {
      return isset($this->status);
    }
    public function clear() {
      $this->clearStatus();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->status)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->status));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->status)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->status);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setStatus(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->status)) return 'status';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasStatus()) {
        $this->setStatus($x->getStatus());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->status) !== isset($x->status)) return false;
      if (isset($this->status) && $this->status !== $x->status) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->status)) {
        $res .= $prefix . "status: " . $this->debugFormatString($this->status) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogOffset extends \google\net\ProtocolMessage {
    public function getRequestId() {
      if (!isset($this->request_id)) {
        return '';
      }
      return $this->request_id;
    }
    public function setRequestId($val) {
      $this->request_id = $val;
      return $this;
    }
    public function clearRequestId() {
      unset($this->request_id);
      return $this;
    }
    public function hasRequestId() {
      return isset($this->request_id);
    }
    public function clear() {
      $this->clearRequestId();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->request_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->request_id));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->request_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->request_id);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setRequestId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasRequestId()) {
        $this->setRequestId($x->getRequestId());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->request_id) !== isset($x->request_id)) return false;
      if (isset($this->request_id) && $this->request_id !== $x->request_id) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->request_id)) {
        $res .= $prefix . "request_id: " . $this->debugFormatString($this->request_id) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogLine extends \google\net\ProtocolMessage {
    public function getTime() {
      if (!isset($this->time)) {
        return "0";
      }
      return $this->time;
    }
    public function setTime($val) {
      if (is_double($val)) {
        $this->time = sprintf('%0.0F', $val);
      } else {
        $this->time = $val;
      }
      return $this;
    }
    public function clearTime() {
      unset($this->time);
      return $this;
    }
    public function hasTime() {
      return isset($this->time);
    }
    public function getLevel() {
      if (!isset($this->level)) {
        return 0;
      }
      return $this->level;
    }
    public function setLevel($val) {
      $this->level = $val;
      return $this;
    }
    public function clearLevel() {
      unset($this->level);
      return $this;
    }
    public function hasLevel() {
      return isset($this->level);
    }
    public function getLogMessage() {
      if (!isset($this->log_message)) {
        return '';
      }
      return $this->log_message;
    }
    public function setLogMessage($val) {
      $this->log_message = $val;
      return $this;
    }
    public function clearLogMessage() {
      unset($this->log_message);
      return $this;
    }
    public function hasLogMessage() {
      return isset($this->log_message);
    }
    public function clear() {
      $this->clearTime();
      $this->clearLevel();
      $this->clearLogMessage();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->time);
      }
      if (isset($this->level)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->level);
      }
      if (isset($this->log_message)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->log_message));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->time)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->time);
      }
      if (isset($this->level)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->level);
      }
      if (isset($this->log_message)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->log_message);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setTime($d->getVarInt64());
            break;
          case 16:
            $this->setLevel($d->getVarInt32());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setLogMessage(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->time)) return 'time';
      if (!isset($this->level)) return 'level';
      if (!isset($this->log_message)) return 'log_message';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTime()) {
        $this->setTime($x->getTime());
      }
      if ($x->hasLevel()) {
        $this->setLevel($x->getLevel());
      }
      if ($x->hasLogMessage()) {
        $this->setLogMessage($x->getLogMessage());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->time) !== isset($x->time)) return false;
      if (isset($this->time) && !$this->integerEquals($this->time, $x->time)) return false;
      if (isset($this->level) !== isset($x->level)) return false;
      if (isset($this->level) && !$this->integerEquals($this->level, $x->level)) return false;
      if (isset($this->log_message) !== isset($x->log_message)) return false;
      if (isset($this->log_message) && $this->log_message !== $x->log_message) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->time)) {
        $res .= $prefix . "time: " . $this->debugFormatInt64($this->time) . "\n";
      }
      if (isset($this->level)) {
        $res .= $prefix . "level: " . $this->debugFormatInt32($this->level) . "\n";
      }
      if (isset($this->log_message)) {
        $res .= $prefix . "log_message: " . $this->debugFormatString($this->log_message) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class RequestLog extends \google\net\ProtocolMessage {
    private $line = array();
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getVersionId() {
      if (!isset($this->version_id)) {
        return '';
      }
      return $this->version_id;
    }
    public function setVersionId($val) {
      $this->version_id = $val;
      return $this;
    }
    public function clearVersionId() {
      unset($this->version_id);
      return $this;
    }
    public function hasVersionId() {
      return isset($this->version_id);
    }
    public function getRequestId() {
      if (!isset($this->request_id)) {
        return '';
      }
      return $this->request_id;
    }
    public function setRequestId($val) {
      $this->request_id = $val;
      return $this;
    }
    public function clearRequestId() {
      unset($this->request_id);
      return $this;
    }
    public function hasRequestId() {
      return isset($this->request_id);
    }
    public function getIp() {
      if (!isset($this->ip)) {
        return '';
      }
      return $this->ip;
    }
    public function setIp($val) {
      $this->ip = $val;
      return $this;
    }
    public function clearIp() {
      unset($this->ip);
      return $this;
    }
    public function hasIp() {
      return isset($this->ip);
    }
    public function getNickname() {
      if (!isset($this->nickname)) {
        return '';
      }
      return $this->nickname;
    }
    public function setNickname($val) {
      $this->nickname = $val;
      return $this;
    }
    public function clearNickname() {
      unset($this->nickname);
      return $this;
    }
    public function hasNickname() {
      return isset($this->nickname);
    }
    public function getStartTime() {
      if (!isset($this->start_time)) {
        return "0";
      }
      return $this->start_time;
    }
    public function setStartTime($val) {
      if (is_double($val)) {
        $this->start_time = sprintf('%0.0F', $val);
      } else {
        $this->start_time = $val;
      }
      return $this;
    }
    public function clearStartTime() {
      unset($this->start_time);
      return $this;
    }
    public function hasStartTime() {
      return isset($this->start_time);
    }
    public function getEndTime() {
      if (!isset($this->end_time)) {
        return "0";
      }
      return $this->end_time;
    }
    public function setEndTime($val) {
      if (is_double($val)) {
        $this->end_time = sprintf('%0.0F', $val);
      } else {
        $this->end_time = $val;
      }
      return $this;
    }
    public function clearEndTime() {
      unset($this->end_time);
      return $this;
    }
    public function hasEndTime() {
      return isset($this->end_time);
    }
    public function getLatency() {
      if (!isset($this->latency)) {
        return "0";
      }
      return $this->latency;
    }
    public function setLatency($val) {
      if (is_double($val)) {
        $this->latency = sprintf('%0.0F', $val);
      } else {
        $this->latency = $val;
      }
      return $this;
    }
    public function clearLatency() {
      unset($this->latency);
      return $this;
    }
    public function hasLatency() {
      return isset($this->latency);
    }
    public function getMcycles() {
      if (!isset($this->mcycles)) {
        return "0";
      }
      return $this->mcycles;
    }
    public function setMcycles($val) {
      if (is_double($val)) {
        $this->mcycles = sprintf('%0.0F', $val);
      } else {
        $this->mcycles = $val;
      }
      return $this;
    }
    public function clearMcycles() {
      unset($this->mcycles);
      return $this;
    }
    public function hasMcycles() {
      return isset($this->mcycles);
    }
    public function getMethod() {
      if (!isset($this->method)) {
        return '';
      }
      return $this->method;
    }
    public function setMethod($val) {
      $this->method = $val;
      return $this;
    }
    public function clearMethod() {
      unset($this->method);
      return $this;
    }
    public function hasMethod() {
      return isset($this->method);
    }
    public function getResource() {
      if (!isset($this->resource)) {
        return '';
      }
      return $this->resource;
    }
    public function setResource($val) {
      $this->resource = $val;
      return $this;
    }
    public function clearResource() {
      unset($this->resource);
      return $this;
    }
    public function hasResource() {
      return isset($this->resource);
    }
    public function getHttpVersion() {
      if (!isset($this->http_version)) {
        return '';
      }
      return $this->http_version;
    }
    public function setHttpVersion($val) {
      $this->http_version = $val;
      return $this;
    }
    public function clearHttpVersion() {
      unset($this->http_version);
      return $this;
    }
    public function hasHttpVersion() {
      return isset($this->http_version);
    }
    public function getStatus() {
      if (!isset($this->status)) {
        return 0;
      }
      return $this->status;
    }
    public function setStatus($val) {
      $this->status = $val;
      return $this;
    }
    public function clearStatus() {
      unset($this->status);
      return $this;
    }
    public function hasStatus() {
      return isset($this->status);
    }
    public function getResponseSize() {
      if (!isset($this->response_size)) {
        return "0";
      }
      return $this->response_size;
    }
    public function setResponseSize($val) {
      if (is_double($val)) {
        $this->response_size = sprintf('%0.0F', $val);
      } else {
        $this->response_size = $val;
      }
      return $this;
    }
    public function clearResponseSize() {
      unset($this->response_size);
      return $this;
    }
    public function hasResponseSize() {
      return isset($this->response_size);
    }
    public function getReferrer() {
      if (!isset($this->referrer)) {
        return '';
      }
      return $this->referrer;
    }
    public function setReferrer($val) {
      $this->referrer = $val;
      return $this;
    }
    public function clearReferrer() {
      unset($this->referrer);
      return $this;
    }
    public function hasReferrer() {
      return isset($this->referrer);
    }
    public function getUserAgent() {
      if (!isset($this->user_agent)) {
        return '';
      }
      return $this->user_agent;
    }
    public function setUserAgent($val) {
      $this->user_agent = $val;
      return $this;
    }
    public function clearUserAgent() {
      unset($this->user_agent);
      return $this;
    }
    public function hasUserAgent() {
      return isset($this->user_agent);
    }
    public function getUrlMapEntry() {
      if (!isset($this->url_map_entry)) {
        return '';
      }
      return $this->url_map_entry;
    }
    public function setUrlMapEntry($val) {
      $this->url_map_entry = $val;
      return $this;
    }
    public function clearUrlMapEntry() {
      unset($this->url_map_entry);
      return $this;
    }
    public function hasUrlMapEntry() {
      return isset($this->url_map_entry);
    }
    public function getCombined() {
      if (!isset($this->combined)) {
        return '';
      }
      return $this->combined;
    }
    public function setCombined($val) {
      $this->combined = $val;
      return $this;
    }
    public function clearCombined() {
      unset($this->combined);
      return $this;
    }
    public function hasCombined() {
      return isset($this->combined);
    }
    public function getApiMcycles() {
      if (!isset($this->api_mcycles)) {
        return "0";
      }
      return $this->api_mcycles;
    }
    public function setApiMcycles($val) {
      if (is_double($val)) {
        $this->api_mcycles = sprintf('%0.0F', $val);
      } else {
        $this->api_mcycles = $val;
      }
      return $this;
    }
    public function clearApiMcycles() {
      unset($this->api_mcycles);
      return $this;
    }
    public function hasApiMcycles() {
      return isset($this->api_mcycles);
    }
    public function getHost() {
      if (!isset($this->host)) {
        return '';
      }
      return $this->host;
    }
    public function setHost($val) {
      $this->host = $val;
      return $this;
    }
    public function clearHost() {
      unset($this->host);
      return $this;
    }
    public function hasHost() {
      return isset($this->host);
    }
    public function getCost() {
      if (!isset($this->cost)) {
        return 0.0;
      }
      return $this->cost;
    }
    public function setCost($val) {
      $this->cost = $val;
      return $this;
    }
    public function clearCost() {
      unset($this->cost);
      return $this;
    }
    public function hasCost() {
      return isset($this->cost);
    }
    public function getTaskQueueName() {
      if (!isset($this->task_queue_name)) {
        return '';
      }
      return $this->task_queue_name;
    }
    public function setTaskQueueName($val) {
      $this->task_queue_name = $val;
      return $this;
    }
    public function clearTaskQueueName() {
      unset($this->task_queue_name);
      return $this;
    }
    public function hasTaskQueueName() {
      return isset($this->task_queue_name);
    }
    public function getTaskName() {
      if (!isset($this->task_name)) {
        return '';
      }
      return $this->task_name;
    }
    public function setTaskName($val) {
      $this->task_name = $val;
      return $this;
    }
    public function clearTaskName() {
      unset($this->task_name);
      return $this;
    }
    public function hasTaskName() {
      return isset($this->task_name);
    }
    public function getWasLoadingRequest() {
      if (!isset($this->was_loading_request)) {
        return false;
      }
      return $this->was_loading_request;
    }
    public function setWasLoadingRequest($val) {
      $this->was_loading_request = $val;
      return $this;
    }
    public function clearWasLoadingRequest() {
      unset($this->was_loading_request);
      return $this;
    }
    public function hasWasLoadingRequest() {
      return isset($this->was_loading_request);
    }
    public function getPendingTime() {
      if (!isset($this->pending_time)) {
        return "0";
      }
      return $this->pending_time;
    }
    public function setPendingTime($val) {
      if (is_double($val)) {
        $this->pending_time = sprintf('%0.0F', $val);
      } else {
        $this->pending_time = $val;
      }
      return $this;
    }
    public function clearPendingTime() {
      unset($this->pending_time);
      return $this;
    }
    public function hasPendingTime() {
      return isset($this->pending_time);
    }
    public function getReplicaIndex() {
      if (!isset($this->replica_index)) {
        return -1;
      }
      return $this->replica_index;
    }
    public function setReplicaIndex($val) {
      $this->replica_index = $val;
      return $this;
    }
    public function clearReplicaIndex() {
      unset($this->replica_index);
      return $this;
    }
    public function hasReplicaIndex() {
      return isset($this->replica_index);
    }
    public function getFinished() {
      if (!isset($this->finished)) {
        return true;
      }
      return $this->finished;
    }
    public function setFinished($val) {
      $this->finished = $val;
      return $this;
    }
    public function clearFinished() {
      unset($this->finished);
      return $this;
    }
    public function hasFinished() {
      return isset($this->finished);
    }
    public function getCloneKey() {
      if (!isset($this->clone_key)) {
        return '';
      }
      return $this->clone_key;
    }
    public function setCloneKey($val) {
      $this->clone_key = $val;
      return $this;
    }
    public function clearCloneKey() {
      unset($this->clone_key);
      return $this;
    }
    public function hasCloneKey() {
      return isset($this->clone_key);
    }
    public function getLineSize() {
      return sizeof($this->line);
    }
    public function getLineList() {
      return $this->line;
    }
    public function mutableLine($idx) {
      if (!isset($this->line[$idx])) {
        $val = new \google\appengine\LogLine();
        $this->line[$idx] = $val;
        return $val;
      }
      return $this->line[$idx];
    }
    public function getLine($idx) {
      if (isset($this->line[$idx])) {
        return $this->line[$idx];
      }
      if ($idx >= end(array_keys($this->line))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\LogLine();
    }
    public function addLine() {
      $val = new \google\appengine\LogLine();
      $this->line[] = $val;
      return $val;
    }
    public function clearLine() {
      $this->line = array();
    }
    public function getExitReason() {
      if (!isset($this->exit_reason)) {
        return 0;
      }
      return $this->exit_reason;
    }
    public function setExitReason($val) {
      $this->exit_reason = $val;
      return $this;
    }
    public function clearExitReason() {
      unset($this->exit_reason);
      return $this;
    }
    public function hasExitReason() {
      return isset($this->exit_reason);
    }
    public function getWasThrottledForTime() {
      if (!isset($this->was_throttled_for_time)) {
        return false;
      }
      return $this->was_throttled_for_time;
    }
    public function setWasThrottledForTime($val) {
      $this->was_throttled_for_time = $val;
      return $this;
    }
    public function clearWasThrottledForTime() {
      unset($this->was_throttled_for_time);
      return $this;
    }
    public function hasWasThrottledForTime() {
      return isset($this->was_throttled_for_time);
    }
    public function getWasThrottledForRequests() {
      if (!isset($this->was_throttled_for_requests)) {
        return false;
      }
      return $this->was_throttled_for_requests;
    }
    public function setWasThrottledForRequests($val) {
      $this->was_throttled_for_requests = $val;
      return $this;
    }
    public function clearWasThrottledForRequests() {
      unset($this->was_throttled_for_requests);
      return $this;
    }
    public function hasWasThrottledForRequests() {
      return isset($this->was_throttled_for_requests);
    }
    public function getThrottledTime() {
      if (!isset($this->throttled_time)) {
        return "0";
      }
      return $this->throttled_time;
    }
    public function setThrottledTime($val) {
      if (is_double($val)) {
        $this->throttled_time = sprintf('%0.0F', $val);
      } else {
        $this->throttled_time = $val;
      }
      return $this;
    }
    public function clearThrottledTime() {
      unset($this->throttled_time);
      return $this;
    }
    public function hasThrottledTime() {
      return isset($this->throttled_time);
    }
    public function getServerName() {
      if (!isset($this->server_name)) {
        return '';
      }
      return $this->server_name;
    }
    public function setServerName($val) {
      $this->server_name = $val;
      return $this;
    }
    public function clearServerName() {
      unset($this->server_name);
      return $this;
    }
    public function hasServerName() {
      return isset($this->server_name);
    }
    public function getOffset() {
      if (!isset($this->offset)) {
        return new \google\appengine\LogOffset();
      }
      return $this->offset;
    }
    public function mutableOffset() {
      if (!isset($this->offset)) {
        $res = new \google\appengine\LogOffset();
        $this->offset = $res;
        return $res;
      }
      return $this->offset;
    }
    public function clearOffset() {
      if (isset($this->offset)) {
        unset($this->offset);
      }
    }
    public function hasOffset() {
      return isset($this->offset);
    }
    public function getLinesIncomplete() {
      if (!isset($this->lines_incomplete)) {
        return false;
      }
      return $this->lines_incomplete;
    }
    public function setLinesIncomplete($val) {
      $this->lines_incomplete = $val;
      return $this;
    }
    public function clearLinesIncomplete() {
      unset($this->lines_incomplete);
      return $this;
    }
    public function hasLinesIncomplete() {
      return isset($this->lines_incomplete);
    }
    public function getModuleId() {
      if (!isset($this->module_id)) {
        return "default";
      }
      return $this->module_id;
    }
    public function setModuleId($val) {
      $this->module_id = $val;
      return $this;
    }
    public function clearModuleId() {
      unset($this->module_id);
      return $this;
    }
    public function hasModuleId() {
      return isset($this->module_id);
    }
    public function getAppEngineRelease() {
      if (!isset($this->app_engine_release)) {
        return '';
      }
      return $this->app_engine_release;
    }
    public function setAppEngineRelease($val) {
      $this->app_engine_release = $val;
      return $this;
    }
    public function clearAppEngineRelease() {
      unset($this->app_engine_release);
      return $this;
    }
    public function hasAppEngineRelease() {
      return isset($this->app_engine_release);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearVersionId();
      $this->clearRequestId();
      $this->clearIp();
      $this->clearNickname();
      $this->clearStartTime();
      $this->clearEndTime();
      $this->clearLatency();
      $this->clearMcycles();
      $this->clearMethod();
      $this->clearResource();
      $this->clearHttpVersion();
      $this->clearStatus();
      $this->clearResponseSize();
      $this->clearReferrer();
      $this->clearUserAgent();
      $this->clearUrlMapEntry();
      $this->clearCombined();
      $this->clearApiMcycles();
      $this->clearHost();
      $this->clearCost();
      $this->clearTaskQueueName();
      $this->clearTaskName();
      $this->clearWasLoadingRequest();
      $this->clearPendingTime();
      $this->clearReplicaIndex();
      $this->clearFinished();
      $this->clearCloneKey();
      $this->clearLine();
      $this->clearExitReason();
      $this->clearWasThrottledForTime();
      $this->clearWasThrottledForRequests();
      $this->clearThrottledTime();
      $this->clearServerName();
      $this->clearOffset();
      $this->clearLinesIncomplete();
      $this->clearModuleId();
      $this->clearAppEngineRelease();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->version_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version_id));
      }
      if (isset($this->request_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->request_id));
      }
      if (isset($this->ip)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->ip));
      }
      if (isset($this->nickname)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->nickname));
      }
      if (isset($this->start_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->start_time);
      }
      if (isset($this->end_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->end_time);
      }
      if (isset($this->latency)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->latency);
      }
      if (isset($this->mcycles)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->mcycles);
      }
      if (isset($this->method)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->method));
      }
      if (isset($this->resource)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->resource));
      }
      if (isset($this->http_version)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->http_version));
      }
      if (isset($this->status)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->status);
      }
      if (isset($this->response_size)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->response_size);
      }
      if (isset($this->referrer)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->referrer));
      }
      if (isset($this->user_agent)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->user_agent));
      }
      if (isset($this->url_map_entry)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->url_map_entry));
      }
      if (isset($this->combined)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->combined));
      }
      if (isset($this->api_mcycles)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->api_mcycles);
      }
      if (isset($this->host)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->host));
      }
      if (isset($this->cost)) {
        $res += 10;
      }
      if (isset($this->task_queue_name)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->task_queue_name));
      }
      if (isset($this->task_name)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->task_name));
      }
      if (isset($this->was_loading_request)) {
        $res += 3;
      }
      if (isset($this->pending_time)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->pending_time);
      }
      if (isset($this->replica_index)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->replica_index);
      }
      if (isset($this->finished)) {
        $res += 3;
      }
      if (isset($this->clone_key)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->clone_key));
      }
      $this->checkProtoArray($this->line);
      $res += 2 * sizeof($this->line);
      foreach ($this->line as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->exit_reason)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->exit_reason);
      }
      if (isset($this->was_throttled_for_time)) {
        $res += 3;
      }
      if (isset($this->was_throttled_for_requests)) {
        $res += 3;
      }
      if (isset($this->throttled_time)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->throttled_time);
      }
      if (isset($this->server_name)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->server_name));
      }
      if (isset($this->offset)) {
        $res += 2;
        $res += $this->lengthString($this->offset->byteSizePartial());
      }
      if (isset($this->lines_incomplete)) {
        $res += 3;
      }
      if (isset($this->module_id)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->module_id));
      }
      if (isset($this->app_engine_release)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->app_engine_release));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->version_id)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->version_id);
      }
      if (isset($this->request_id)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->request_id);
      }
      if (isset($this->ip)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->ip);
      }
      if (isset($this->nickname)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->nickname);
      }
      if (isset($this->start_time)) {
        $out->putVarInt32(48);
        $out->putVarInt64($this->start_time);
      }
      if (isset($this->end_time)) {
        $out->putVarInt32(56);
        $out->putVarInt64($this->end_time);
      }
      if (isset($this->latency)) {
        $out->putVarInt32(64);
        $out->putVarInt64($this->latency);
      }
      if (isset($this->mcycles)) {
        $out->putVarInt32(72);
        $out->putVarInt64($this->mcycles);
      }
      if (isset($this->method)) {
        $out->putVarInt32(82);
        $out->putPrefixedString($this->method);
      }
      if (isset($this->resource)) {
        $out->putVarInt32(90);
        $out->putPrefixedString($this->resource);
      }
      if (isset($this->http_version)) {
        $out->putVarInt32(98);
        $out->putPrefixedString($this->http_version);
      }
      if (isset($this->status)) {
        $out->putVarInt32(104);
        $out->putVarInt32($this->status);
      }
      if (isset($this->response_size)) {
        $out->putVarInt32(112);
        $out->putVarInt64($this->response_size);
      }
      if (isset($this->referrer)) {
        $out->putVarInt32(122);
        $out->putPrefixedString($this->referrer);
      }
      if (isset($this->user_agent)) {
        $out->putVarInt32(130);
        $out->putPrefixedString($this->user_agent);
      }
      if (isset($this->url_map_entry)) {
        $out->putVarInt32(138);
        $out->putPrefixedString($this->url_map_entry);
      }
      if (isset($this->combined)) {
        $out->putVarInt32(146);
        $out->putPrefixedString($this->combined);
      }
      if (isset($this->api_mcycles)) {
        $out->putVarInt32(152);
        $out->putVarInt64($this->api_mcycles);
      }
      if (isset($this->host)) {
        $out->putVarInt32(162);
        $out->putPrefixedString($this->host);
      }
      if (isset($this->cost)) {
        $out->putVarInt32(169);
        $out->putDouble($this->cost);
      }
      if (isset($this->task_queue_name)) {
        $out->putVarInt32(178);
        $out->putPrefixedString($this->task_queue_name);
      }
      if (isset($this->task_name)) {
        $out->putVarInt32(186);
        $out->putPrefixedString($this->task_name);
      }
      if (isset($this->was_loading_request)) {
        $out->putVarInt32(192);
        $out->putBoolean($this->was_loading_request);
      }
      if (isset($this->pending_time)) {
        $out->putVarInt32(200);
        $out->putVarInt64($this->pending_time);
      }
      if (isset($this->replica_index)) {
        $out->putVarInt32(208);
        $out->putVarInt32($this->replica_index);
      }
      if (isset($this->finished)) {
        $out->putVarInt32(216);
        $out->putBoolean($this->finished);
      }
      if (isset($this->clone_key)) {
        $out->putVarInt32(226);
        $out->putPrefixedString($this->clone_key);
      }
      $this->checkProtoArray($this->line);
      foreach ($this->line as $value) {
        $out->putVarInt32(234);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->exit_reason)) {
        $out->putVarInt32(240);
        $out->putVarInt32($this->exit_reason);
      }
      if (isset($this->was_throttled_for_time)) {
        $out->putVarInt32(248);
        $out->putBoolean($this->was_throttled_for_time);
      }
      if (isset($this->was_throttled_for_requests)) {
        $out->putVarInt32(256);
        $out->putBoolean($this->was_throttled_for_requests);
      }
      if (isset($this->throttled_time)) {
        $out->putVarInt32(264);
        $out->putVarInt64($this->throttled_time);
      }
      if (isset($this->server_name)) {
        $out->putVarInt32(274);
        $out->putPrefixedString($this->server_name);
      }
      if (isset($this->offset)) {
        $out->putVarInt32(282);
        $out->putVarInt32($this->offset->byteSizePartial());
        $this->offset->outputPartial($out);
      }
      if (isset($this->lines_incomplete)) {
        $out->putVarInt32(288);
        $out->putBoolean($this->lines_incomplete);
      }
      if (isset($this->module_id)) {
        $out->putVarInt32(298);
        $out->putPrefixedString($this->module_id);
      }
      if (isset($this->app_engine_release)) {
        $out->putVarInt32(306);
        $out->putPrefixedString($this->app_engine_release);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setVersionId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setRequestId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setIp(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setNickname(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 48:
            $this->setStartTime($d->getVarInt64());
            break;
          case 56:
            $this->setEndTime($d->getVarInt64());
            break;
          case 64:
            $this->setLatency($d->getVarInt64());
            break;
          case 72:
            $this->setMcycles($d->getVarInt64());
            break;
          case 82:
            $length = $d->getVarInt32();
            $this->setMethod(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 90:
            $length = $d->getVarInt32();
            $this->setResource(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 98:
            $length = $d->getVarInt32();
            $this->setHttpVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 104:
            $this->setStatus($d->getVarInt32());
            break;
          case 112:
            $this->setResponseSize($d->getVarInt64());
            break;
          case 122:
            $length = $d->getVarInt32();
            $this->setReferrer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 130:
            $length = $d->getVarInt32();
            $this->setUserAgent(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 138:
            $length = $d->getVarInt32();
            $this->setUrlMapEntry(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 146:
            $length = $d->getVarInt32();
            $this->setCombined(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 152:
            $this->setApiMcycles($d->getVarInt64());
            break;
          case 162:
            $length = $d->getVarInt32();
            $this->setHost(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 169:
            $this->setCost($d->getDouble());
            break;
          case 178:
            $length = $d->getVarInt32();
            $this->setTaskQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 186:
            $length = $d->getVarInt32();
            $this->setTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 192:
            $this->setWasLoadingRequest($d->getBoolean());
            break;
          case 200:
            $this->setPendingTime($d->getVarInt64());
            break;
          case 208:
            $this->setReplicaIndex($d->getVarInt32());
            break;
          case 216:
            $this->setFinished($d->getBoolean());
            break;
          case 226:
            $length = $d->getVarInt32();
            $this->setCloneKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 234:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addLine()->tryMerge($tmp);
            break;
          case 240:
            $this->setExitReason($d->getVarInt32());
            break;
          case 248:
            $this->setWasThrottledForTime($d->getBoolean());
            break;
          case 256:
            $this->setWasThrottledForRequests($d->getBoolean());
            break;
          case 264:
            $this->setThrottledTime($d->getVarInt64());
            break;
          case 274:
            $length = $d->getVarInt32();
            $this->setServerName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 282:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOffset()->tryMerge($tmp);
            break;
          case 288:
            $this->setLinesIncomplete($d->getBoolean());
            break;
          case 298:
            $length = $d->getVarInt32();
            $this->setModuleId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 306:
            $length = $d->getVarInt32();
            $this->setAppEngineRelease(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      if (!isset($this->version_id)) return 'version_id';
      if (!isset($this->request_id)) return 'request_id';
      if (!isset($this->ip)) return 'ip';
      if (!isset($this->start_time)) return 'start_time';
      if (!isset($this->end_time)) return 'end_time';
      if (!isset($this->latency)) return 'latency';
      if (!isset($this->mcycles)) return 'mcycles';
      if (!isset($this->method)) return 'method';
      if (!isset($this->resource)) return 'resource';
      if (!isset($this->http_version)) return 'http_version';
      if (!isset($this->status)) return 'status';
      if (!isset($this->response_size)) return 'response_size';
      if (!isset($this->url_map_entry)) return 'url_map_entry';
      if (!isset($this->combined)) return 'combined';
      foreach ($this->line as $value) {
        if (!$value->isInitialized()) return 'line';
      }
      if (isset($this->offset) && (!$this->offset->isInitialized())) return 'offset';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasVersionId()) {
        $this->setVersionId($x->getVersionId());
      }
      if ($x->hasRequestId()) {
        $this->setRequestId($x->getRequestId());
      }
      if ($x->hasIp()) {
        $this->setIp($x->getIp());
      }
      if ($x->hasNickname()) {
        $this->setNickname($x->getNickname());
      }
      if ($x->hasStartTime()) {
        $this->setStartTime($x->getStartTime());
      }
      if ($x->hasEndTime()) {
        $this->setEndTime($x->getEndTime());
      }
      if ($x->hasLatency()) {
        $this->setLatency($x->getLatency());
      }
      if ($x->hasMcycles()) {
        $this->setMcycles($x->getMcycles());
      }
      if ($x->hasMethod()) {
        $this->setMethod($x->getMethod());
      }
      if ($x->hasResource()) {
        $this->setResource($x->getResource());
      }
      if ($x->hasHttpVersion()) {
        $this->setHttpVersion($x->getHttpVersion());
      }
      if ($x->hasStatus()) {
        $this->setStatus($x->getStatus());
      }
      if ($x->hasResponseSize()) {
        $this->setResponseSize($x->getResponseSize());
      }
      if ($x->hasReferrer()) {
        $this->setReferrer($x->getReferrer());
      }
      if ($x->hasUserAgent()) {
        $this->setUserAgent($x->getUserAgent());
      }
      if ($x->hasUrlMapEntry()) {
        $this->setUrlMapEntry($x->getUrlMapEntry());
      }
      if ($x->hasCombined()) {
        $this->setCombined($x->getCombined());
      }
      if ($x->hasApiMcycles()) {
        $this->setApiMcycles($x->getApiMcycles());
      }
      if ($x->hasHost()) {
        $this->setHost($x->getHost());
      }
      if ($x->hasCost()) {
        $this->setCost($x->getCost());
      }
      if ($x->hasTaskQueueName()) {
        $this->setTaskQueueName($x->getTaskQueueName());
      }
      if ($x->hasTaskName()) {
        $this->setTaskName($x->getTaskName());
      }
      if ($x->hasWasLoadingRequest()) {
        $this->setWasLoadingRequest($x->getWasLoadingRequest());
      }
      if ($x->hasPendingTime()) {
        $this->setPendingTime($x->getPendingTime());
      }
      if ($x->hasReplicaIndex()) {
        $this->setReplicaIndex($x->getReplicaIndex());
      }
      if ($x->hasFinished()) {
        $this->setFinished($x->getFinished());
      }
      if ($x->hasCloneKey()) {
        $this->setCloneKey($x->getCloneKey());
      }
      foreach ($x->getLineList() as $v) {
        $this->addLine()->copyFrom($v);
      }
      if ($x->hasExitReason()) {
        $this->setExitReason($x->getExitReason());
      }
      if ($x->hasWasThrottledForTime()) {
        $this->setWasThrottledForTime($x->getWasThrottledForTime());
      }
      if ($x->hasWasThrottledForRequests()) {
        $this->setWasThrottledForRequests($x->getWasThrottledForRequests());
      }
      if ($x->hasThrottledTime()) {
        $this->setThrottledTime($x->getThrottledTime());
      }
      if ($x->hasServerName()) {
        $this->setServerName($x->getServerName());
      }
      if ($x->hasOffset()) {
        $this->mutableOffset()->mergeFrom($x->getOffset());
      }
      if ($x->hasLinesIncomplete()) {
        $this->setLinesIncomplete($x->getLinesIncomplete());
      }
      if ($x->hasModuleId()) {
        $this->setModuleId($x->getModuleId());
      }
      if ($x->hasAppEngineRelease()) {
        $this->setAppEngineRelease($x->getAppEngineRelease());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->version_id) !== isset($x->version_id)) return false;
      if (isset($this->version_id) && $this->version_id !== $x->version_id) return false;
      if (isset($this->request_id) !== isset($x->request_id)) return false;
      if (isset($this->request_id) && $this->request_id !== $x->request_id) return false;
      if (isset($this->ip) !== isset($x->ip)) return false;
      if (isset($this->ip) && $this->ip !== $x->ip) return false;
      if (isset($this->nickname) !== isset($x->nickname)) return false;
      if (isset($this->nickname) && $this->nickname !== $x->nickname) return false;
      if (isset($this->start_time) !== isset($x->start_time)) return false;
      if (isset($this->start_time) && !$this->integerEquals($this->start_time, $x->start_time)) return false;
      if (isset($this->end_time) !== isset($x->end_time)) return false;
      if (isset($this->end_time) && !$this->integerEquals($this->end_time, $x->end_time)) return false;
      if (isset($this->latency) !== isset($x->latency)) return false;
      if (isset($this->latency) && !$this->integerEquals($this->latency, $x->latency)) return false;
      if (isset($this->mcycles) !== isset($x->mcycles)) return false;
      if (isset($this->mcycles) && !$this->integerEquals($this->mcycles, $x->mcycles)) return false;
      if (isset($this->method) !== isset($x->method)) return false;
      if (isset($this->method) && $this->method !== $x->method) return false;
      if (isset($this->resource) !== isset($x->resource)) return false;
      if (isset($this->resource) && $this->resource !== $x->resource) return false;
      if (isset($this->http_version) !== isset($x->http_version)) return false;
      if (isset($this->http_version) && $this->http_version !== $x->http_version) return false;
      if (isset($this->status) !== isset($x->status)) return false;
      if (isset($this->status) && !$this->integerEquals($this->status, $x->status)) return false;
      if (isset($this->response_size) !== isset($x->response_size)) return false;
      if (isset($this->response_size) && !$this->integerEquals($this->response_size, $x->response_size)) return false;
      if (isset($this->referrer) !== isset($x->referrer)) return false;
      if (isset($this->referrer) && $this->referrer !== $x->referrer) return false;
      if (isset($this->user_agent) !== isset($x->user_agent)) return false;
      if (isset($this->user_agent) && $this->user_agent !== $x->user_agent) return false;
      if (isset($this->url_map_entry) !== isset($x->url_map_entry)) return false;
      if (isset($this->url_map_entry) && $this->url_map_entry !== $x->url_map_entry) return false;
      if (isset($this->combined) !== isset($x->combined)) return false;
      if (isset($this->combined) && $this->combined !== $x->combined) return false;
      if (isset($this->api_mcycles) !== isset($x->api_mcycles)) return false;
      if (isset($this->api_mcycles) && !$this->integerEquals($this->api_mcycles, $x->api_mcycles)) return false;
      if (isset($this->host) !== isset($x->host)) return false;
      if (isset($this->host) && $this->host !== $x->host) return false;
      if (isset($this->cost) !== isset($x->cost)) return false;
      if (isset($this->cost) && $this->cost !== $x->cost) return false;
      if (isset($this->task_queue_name) !== isset($x->task_queue_name)) return false;
      if (isset($this->task_queue_name) && $this->task_queue_name !== $x->task_queue_name) return false;
      if (isset($this->task_name) !== isset($x->task_name)) return false;
      if (isset($this->task_name) && $this->task_name !== $x->task_name) return false;
      if (isset($this->was_loading_request) !== isset($x->was_loading_request)) return false;
      if (isset($this->was_loading_request) && $this->was_loading_request !== $x->was_loading_request) return false;
      if (isset($this->pending_time) !== isset($x->pending_time)) return false;
      if (isset($this->pending_time) && !$this->integerEquals($this->pending_time, $x->pending_time)) return false;
      if (isset($this->replica_index) !== isset($x->replica_index)) return false;
      if (isset($this->replica_index) && !$this->integerEquals($this->replica_index, $x->replica_index)) return false;
      if (isset($this->finished) !== isset($x->finished)) return false;
      if (isset($this->finished) && $this->finished !== $x->finished) return false;
      if (isset($this->clone_key) !== isset($x->clone_key)) return false;
      if (isset($this->clone_key) && $this->clone_key !== $x->clone_key) return false;
      if (sizeof($this->line) !== sizeof($x->line)) return false;
      foreach (array_map(null, $this->line, $x->line) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->exit_reason) !== isset($x->exit_reason)) return false;
      if (isset($this->exit_reason) && !$this->integerEquals($this->exit_reason, $x->exit_reason)) return false;
      if (isset($this->was_throttled_for_time) !== isset($x->was_throttled_for_time)) return false;
      if (isset($this->was_throttled_for_time) && $this->was_throttled_for_time !== $x->was_throttled_for_time) return false;
      if (isset($this->was_throttled_for_requests) !== isset($x->was_throttled_for_requests)) return false;
      if (isset($this->was_throttled_for_requests) && $this->was_throttled_for_requests !== $x->was_throttled_for_requests) return false;
      if (isset($this->throttled_time) !== isset($x->throttled_time)) return false;
      if (isset($this->throttled_time) && !$this->integerEquals($this->throttled_time, $x->throttled_time)) return false;
      if (isset($this->server_name) !== isset($x->server_name)) return false;
      if (isset($this->server_name) && $this->server_name !== $x->server_name) return false;
      if (isset($this->offset) !== isset($x->offset)) return false;
      if (isset($this->offset) && !$this->offset->equals($x->offset)) return false;
      if (isset($this->lines_incomplete) !== isset($x->lines_incomplete)) return false;
      if (isset($this->lines_incomplete) && $this->lines_incomplete !== $x->lines_incomplete) return false;
      if (isset($this->module_id) !== isset($x->module_id)) return false;
      if (isset($this->module_id) && $this->module_id !== $x->module_id) return false;
      if (isset($this->app_engine_release) !== isset($x->app_engine_release)) return false;
      if (isset($this->app_engine_release) && $this->app_engine_release !== $x->app_engine_release) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->version_id)) {
        $res .= $prefix . "version_id: " . $this->debugFormatString($this->version_id) . "\n";
      }
      if (isset($this->request_id)) {
        $res .= $prefix . "request_id: " . $this->debugFormatString($this->request_id) . "\n";
      }
      if (isset($this->ip)) {
        $res .= $prefix . "ip: " . $this->debugFormatString($this->ip) . "\n";
      }
      if (isset($this->nickname)) {
        $res .= $prefix . "nickname: " . $this->debugFormatString($this->nickname) . "\n";
      }
      if (isset($this->start_time)) {
        $res .= $prefix . "start_time: " . $this->debugFormatInt64($this->start_time) . "\n";
      }
      if (isset($this->end_time)) {
        $res .= $prefix . "end_time: " . $this->debugFormatInt64($this->end_time) . "\n";
      }
      if (isset($this->latency)) {
        $res .= $prefix . "latency: " . $this->debugFormatInt64($this->latency) . "\n";
      }
      if (isset($this->mcycles)) {
        $res .= $prefix . "mcycles: " . $this->debugFormatInt64($this->mcycles) . "\n";
      }
      if (isset($this->method)) {
        $res .= $prefix . "method: " . $this->debugFormatString($this->method) . "\n";
      }
      if (isset($this->resource)) {
        $res .= $prefix . "resource: " . $this->debugFormatString($this->resource) . "\n";
      }
      if (isset($this->http_version)) {
        $res .= $prefix . "http_version: " . $this->debugFormatString($this->http_version) . "\n";
      }
      if (isset($this->status)) {
        $res .= $prefix . "status: " . $this->debugFormatInt32($this->status) . "\n";
      }
      if (isset($this->response_size)) {
        $res .= $prefix . "response_size: " . $this->debugFormatInt64($this->response_size) . "\n";
      }
      if (isset($this->referrer)) {
        $res .= $prefix . "referrer: " . $this->debugFormatString($this->referrer) . "\n";
      }
      if (isset($this->user_agent)) {
        $res .= $prefix . "user_agent: " . $this->debugFormatString($this->user_agent) . "\n";
      }
      if (isset($this->url_map_entry)) {
        $res .= $prefix . "url_map_entry: " . $this->debugFormatString($this->url_map_entry) . "\n";
      }
      if (isset($this->combined)) {
        $res .= $prefix . "combined: " . $this->debugFormatString($this->combined) . "\n";
      }
      if (isset($this->api_mcycles)) {
        $res .= $prefix . "api_mcycles: " . $this->debugFormatInt64($this->api_mcycles) . "\n";
      }
      if (isset($this->host)) {
        $res .= $prefix . "host: " . $this->debugFormatString($this->host) . "\n";
      }
      if (isset($this->cost)) {
        $res .= $prefix . "cost: " . $this->debugFormatDouble($this->cost) . "\n";
      }
      if (isset($this->task_queue_name)) {
        $res .= $prefix . "task_queue_name: " . $this->debugFormatString($this->task_queue_name) . "\n";
      }
      if (isset($this->task_name)) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($this->task_name) . "\n";
      }
      if (isset($this->was_loading_request)) {
        $res .= $prefix . "was_loading_request: " . $this->debugFormatBool($this->was_loading_request) . "\n";
      }
      if (isset($this->pending_time)) {
        $res .= $prefix . "pending_time: " . $this->debugFormatInt64($this->pending_time) . "\n";
      }
      if (isset($this->replica_index)) {
        $res .= $prefix . "replica_index: " . $this->debugFormatInt32($this->replica_index) . "\n";
      }
      if (isset($this->finished)) {
        $res .= $prefix . "finished: " . $this->debugFormatBool($this->finished) . "\n";
      }
      if (isset($this->clone_key)) {
        $res .= $prefix . "clone_key: " . $this->debugFormatString($this->clone_key) . "\n";
      }
      foreach ($this->line as $value) {
        $res .= $prefix . "line <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->exit_reason)) {
        $res .= $prefix . "exit_reason: " . $this->debugFormatInt32($this->exit_reason) . "\n";
      }
      if (isset($this->was_throttled_for_time)) {
        $res .= $prefix . "was_throttled_for_time: " . $this->debugFormatBool($this->was_throttled_for_time) . "\n";
      }
      if (isset($this->was_throttled_for_requests)) {
        $res .= $prefix . "was_throttled_for_requests: " . $this->debugFormatBool($this->was_throttled_for_requests) . "\n";
      }
      if (isset($this->throttled_time)) {
        $res .= $prefix . "throttled_time: " . $this->debugFormatInt64($this->throttled_time) . "\n";
      }
      if (isset($this->server_name)) {
        $res .= $prefix . "server_name: " . $this->debugFormatString($this->server_name) . "\n";
      }
      if (isset($this->offset)) {
        $res .= $prefix . "offset <\n" . $this->offset->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->lines_incomplete)) {
        $res .= $prefix . "lines_incomplete: " . $this->debugFormatBool($this->lines_incomplete) . "\n";
      }
      if (isset($this->module_id)) {
        $res .= $prefix . "module_id: " . $this->debugFormatString($this->module_id) . "\n";
      }
      if (isset($this->app_engine_release)) {
        $res .= $prefix . "app_engine_release: " . $this->debugFormatString($this->app_engine_release) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogModuleVersion extends \google\net\ProtocolMessage {
    public function getModuleId() {
      if (!isset($this->module_id)) {
        return "default";
      }
      return $this->module_id;
    }
    public function setModuleId($val) {
      $this->module_id = $val;
      return $this;
    }
    public function clearModuleId() {
      unset($this->module_id);
      return $this;
    }
    public function hasModuleId() {
      return isset($this->module_id);
    }
    public function getVersionId() {
      if (!isset($this->version_id)) {
        return '';
      }
      return $this->version_id;
    }
    public function setVersionId($val) {
      $this->version_id = $val;
      return $this;
    }
    public function clearVersionId() {
      unset($this->version_id);
      return $this;
    }
    public function hasVersionId() {
      return isset($this->version_id);
    }
    public function clear() {
      $this->clearModuleId();
      $this->clearVersionId();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->module_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->module_id));
      }
      if (isset($this->version_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version_id));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->module_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->module_id);
      }
      if (isset($this->version_id)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->version_id);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setModuleId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setVersionId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasModuleId()) {
        $this->setModuleId($x->getModuleId());
      }
      if ($x->hasVersionId()) {
        $this->setVersionId($x->getVersionId());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->module_id) !== isset($x->module_id)) return false;
      if (isset($this->module_id) && $this->module_id !== $x->module_id) return false;
      if (isset($this->version_id) !== isset($x->version_id)) return false;
      if (isset($this->version_id) && $this->version_id !== $x->version_id) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->module_id)) {
        $res .= $prefix . "module_id: " . $this->debugFormatString($this->module_id) . "\n";
      }
      if (isset($this->version_id)) {
        $res .= $prefix . "version_id: " . $this->debugFormatString($this->version_id) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogReadRequest extends \google\net\ProtocolMessage {
    private $version_id = array();
    private $request_id = array();
    private $module_version = array();
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getVersionIdSize() {
      return sizeof($this->version_id);
    }
    public function getVersionIdList() {
      return $this->version_id;
    }
    public function getVersionId($idx) {
      return $this->version_id[$idx];
    }
    public function setVersionId($idx, $val) {
      $this->version_id[$idx] = $val;
      return $this;
    }
    public function addVersionId($val) {
      $this->version_id[] = $val;
      return $this;
    }
    public function clearVersionId() {
      $this->version_id = array();
    }
    public function getStartTime() {
      if (!isset($this->start_time)) {
        return "0";
      }
      return $this->start_time;
    }
    public function setStartTime($val) {
      if (is_double($val)) {
        $this->start_time = sprintf('%0.0F', $val);
      } else {
        $this->start_time = $val;
      }
      return $this;
    }
    public function clearStartTime() {
      unset($this->start_time);
      return $this;
    }
    public function hasStartTime() {
      return isset($this->start_time);
    }
    public function getEndTime() {
      if (!isset($this->end_time)) {
        return "0";
      }
      return $this->end_time;
    }
    public function setEndTime($val) {
      if (is_double($val)) {
        $this->end_time = sprintf('%0.0F', $val);
      } else {
        $this->end_time = $val;
      }
      return $this;
    }
    public function clearEndTime() {
      unset($this->end_time);
      return $this;
    }
    public function hasEndTime() {
      return isset($this->end_time);
    }
    public function getOffset() {
      if (!isset($this->offset)) {
        return new \google\appengine\LogOffset();
      }
      return $this->offset;
    }
    public function mutableOffset() {
      if (!isset($this->offset)) {
        $res = new \google\appengine\LogOffset();
        $this->offset = $res;
        return $res;
      }
      return $this->offset;
    }
    public function clearOffset() {
      if (isset($this->offset)) {
        unset($this->offset);
      }
    }
    public function hasOffset() {
      return isset($this->offset);
    }
    public function getRequestIdSize() {
      return sizeof($this->request_id);
    }
    public function getRequestIdList() {
      return $this->request_id;
    }
    public function getRequestId($idx) {
      return $this->request_id[$idx];
    }
    public function setRequestId($idx, $val) {
      $this->request_id[$idx] = $val;
      return $this;
    }
    public function addRequestId($val) {
      $this->request_id[] = $val;
      return $this;
    }
    public function clearRequestId() {
      $this->request_id = array();
    }
    public function getMinimumLogLevel() {
      if (!isset($this->minimum_log_level)) {
        return 0;
      }
      return $this->minimum_log_level;
    }
    public function setMinimumLogLevel($val) {
      $this->minimum_log_level = $val;
      return $this;
    }
    public function clearMinimumLogLevel() {
      unset($this->minimum_log_level);
      return $this;
    }
    public function hasMinimumLogLevel() {
      return isset($this->minimum_log_level);
    }
    public function getIncludeIncomplete() {
      if (!isset($this->include_incomplete)) {
        return false;
      }
      return $this->include_incomplete;
    }
    public function setIncludeIncomplete($val) {
      $this->include_incomplete = $val;
      return $this;
    }
    public function clearIncludeIncomplete() {
      unset($this->include_incomplete);
      return $this;
    }
    public function hasIncludeIncomplete() {
      return isset($this->include_incomplete);
    }
    public function getCount() {
      if (!isset($this->count)) {
        return "0";
      }
      return $this->count;
    }
    public function setCount($val) {
      if (is_double($val)) {
        $this->count = sprintf('%0.0F', $val);
      } else {
        $this->count = $val;
      }
      return $this;
    }
    public function clearCount() {
      unset($this->count);
      return $this;
    }
    public function hasCount() {
      return isset($this->count);
    }
    public function getIncludeAppLogs() {
      if (!isset($this->include_app_logs)) {
        return false;
      }
      return $this->include_app_logs;
    }
    public function setIncludeAppLogs($val) {
      $this->include_app_logs = $val;
      return $this;
    }
    public function clearIncludeAppLogs() {
      unset($this->include_app_logs);
      return $this;
    }
    public function hasIncludeAppLogs() {
      return isset($this->include_app_logs);
    }
    public function getIncludeHost() {
      if (!isset($this->include_host)) {
        return false;
      }
      return $this->include_host;
    }
    public function setIncludeHost($val) {
      $this->include_host = $val;
      return $this;
    }
    public function clearIncludeHost() {
      unset($this->include_host);
      return $this;
    }
    public function hasIncludeHost() {
      return isset($this->include_host);
    }
    public function getIncludeAll() {
      if (!isset($this->include_all)) {
        return false;
      }
      return $this->include_all;
    }
    public function setIncludeAll($val) {
      $this->include_all = $val;
      return $this;
    }
    public function clearIncludeAll() {
      unset($this->include_all);
      return $this;
    }
    public function hasIncludeAll() {
      return isset($this->include_all);
    }
    public function getCacheIterator() {
      if (!isset($this->cache_iterator)) {
        return false;
      }
      return $this->cache_iterator;
    }
    public function setCacheIterator($val) {
      $this->cache_iterator = $val;
      return $this;
    }
    public function clearCacheIterator() {
      unset($this->cache_iterator);
      return $this;
    }
    public function hasCacheIterator() {
      return isset($this->cache_iterator);
    }
    public function getCombinedLogRegex() {
      if (!isset($this->combined_log_regex)) {
        return '';
      }
      return $this->combined_log_regex;
    }
    public function setCombinedLogRegex($val) {
      $this->combined_log_regex = $val;
      return $this;
    }
    public function clearCombinedLogRegex() {
      unset($this->combined_log_regex);
      return $this;
    }
    public function hasCombinedLogRegex() {
      return isset($this->combined_log_regex);
    }
    public function getHostRegex() {
      if (!isset($this->host_regex)) {
        return '';
      }
      return $this->host_regex;
    }
    public function setHostRegex($val) {
      $this->host_regex = $val;
      return $this;
    }
    public function clearHostRegex() {
      unset($this->host_regex);
      return $this;
    }
    public function hasHostRegex() {
      return isset($this->host_regex);
    }
    public function getReplicaIndex() {
      if (!isset($this->replica_index)) {
        return 0;
      }
      return $this->replica_index;
    }
    public function setReplicaIndex($val) {
      $this->replica_index = $val;
      return $this;
    }
    public function clearReplicaIndex() {
      unset($this->replica_index);
      return $this;
    }
    public function hasReplicaIndex() {
      return isset($this->replica_index);
    }
    public function getAppLogsPerRequest() {
      if (!isset($this->app_logs_per_request)) {
        return 0;
      }
      return $this->app_logs_per_request;
    }
    public function setAppLogsPerRequest($val) {
      $this->app_logs_per_request = $val;
      return $this;
    }
    public function clearAppLogsPerRequest() {
      unset($this->app_logs_per_request);
      return $this;
    }
    public function hasAppLogsPerRequest() {
      return isset($this->app_logs_per_request);
    }
    public function getNumShards() {
      if (!isset($this->num_shards)) {
        return 0;
      }
      return $this->num_shards;
    }
    public function setNumShards($val) {
      $this->num_shards = $val;
      return $this;
    }
    public function clearNumShards() {
      unset($this->num_shards);
      return $this;
    }
    public function hasNumShards() {
      return isset($this->num_shards);
    }
    public function getModuleVersionSize() {
      return sizeof($this->module_version);
    }
    public function getModuleVersionList() {
      return $this->module_version;
    }
    public function mutableModuleVersion($idx) {
      if (!isset($this->module_version[$idx])) {
        $val = new \google\appengine\LogModuleVersion();
        $this->module_version[$idx] = $val;
        return $val;
      }
      return $this->module_version[$idx];
    }
    public function getModuleVersion($idx) {
      if (isset($this->module_version[$idx])) {
        return $this->module_version[$idx];
      }
      if ($idx >= end(array_keys($this->module_version))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\LogModuleVersion();
    }
    public function addModuleVersion() {
      $val = new \google\appengine\LogModuleVersion();
      $this->module_version[] = $val;
      return $val;
    }
    public function clearModuleVersion() {
      $this->module_version = array();
    }
    public function clear() {
      $this->clearAppId();
      $this->clearVersionId();
      $this->clearStartTime();
      $this->clearEndTime();
      $this->clearOffset();
      $this->clearRequestId();
      $this->clearMinimumLogLevel();
      $this->clearIncludeIncomplete();
      $this->clearCount();
      $this->clearIncludeAppLogs();
      $this->clearIncludeHost();
      $this->clearIncludeAll();
      $this->clearCacheIterator();
      $this->clearCombinedLogRegex();
      $this->clearHostRegex();
      $this->clearReplicaIndex();
      $this->clearAppLogsPerRequest();
      $this->clearNumShards();
      $this->clearModuleVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      $this->checkProtoArray($this->version_id);
      $res += 1 * sizeof($this->version_id);
      foreach ($this->version_id as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->start_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->start_time);
      }
      if (isset($this->end_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->end_time);
      }
      if (isset($this->offset)) {
        $res += 1;
        $res += $this->lengthString($this->offset->byteSizePartial());
      }
      $this->checkProtoArray($this->request_id);
      $res += 1 * sizeof($this->request_id);
      foreach ($this->request_id as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->minimum_log_level)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->minimum_log_level);
      }
      if (isset($this->include_incomplete)) {
        $res += 2;
      }
      if (isset($this->count)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->count);
      }
      if (isset($this->include_app_logs)) {
        $res += 2;
      }
      if (isset($this->include_host)) {
        $res += 2;
      }
      if (isset($this->include_all)) {
        $res += 2;
      }
      if (isset($this->cache_iterator)) {
        $res += 2;
      }
      if (isset($this->combined_log_regex)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->combined_log_regex));
      }
      if (isset($this->host_regex)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->host_regex));
      }
      if (isset($this->replica_index)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->replica_index);
      }
      if (isset($this->app_logs_per_request)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->app_logs_per_request);
      }
      if (isset($this->num_shards)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->num_shards);
      }
      $this->checkProtoArray($this->module_version);
      $res += 2 * sizeof($this->module_version);
      foreach ($this->module_version as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      $this->checkProtoArray($this->version_id);
      foreach ($this->version_id as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
      if (isset($this->start_time)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->start_time);
      }
      if (isset($this->end_time)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->end_time);
      }
      if (isset($this->offset)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->offset->byteSizePartial());
        $this->offset->outputPartial($out);
      }
      $this->checkProtoArray($this->request_id);
      foreach ($this->request_id as $value) {
        $out->putVarInt32(50);
        $out->putPrefixedString($value);
      }
      if (isset($this->minimum_log_level)) {
        $out->putVarInt32(56);
        $out->putVarInt32($this->minimum_log_level);
      }
      if (isset($this->include_incomplete)) {
        $out->putVarInt32(64);
        $out->putBoolean($this->include_incomplete);
      }
      if (isset($this->count)) {
        $out->putVarInt32(72);
        $out->putVarInt64($this->count);
      }
      if (isset($this->include_app_logs)) {
        $out->putVarInt32(80);
        $out->putBoolean($this->include_app_logs);
      }
      if (isset($this->include_host)) {
        $out->putVarInt32(88);
        $out->putBoolean($this->include_host);
      }
      if (isset($this->include_all)) {
        $out->putVarInt32(96);
        $out->putBoolean($this->include_all);
      }
      if (isset($this->cache_iterator)) {
        $out->putVarInt32(104);
        $out->putBoolean($this->cache_iterator);
      }
      if (isset($this->combined_log_regex)) {
        $out->putVarInt32(114);
        $out->putPrefixedString($this->combined_log_regex);
      }
      if (isset($this->host_regex)) {
        $out->putVarInt32(122);
        $out->putPrefixedString($this->host_regex);
      }
      if (isset($this->replica_index)) {
        $out->putVarInt32(128);
        $out->putVarInt32($this->replica_index);
      }
      if (isset($this->app_logs_per_request)) {
        $out->putVarInt32(136);
        $out->putVarInt32($this->app_logs_per_request);
      }
      if (isset($this->num_shards)) {
        $out->putVarInt32(144);
        $out->putVarInt32($this->num_shards);
      }
      $this->checkProtoArray($this->module_version);
      foreach ($this->module_version as $value) {
        $out->putVarInt32(154);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addVersionId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setStartTime($d->getVarInt64());
            break;
          case 32:
            $this->setEndTime($d->getVarInt64());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOffset()->tryMerge($tmp);
            break;
          case 50:
            $length = $d->getVarInt32();
            $this->addRequestId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 56:
            $this->setMinimumLogLevel($d->getVarInt32());
            break;
          case 64:
            $this->setIncludeIncomplete($d->getBoolean());
            break;
          case 72:
            $this->setCount($d->getVarInt64());
            break;
          case 80:
            $this->setIncludeAppLogs($d->getBoolean());
            break;
          case 88:
            $this->setIncludeHost($d->getBoolean());
            break;
          case 96:
            $this->setIncludeAll($d->getBoolean());
            break;
          case 104:
            $this->setCacheIterator($d->getBoolean());
            break;
          case 114:
            $length = $d->getVarInt32();
            $this->setCombinedLogRegex(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 122:
            $length = $d->getVarInt32();
            $this->setHostRegex(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 128:
            $this->setReplicaIndex($d->getVarInt32());
            break;
          case 136:
            $this->setAppLogsPerRequest($d->getVarInt32());
            break;
          case 144:
            $this->setNumShards($d->getVarInt32());
            break;
          case 154:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addModuleVersion()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      if (isset($this->offset) && (!$this->offset->isInitialized())) return 'offset';
      foreach ($this->module_version as $value) {
        if (!$value->isInitialized()) return 'module_version';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      foreach ($x->getVersionIdList() as $v) {
        $this->addVersionId($v);
      }
      if ($x->hasStartTime()) {
        $this->setStartTime($x->getStartTime());
      }
      if ($x->hasEndTime()) {
        $this->setEndTime($x->getEndTime());
      }
      if ($x->hasOffset()) {
        $this->mutableOffset()->mergeFrom($x->getOffset());
      }
      foreach ($x->getRequestIdList() as $v) {
        $this->addRequestId($v);
      }
      if ($x->hasMinimumLogLevel()) {
        $this->setMinimumLogLevel($x->getMinimumLogLevel());
      }
      if ($x->hasIncludeIncomplete()) {
        $this->setIncludeIncomplete($x->getIncludeIncomplete());
      }
      if ($x->hasCount()) {
        $this->setCount($x->getCount());
      }
      if ($x->hasIncludeAppLogs()) {
        $this->setIncludeAppLogs($x->getIncludeAppLogs());
      }
      if ($x->hasIncludeHost()) {
        $this->setIncludeHost($x->getIncludeHost());
      }
      if ($x->hasIncludeAll()) {
        $this->setIncludeAll($x->getIncludeAll());
      }
      if ($x->hasCacheIterator()) {
        $this->setCacheIterator($x->getCacheIterator());
      }
      if ($x->hasCombinedLogRegex()) {
        $this->setCombinedLogRegex($x->getCombinedLogRegex());
      }
      if ($x->hasHostRegex()) {
        $this->setHostRegex($x->getHostRegex());
      }
      if ($x->hasReplicaIndex()) {
        $this->setReplicaIndex($x->getReplicaIndex());
      }
      if ($x->hasAppLogsPerRequest()) {
        $this->setAppLogsPerRequest($x->getAppLogsPerRequest());
      }
      if ($x->hasNumShards()) {
        $this->setNumShards($x->getNumShards());
      }
      foreach ($x->getModuleVersionList() as $v) {
        $this->addModuleVersion()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (sizeof($this->version_id) !== sizeof($x->version_id)) return false;
      foreach (array_map(null, $this->version_id, $x->version_id) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->start_time) !== isset($x->start_time)) return false;
      if (isset($this->start_time) && !$this->integerEquals($this->start_time, $x->start_time)) return false;
      if (isset($this->end_time) !== isset($x->end_time)) return false;
      if (isset($this->end_time) && !$this->integerEquals($this->end_time, $x->end_time)) return false;
      if (isset($this->offset) !== isset($x->offset)) return false;
      if (isset($this->offset) && !$this->offset->equals($x->offset)) return false;
      if (sizeof($this->request_id) !== sizeof($x->request_id)) return false;
      foreach (array_map(null, $this->request_id, $x->request_id) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->minimum_log_level) !== isset($x->minimum_log_level)) return false;
      if (isset($this->minimum_log_level) && !$this->integerEquals($this->minimum_log_level, $x->minimum_log_level)) return false;
      if (isset($this->include_incomplete) !== isset($x->include_incomplete)) return false;
      if (isset($this->include_incomplete) && $this->include_incomplete !== $x->include_incomplete) return false;
      if (isset($this->count) !== isset($x->count)) return false;
      if (isset($this->count) && !$this->integerEquals($this->count, $x->count)) return false;
      if (isset($this->include_app_logs) !== isset($x->include_app_logs)) return false;
      if (isset($this->include_app_logs) && $this->include_app_logs !== $x->include_app_logs) return false;
      if (isset($this->include_host) !== isset($x->include_host)) return false;
      if (isset($this->include_host) && $this->include_host !== $x->include_host) return false;
      if (isset($this->include_all) !== isset($x->include_all)) return false;
      if (isset($this->include_all) && $this->include_all !== $x->include_all) return false;
      if (isset($this->cache_iterator) !== isset($x->cache_iterator)) return false;
      if (isset($this->cache_iterator) && $this->cache_iterator !== $x->cache_iterator) return false;
      if (isset($this->combined_log_regex) !== isset($x->combined_log_regex)) return false;
      if (isset($this->combined_log_regex) && $this->combined_log_regex !== $x->combined_log_regex) return false;
      if (isset($this->host_regex) !== isset($x->host_regex)) return false;
      if (isset($this->host_regex) && $this->host_regex !== $x->host_regex) return false;
      if (isset($this->replica_index) !== isset($x->replica_index)) return false;
      if (isset($this->replica_index) && !$this->integerEquals($this->replica_index, $x->replica_index)) return false;
      if (isset($this->app_logs_per_request) !== isset($x->app_logs_per_request)) return false;
      if (isset($this->app_logs_per_request) && !$this->integerEquals($this->app_logs_per_request, $x->app_logs_per_request)) return false;
      if (isset($this->num_shards) !== isset($x->num_shards)) return false;
      if (isset($this->num_shards) && !$this->integerEquals($this->num_shards, $x->num_shards)) return false;
      if (sizeof($this->module_version) !== sizeof($x->module_version)) return false;
      foreach (array_map(null, $this->module_version, $x->module_version) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      foreach ($this->version_id as $value) {
        $res .= $prefix . "version_id: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->start_time)) {
        $res .= $prefix . "start_time: " . $this->debugFormatInt64($this->start_time) . "\n";
      }
      if (isset($this->end_time)) {
        $res .= $prefix . "end_time: " . $this->debugFormatInt64($this->end_time) . "\n";
      }
      if (isset($this->offset)) {
        $res .= $prefix . "offset <\n" . $this->offset->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->request_id as $value) {
        $res .= $prefix . "request_id: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->minimum_log_level)) {
        $res .= $prefix . "minimum_log_level: " . $this->debugFormatInt32($this->minimum_log_level) . "\n";
      }
      if (isset($this->include_incomplete)) {
        $res .= $prefix . "include_incomplete: " . $this->debugFormatBool($this->include_incomplete) . "\n";
      }
      if (isset($this->count)) {
        $res .= $prefix . "count: " . $this->debugFormatInt64($this->count) . "\n";
      }
      if (isset($this->include_app_logs)) {
        $res .= $prefix . "include_app_logs: " . $this->debugFormatBool($this->include_app_logs) . "\n";
      }
      if (isset($this->include_host)) {
        $res .= $prefix . "include_host: " . $this->debugFormatBool($this->include_host) . "\n";
      }
      if (isset($this->include_all)) {
        $res .= $prefix . "include_all: " . $this->debugFormatBool($this->include_all) . "\n";
      }
      if (isset($this->cache_iterator)) {
        $res .= $prefix . "cache_iterator: " . $this->debugFormatBool($this->cache_iterator) . "\n";
      }
      if (isset($this->combined_log_regex)) {
        $res .= $prefix . "combined_log_regex: " . $this->debugFormatString($this->combined_log_regex) . "\n";
      }
      if (isset($this->host_regex)) {
        $res .= $prefix . "host_regex: " . $this->debugFormatString($this->host_regex) . "\n";
      }
      if (isset($this->replica_index)) {
        $res .= $prefix . "replica_index: " . $this->debugFormatInt32($this->replica_index) . "\n";
      }
      if (isset($this->app_logs_per_request)) {
        $res .= $prefix . "app_logs_per_request: " . $this->debugFormatInt32($this->app_logs_per_request) . "\n";
      }
      if (isset($this->num_shards)) {
        $res .= $prefix . "num_shards: " . $this->debugFormatInt32($this->num_shards) . "\n";
      }
      foreach ($this->module_version as $value) {
        $res .= $prefix . "module_version <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogReadResponse extends \google\net\ProtocolMessage {
    private $log = array();
    public function getLogSize() {
      return sizeof($this->log);
    }
    public function getLogList() {
      return $this->log;
    }
    public function mutableLog($idx) {
      if (!isset($this->log[$idx])) {
        $val = new \google\appengine\RequestLog();
        $this->log[$idx] = $val;
        return $val;
      }
      return $this->log[$idx];
    }
    public function getLog($idx) {
      if (isset($this->log[$idx])) {
        return $this->log[$idx];
      }
      if ($idx >= end(array_keys($this->log))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\RequestLog();
    }
    public function addLog() {
      $val = new \google\appengine\RequestLog();
      $this->log[] = $val;
      return $val;
    }
    public function clearLog() {
      $this->log = array();
    }
    public function getOffset() {
      if (!isset($this->offset)) {
        return new \google\appengine\LogOffset();
      }
      return $this->offset;
    }
    public function mutableOffset() {
      if (!isset($this->offset)) {
        $res = new \google\appengine\LogOffset();
        $this->offset = $res;
        return $res;
      }
      return $this->offset;
    }
    public function clearOffset() {
      if (isset($this->offset)) {
        unset($this->offset);
      }
    }
    public function hasOffset() {
      return isset($this->offset);
    }
    public function getLastEndTime() {
      if (!isset($this->last_end_time)) {
        return "0";
      }
      return $this->last_end_time;
    }
    public function setLastEndTime($val) {
      if (is_double($val)) {
        $this->last_end_time = sprintf('%0.0F', $val);
      } else {
        $this->last_end_time = $val;
      }
      return $this;
    }
    public function clearLastEndTime() {
      unset($this->last_end_time);
      return $this;
    }
    public function hasLastEndTime() {
      return isset($this->last_end_time);
    }
    public function clear() {
      $this->clearLog();
      $this->clearOffset();
      $this->clearLastEndTime();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->log);
      $res += 1 * sizeof($this->log);
      foreach ($this->log as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->offset)) {
        $res += 1;
        $res += $this->lengthString($this->offset->byteSizePartial());
      }
      if (isset($this->last_end_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->last_end_time);
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->log);
      foreach ($this->log as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->offset)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->offset->byteSizePartial());
        $this->offset->outputPartial($out);
      }
      if (isset($this->last_end_time)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->last_end_time);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addLog()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOffset()->tryMerge($tmp);
            break;
          case 24:
            $this->setLastEndTime($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->log as $value) {
        if (!$value->isInitialized()) return 'log';
      }
      if (isset($this->offset) && (!$this->offset->isInitialized())) return 'offset';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getLogList() as $v) {
        $this->addLog()->copyFrom($v);
      }
      if ($x->hasOffset()) {
        $this->mutableOffset()->mergeFrom($x->getOffset());
      }
      if ($x->hasLastEndTime()) {
        $this->setLastEndTime($x->getLastEndTime());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->log) !== sizeof($x->log)) return false;
      foreach (array_map(null, $this->log, $x->log) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->offset) !== isset($x->offset)) return false;
      if (isset($this->offset) && !$this->offset->equals($x->offset)) return false;
      if (isset($this->last_end_time) !== isset($x->last_end_time)) return false;
      if (isset($this->last_end_time) && !$this->integerEquals($this->last_end_time, $x->last_end_time)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->log as $value) {
        $res .= $prefix . "log <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->offset)) {
        $res .= $prefix . "offset <\n" . $this->offset->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->last_end_time)) {
        $res .= $prefix . "last_end_time: " . $this->debugFormatInt64($this->last_end_time) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogUsageRecord extends \google\net\ProtocolMessage {
    public function getVersionId() {
      if (!isset($this->version_id)) {
        return '';
      }
      return $this->version_id;
    }
    public function setVersionId($val) {
      $this->version_id = $val;
      return $this;
    }
    public function clearVersionId() {
      unset($this->version_id);
      return $this;
    }
    public function hasVersionId() {
      return isset($this->version_id);
    }
    public function getStartTime() {
      if (!isset($this->start_time)) {
        return 0;
      }
      return $this->start_time;
    }
    public function setStartTime($val) {
      $this->start_time = $val;
      return $this;
    }
    public function clearStartTime() {
      unset($this->start_time);
      return $this;
    }
    public function hasStartTime() {
      return isset($this->start_time);
    }
    public function getEndTime() {
      if (!isset($this->end_time)) {
        return 0;
      }
      return $this->end_time;
    }
    public function setEndTime($val) {
      $this->end_time = $val;
      return $this;
    }
    public function clearEndTime() {
      unset($this->end_time);
      return $this;
    }
    public function hasEndTime() {
      return isset($this->end_time);
    }
    public function getCount() {
      if (!isset($this->count)) {
        return "0";
      }
      return $this->count;
    }
    public function setCount($val) {
      if (is_double($val)) {
        $this->count = sprintf('%0.0F', $val);
      } else {
        $this->count = $val;
      }
      return $this;
    }
    public function clearCount() {
      unset($this->count);
      return $this;
    }
    public function hasCount() {
      return isset($this->count);
    }
    public function getTotalSize() {
      if (!isset($this->total_size)) {
        return "0";
      }
      return $this->total_size;
    }
    public function setTotalSize($val) {
      if (is_double($val)) {
        $this->total_size = sprintf('%0.0F', $val);
      } else {
        $this->total_size = $val;
      }
      return $this;
    }
    public function clearTotalSize() {
      unset($this->total_size);
      return $this;
    }
    public function hasTotalSize() {
      return isset($this->total_size);
    }
    public function getRecords() {
      if (!isset($this->records)) {
        return 0;
      }
      return $this->records;
    }
    public function setRecords($val) {
      $this->records = $val;
      return $this;
    }
    public function clearRecords() {
      unset($this->records);
      return $this;
    }
    public function hasRecords() {
      return isset($this->records);
    }
    public function clear() {
      $this->clearVersionId();
      $this->clearStartTime();
      $this->clearEndTime();
      $this->clearCount();
      $this->clearTotalSize();
      $this->clearRecords();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->version_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version_id));
      }
      if (isset($this->start_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->start_time);
      }
      if (isset($this->end_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->end_time);
      }
      if (isset($this->count)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->count);
      }
      if (isset($this->total_size)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->total_size);
      }
      if (isset($this->records)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->records);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->version_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->version_id);
      }
      if (isset($this->start_time)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->start_time);
      }
      if (isset($this->end_time)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->end_time);
      }
      if (isset($this->count)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->count);
      }
      if (isset($this->total_size)) {
        $out->putVarInt32(40);
        $out->putVarInt64($this->total_size);
      }
      if (isset($this->records)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->records);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setVersionId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setStartTime($d->getVarInt32());
            break;
          case 24:
            $this->setEndTime($d->getVarInt32());
            break;
          case 32:
            $this->setCount($d->getVarInt64());
            break;
          case 40:
            $this->setTotalSize($d->getVarInt64());
            break;
          case 48:
            $this->setRecords($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasVersionId()) {
        $this->setVersionId($x->getVersionId());
      }
      if ($x->hasStartTime()) {
        $this->setStartTime($x->getStartTime());
      }
      if ($x->hasEndTime()) {
        $this->setEndTime($x->getEndTime());
      }
      if ($x->hasCount()) {
        $this->setCount($x->getCount());
      }
      if ($x->hasTotalSize()) {
        $this->setTotalSize($x->getTotalSize());
      }
      if ($x->hasRecords()) {
        $this->setRecords($x->getRecords());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->version_id) !== isset($x->version_id)) return false;
      if (isset($this->version_id) && $this->version_id !== $x->version_id) return false;
      if (isset($this->start_time) !== isset($x->start_time)) return false;
      if (isset($this->start_time) && !$this->integerEquals($this->start_time, $x->start_time)) return false;
      if (isset($this->end_time) !== isset($x->end_time)) return false;
      if (isset($this->end_time) && !$this->integerEquals($this->end_time, $x->end_time)) return false;
      if (isset($this->count) !== isset($x->count)) return false;
      if (isset($this->count) && !$this->integerEquals($this->count, $x->count)) return false;
      if (isset($this->total_size) !== isset($x->total_size)) return false;
      if (isset($this->total_size) && !$this->integerEquals($this->total_size, $x->total_size)) return false;
      if (isset($this->records) !== isset($x->records)) return false;
      if (isset($this->records) && !$this->integerEquals($this->records, $x->records)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->version_id)) {
        $res .= $prefix . "version_id: " . $this->debugFormatString($this->version_id) . "\n";
      }
      if (isset($this->start_time)) {
        $res .= $prefix . "start_time: " . $this->debugFormatInt32($this->start_time) . "\n";
      }
      if (isset($this->end_time)) {
        $res .= $prefix . "end_time: " . $this->debugFormatInt32($this->end_time) . "\n";
      }
      if (isset($this->count)) {
        $res .= $prefix . "count: " . $this->debugFormatInt64($this->count) . "\n";
      }
      if (isset($this->total_size)) {
        $res .= $prefix . "total_size: " . $this->debugFormatInt64($this->total_size) . "\n";
      }
      if (isset($this->records)) {
        $res .= $prefix . "records: " . $this->debugFormatInt32($this->records) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogUsageRequest extends \google\net\ProtocolMessage {
    private $version_id = array();
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getVersionIdSize() {
      return sizeof($this->version_id);
    }
    public function getVersionIdList() {
      return $this->version_id;
    }
    public function getVersionId($idx) {
      return $this->version_id[$idx];
    }
    public function setVersionId($idx, $val) {
      $this->version_id[$idx] = $val;
      return $this;
    }
    public function addVersionId($val) {
      $this->version_id[] = $val;
      return $this;
    }
    public function clearVersionId() {
      $this->version_id = array();
    }
    public function getStartTime() {
      if (!isset($this->start_time)) {
        return 0;
      }
      return $this->start_time;
    }
    public function setStartTime($val) {
      $this->start_time = $val;
      return $this;
    }
    public function clearStartTime() {
      unset($this->start_time);
      return $this;
    }
    public function hasStartTime() {
      return isset($this->start_time);
    }
    public function getEndTime() {
      if (!isset($this->end_time)) {
        return 0;
      }
      return $this->end_time;
    }
    public function setEndTime($val) {
      $this->end_time = $val;
      return $this;
    }
    public function clearEndTime() {
      unset($this->end_time);
      return $this;
    }
    public function hasEndTime() {
      return isset($this->end_time);
    }
    public function getResolutionHours() {
      if (!isset($this->resolution_hours)) {
        return '1';
      }
      return $this->resolution_hours;
    }
    public function setResolutionHours($val) {
      $this->resolution_hours = $val;
      return $this;
    }
    public function clearResolutionHours() {
      unset($this->resolution_hours);
      return $this;
    }
    public function hasResolutionHours() {
      return isset($this->resolution_hours);
    }
    public function getCombineVersions() {
      if (!isset($this->combine_versions)) {
        return false;
      }
      return $this->combine_versions;
    }
    public function setCombineVersions($val) {
      $this->combine_versions = $val;
      return $this;
    }
    public function clearCombineVersions() {
      unset($this->combine_versions);
      return $this;
    }
    public function hasCombineVersions() {
      return isset($this->combine_versions);
    }
    public function getUsageVersion() {
      if (!isset($this->usage_version)) {
        return 0;
      }
      return $this->usage_version;
    }
    public function setUsageVersion($val) {
      $this->usage_version = $val;
      return $this;
    }
    public function clearUsageVersion() {
      unset($this->usage_version);
      return $this;
    }
    public function hasUsageVersion() {
      return isset($this->usage_version);
    }
    public function getVersionsOnly() {
      if (!isset($this->versions_only)) {
        return false;
      }
      return $this->versions_only;
    }
    public function setVersionsOnly($val) {
      $this->versions_only = $val;
      return $this;
    }
    public function clearVersionsOnly() {
      unset($this->versions_only);
      return $this;
    }
    public function hasVersionsOnly() {
      return isset($this->versions_only);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearVersionId();
      $this->clearStartTime();
      $this->clearEndTime();
      $this->clearResolutionHours();
      $this->clearCombineVersions();
      $this->clearUsageVersion();
      $this->clearVersionsOnly();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      $this->checkProtoArray($this->version_id);
      $res += 1 * sizeof($this->version_id);
      foreach ($this->version_id as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->start_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->start_time);
      }
      if (isset($this->end_time)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->end_time);
      }
      if (isset($this->resolution_hours)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->resolution_hours);
      }
      if (isset($this->combine_versions)) {
        $res += 2;
      }
      if (isset($this->usage_version)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->usage_version);
      }
      if (isset($this->versions_only)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      $this->checkProtoArray($this->version_id);
      foreach ($this->version_id as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
      if (isset($this->start_time)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->start_time);
      }
      if (isset($this->end_time)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->end_time);
      }
      if (isset($this->resolution_hours)) {
        $out->putVarInt32(40);
        $out->putVarUint32($this->resolution_hours);
      }
      if (isset($this->combine_versions)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->combine_versions);
      }
      if (isset($this->usage_version)) {
        $out->putVarInt32(56);
        $out->putVarInt32($this->usage_version);
      }
      if (isset($this->versions_only)) {
        $out->putVarInt32(64);
        $out->putBoolean($this->versions_only);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addVersionId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setStartTime($d->getVarInt32());
            break;
          case 32:
            $this->setEndTime($d->getVarInt32());
            break;
          case 40:
            $this->setResolutionHours($d->getVarUint32());
            break;
          case 48:
            $this->setCombineVersions($d->getBoolean());
            break;
          case 56:
            $this->setUsageVersion($d->getVarInt32());
            break;
          case 64:
            $this->setVersionsOnly($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      foreach ($x->getVersionIdList() as $v) {
        $this->addVersionId($v);
      }
      if ($x->hasStartTime()) {
        $this->setStartTime($x->getStartTime());
      }
      if ($x->hasEndTime()) {
        $this->setEndTime($x->getEndTime());
      }
      if ($x->hasResolutionHours()) {
        $this->setResolutionHours($x->getResolutionHours());
      }
      if ($x->hasCombineVersions()) {
        $this->setCombineVersions($x->getCombineVersions());
      }
      if ($x->hasUsageVersion()) {
        $this->setUsageVersion($x->getUsageVersion());
      }
      if ($x->hasVersionsOnly()) {
        $this->setVersionsOnly($x->getVersionsOnly());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (sizeof($this->version_id) !== sizeof($x->version_id)) return false;
      foreach (array_map(null, $this->version_id, $x->version_id) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->start_time) !== isset($x->start_time)) return false;
      if (isset($this->start_time) && !$this->integerEquals($this->start_time, $x->start_time)) return false;
      if (isset($this->end_time) !== isset($x->end_time)) return false;
      if (isset($this->end_time) && !$this->integerEquals($this->end_time, $x->end_time)) return false;
      if (isset($this->resolution_hours) !== isset($x->resolution_hours)) return false;
      if (isset($this->resolution_hours) && !$this->integerEquals($this->resolution_hours, $x->resolution_hours)) return false;
      if (isset($this->combine_versions) !== isset($x->combine_versions)) return false;
      if (isset($this->combine_versions) && $this->combine_versions !== $x->combine_versions) return false;
      if (isset($this->usage_version) !== isset($x->usage_version)) return false;
      if (isset($this->usage_version) && !$this->integerEquals($this->usage_version, $x->usage_version)) return false;
      if (isset($this->versions_only) !== isset($x->versions_only)) return false;
      if (isset($this->versions_only) && $this->versions_only !== $x->versions_only) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      foreach ($this->version_id as $value) {
        $res .= $prefix . "version_id: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->start_time)) {
        $res .= $prefix . "start_time: " . $this->debugFormatInt32($this->start_time) . "\n";
      }
      if (isset($this->end_time)) {
        $res .= $prefix . "end_time: " . $this->debugFormatInt32($this->end_time) . "\n";
      }
      if (isset($this->resolution_hours)) {
        $res .= $prefix . "resolution_hours: " . $this->debugFormatInt64($this->resolution_hours) . "\n";
      }
      if (isset($this->combine_versions)) {
        $res .= $prefix . "combine_versions: " . $this->debugFormatBool($this->combine_versions) . "\n";
      }
      if (isset($this->usage_version)) {
        $res .= $prefix . "usage_version: " . $this->debugFormatInt32($this->usage_version) . "\n";
      }
      if (isset($this->versions_only)) {
        $res .= $prefix . "versions_only: " . $this->debugFormatBool($this->versions_only) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class LogUsageResponse extends \google\net\ProtocolMessage {
    private $usage = array();
    public function getUsageSize() {
      return sizeof($this->usage);
    }
    public function getUsageList() {
      return $this->usage;
    }
    public function mutableUsage($idx) {
      if (!isset($this->usage[$idx])) {
        $val = new \google\appengine\LogUsageRecord();
        $this->usage[$idx] = $val;
        return $val;
      }
      return $this->usage[$idx];
    }
    public function getUsage($idx) {
      if (isset($this->usage[$idx])) {
        return $this->usage[$idx];
      }
      if ($idx >= end(array_keys($this->usage))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\LogUsageRecord();
    }
    public function addUsage() {
      $val = new \google\appengine\LogUsageRecord();
      $this->usage[] = $val;
      return $val;
    }
    public function clearUsage() {
      $this->usage = array();
    }
    public function getSummary() {
      if (!isset($this->summary)) {
        return new \google\appengine\LogUsageRecord();
      }
      return $this->summary;
    }
    public function mutableSummary() {
      if (!isset($this->summary)) {
        $res = new \google\appengine\LogUsageRecord();
        $this->summary = $res;
        return $res;
      }
      return $this->summary;
    }
    public function clearSummary() {
      if (isset($this->summary)) {
        unset($this->summary);
      }
    }
    public function hasSummary() {
      return isset($this->summary);
    }
    public function clear() {
      $this->clearUsage();
      $this->clearSummary();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->usage);
      $res += 1 * sizeof($this->usage);
      foreach ($this->usage as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->summary)) {
        $res += 1;
        $res += $this->lengthString($this->summary->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->usage);
      foreach ($this->usage as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->summary)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->summary->byteSizePartial());
        $this->summary->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addUsage()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableSummary()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->usage as $value) {
        if (!$value->isInitialized()) return 'usage';
      }
      if (isset($this->summary) && (!$this->summary->isInitialized())) return 'summary';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getUsageList() as $v) {
        $this->addUsage()->copyFrom($v);
      }
      if ($x->hasSummary()) {
        $this->mutableSummary()->mergeFrom($x->getSummary());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->usage) !== sizeof($x->usage)) return false;
      foreach (array_map(null, $this->usage, $x->usage) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->summary) !== isset($x->summary)) return false;
      if (isset($this->summary) && !$this->summary->equals($x->summary)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->usage as $value) {
        $res .= $prefix . "usage <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->summary)) {
        $res .= $prefix . "summary <\n" . $this->summary->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
