/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class DefaultResolutionCacheManager
implements ResolutionCacheManager {
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File basedir) {
        this.setBasedir(basedir);
    }

    public File getResolutionCacheRoot() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getResolvedIvyPattern() {
        return this.resolvedIvyPattern;
    }

    public String getResolvedIvyPropertiesPattern() {
        return this.resolvedIvyPropertiesPattern;
    }

    public File getResolvedIvyFileInCache(ModuleRevisionId mrid) {
        String file2 = IvyPatternHelper.substitute(this.getResolvedIvyPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file2);
    }

    public File getResolvedIvyPropertiesInCache(ModuleRevisionId mrid) {
        String file2 = IvyPatternHelper.substitute(this.getResolvedIvyPropertiesPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file2);
    }

    public File getConfigurationResolveReportInCache(String resolveId, String conf) {
        return new File(this.getResolutionCacheRoot(), resolveId + "-" + conf + ".xml");
    }

    public String toString() {
        return this.name;
    }
}

