/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItem;

public final class UpdateOptions {
    private ParserSettings settings = null;
    private Namespace namespace = null;
    private Map resolvedRevisions = Collections.EMPTY_MAP;
    private Map resolvedBranches = Collections.EMPTY_MAP;
    private String status = null;
    private String revision = null;
    private Date pubdate = null;
    private boolean replaceInclude = true;
    private boolean merge = true;
    private boolean updateBranch = true;
    private boolean generateRevConstraint = true;

    public final ParserSettings getSettings() {
        return this.settings;
    }

    public final UpdateOptions setSettings(ParserSettings parserSettings) {
        this.settings = parserSettings;
        return this;
    }

    public final Namespace getNamespace() {
        return this.namespace;
    }

    public final UpdateOptions setNamespace(Namespace namespace) {
        this.namespace = namespace;
        return this;
    }

    public final Map getResolvedRevisions() {
        return this.resolvedRevisions;
    }

    public final String getStatus() {
        return this.status;
    }

    public final UpdateOptions setStatus(String string) {
        this.status = string;
        return this;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final UpdateOptions setRevision(String string) {
        this.revision = string;
        return this;
    }

    public final Date getPubdate() {
        return this.pubdate;
    }

    public final UpdateOptions setPubdate(Date date) {
        this.pubdate = date;
        return this;
    }

    public final boolean isReplaceInclude() {
        return this.replaceInclude;
    }

    public final boolean isMerge() {
        return false;
    }

    public final boolean isUpdateBranch() {
        return this.updateBranch;
    }

    public final UpdateOptions setUpdateBranch$26da6685() {
        this.updateBranch = false;
        return this;
    }

    public final boolean isGenerateRevConstraint() {
        return this.generateRevConstraint;
    }

    public final Map getResolvedBranches() {
        return this.resolvedBranches;
    }

    public static void write(ModuleDescriptor moduleDescriptor, File file2) {
        File file3 = file2;
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        if (file3.getParentFile() != null) {
            file3.getParentFile().mkdirs();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file3), "UTF-8"));
        try {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            StringBuffer stringBuffer = new StringBuffer();
            Object object = moduleDescriptor2.getExtraAttributesNamespaces().entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                stringBuffer.append(" xmlns:").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
            }
            object = "2.0";
            if (moduleDescriptor2.getInheritedDescriptors().length > 0) {
                object = "2.2";
            }
            printWriter.println("<ivy-module version=\"" + (String)object + "\"" + stringBuffer + ">");
            UpdateOptions.printInfoTag(moduleDescriptor2, printWriter);
            UpdateOptions.printConfigurations(moduleDescriptor2, printWriter);
            UpdateOptions.printPublications(moduleDescriptor2, printWriter);
            UpdateOptions.printDependencies(moduleDescriptor2, printWriter);
            printWriter.println("</ivy-module>");
            return;
        }
        finally {
            printWriter.close();
        }
    }

    private static void printDependencies(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        if (dependencyDescriptorArray.length > 0) {
            printWriter.println("\t<dependencies>");
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                DependencyDescriptor dependencyDescriptor = dependencyDescriptorArray[i];
                printWriter.print("\t\t");
                UpdateOptions.printDependency(moduleDescriptor, dependencyDescriptor, printWriter);
            }
            PrintWriter printWriter2 = printWriter;
            ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
            ExcludeRule[] excludeRuleArray = moduleDescriptor2.getAllExcludeRules();
            if (excludeRuleArray.length > 0) {
                for (int i = 0; i < excludeRuleArray.length; ++i) {
                    printWriter2.print("\t\t<exclude");
                    printWriter2.print(" org=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getOrganisation()) + "\"");
                    printWriter2.print(" module=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getName()) + "\"");
                    printWriter2.print(" artifact=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getName()) + "\"");
                    printWriter2.print(" type=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getType()) + "\"");
                    printWriter2.print(" ext=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getExt()) + "\"");
                    String[] stringArray = excludeRuleArray[i].getConfigurations();
                    if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor2.getConfigurationsNames()))) {
                        printWriter2.print(" conf=\"");
                        for (int j = 0; j < stringArray.length; ++j) {
                            printWriter2.print(XMLHelper.escape(stringArray[j]));
                            if (j + 1 >= stringArray.length) continue;
                            printWriter2.print(",");
                        }
                        printWriter2.print("\"");
                    }
                    printWriter2.print(" matcher=\"" + XMLHelper.escape(excludeRuleArray[i].getMatcher().getName()) + "\"");
                    printWriter2.println("/>");
                }
            }
            UpdateOptions.printAllMediators(moduleDescriptor, printWriter);
            printWriter.println("\t</dependencies>");
        }
    }

    protected static void printDependency(ModuleDescriptor moduleDescriptor, DependencyDescriptor dependencyDescriptor, PrintWriter printWriter) {
        Object[] objectArray;
        printWriter.print("<dependency");
        printWriter.print(" org=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getOrganisation()) + "\"");
        printWriter.print(" name=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getName()) + "\"");
        if (dependencyDescriptor.getDependencyRevisionId().getBranch() != null) {
            printWriter.print(" branch=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getBranch()) + "\"");
        }
        printWriter.print(" rev=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getRevision()) + "\"");
        if (!dependencyDescriptor.getDynamicConstraintDependencyRevisionId().equals(dependencyDescriptor.getDependencyRevisionId())) {
            if (dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getBranch() != null) {
                printWriter.print(" branchConstraint=\"" + XMLHelper.escape(dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getBranch()) + "\"");
            }
            printWriter.print(" revConstraint=\"" + XMLHelper.escape(dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision()) + "\"");
        }
        if (dependencyDescriptor.isForce()) {
            printWriter.print(" force=\"" + dependencyDescriptor.isForce() + "\"");
        }
        if (dependencyDescriptor.isChanging()) {
            printWriter.print(" changing=\"" + dependencyDescriptor.isChanging() + "\"");
        }
        if (!dependencyDescriptor.isTransitive()) {
            printWriter.print(" transitive=\"" + dependencyDescriptor.isTransitive() + "\"");
        }
        printWriter.print(" conf=\"");
        String[] stringArray = dependencyDescriptor.getModuleConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray = dependencyDescriptor.getDependencyConfigurations(stringArray[i]);
            printWriter.print(XMLHelper.escape(stringArray[i]) + "->");
            for (int j = 0; j < objectArray.length; ++j) {
                printWriter.print(XMLHelper.escape((String)objectArray[j]));
                if (j + 1 >= objectArray.length) continue;
                printWriter.print(",");
            }
            if (i + 1 >= stringArray.length) continue;
            printWriter.print(";");
        }
        printWriter.print("\"");
        UpdateOptions.printExtraAttributes(dependencyDescriptor, printWriter, " ");
        DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray = dependencyDescriptor.getAllDependencyArtifacts();
        if (dependencyArtifactDescriptorArray.length > 0) {
            printWriter.println(">");
        }
        UpdateOptions.printDependencyArtefacts(moduleDescriptor, printWriter, dependencyArtifactDescriptorArray);
        objectArray = dependencyDescriptor.getAllIncludeRules();
        if (objectArray.length > 0 && dependencyArtifactDescriptorArray.length == 0) {
            printWriter.println(">");
        }
        UpdateOptions.printDependencyIncludeRules(moduleDescriptor, printWriter, (IncludeRule[])objectArray);
        ExcludeRule[] excludeRuleArray = dependencyDescriptor.getAllExcludeRules();
        if (excludeRuleArray.length > 0 && objectArray.length == 0 && dependencyArtifactDescriptorArray.length == 0) {
            printWriter.println(">");
        }
        UpdateOptions.printDependencyExcludeRules(moduleDescriptor, printWriter, excludeRuleArray);
        if (objectArray.length + excludeRuleArray.length + dependencyArtifactDescriptorArray.length == 0) {
            printWriter.println("/>");
            return;
        }
        printWriter.println("\t\t</dependency>");
    }

    private static void printAllMediators(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        Iterator iterator2 = moduleDescriptor.getAllDependencyDescriptorMediators().getAllRules().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            MapMatcher mapMatcher = (MapMatcher)entry.getKey();
            DependencyDescriptorMediator dependencyDescriptorMediator = (DependencyDescriptorMediator)entry.getValue();
            if (dependencyDescriptorMediator instanceof OverrideDependencyDescriptorMediator) {
                OverrideDependencyDescriptorMediator overrideDependencyDescriptorMediator = (OverrideDependencyDescriptorMediator)dependencyDescriptorMediator;
                printWriter.print("\t\t<override");
                printWriter.print(" org=\"" + XMLHelper.escape((String)mapMatcher.getAttributes().get("organisation")) + "\"");
                printWriter.print(" module=\"" + XMLHelper.escape((String)mapMatcher.getAttributes().get("module")) + "\"");
                printWriter.print(" matcher=\"" + XMLHelper.escape(mapMatcher.getPatternMatcher().getName()) + "\"");
                if (overrideDependencyDescriptorMediator.getBranch() != null) {
                    printWriter.print(" branch=\"" + XMLHelper.escape(overrideDependencyDescriptorMediator.getBranch()) + "\"");
                }
                if (overrideDependencyDescriptorMediator.getVersion() != null) {
                    printWriter.print(" rev=\"" + XMLHelper.escape(overrideDependencyDescriptorMediator.getVersion()) + "\"");
                }
                printWriter.println("/>");
                continue;
            }
            Message.verbose("ignoring unhandled DependencyDescriptorMediator: " + dependencyDescriptorMediator.getClass());
        }
    }

    private static void printDependencyExcludeRules(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, ExcludeRule[] excludeRuleArray) {
        if (excludeRuleArray.length > 0) {
            for (int i = 0; i < excludeRuleArray.length; ++i) {
                printWriter.print("\t\t\t<exclude");
                printWriter.print(" org=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getOrganisation()) + "\"");
                printWriter.print(" module=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getName()) + "\"");
                printWriter.print(" name=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getExt()) + "\"");
                String[] stringArray = excludeRuleArray[i].getConfigurations();
                if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                printWriter.print(" matcher=\"" + XMLHelper.escape(excludeRuleArray[i].getMatcher().getName()) + "\"");
                printWriter.println("/>");
            }
        }
    }

    private static void printDependencyIncludeRules(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, IncludeRule[] includeRuleArray) {
        if (includeRuleArray.length > 0) {
            for (int i = 0; i < includeRuleArray.length; ++i) {
                printWriter.print("\t\t\t<include");
                printWriter.print(" name=\"" + XMLHelper.escape(includeRuleArray[i].getId().getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(includeRuleArray[i].getId().getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(includeRuleArray[i].getId().getExt()) + "\"");
                String[] stringArray = includeRuleArray[i].getConfigurations();
                if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                printWriter.print(" matcher=\"" + XMLHelper.escape(includeRuleArray[i].getMatcher().getName()) + "\"");
                printWriter.println("/>");
            }
        }
    }

    private static void printDependencyArtefacts(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray) {
        if (dependencyArtifactDescriptorArray.length > 0) {
            for (int i = 0; i < dependencyArtifactDescriptorArray.length; ++i) {
                printWriter.print("\t\t\t<artifact");
                printWriter.print(" name=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getExt()) + "\"");
                String[] stringArray = dependencyArtifactDescriptorArray[i].getConfigurations();
                if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                UpdateOptions.printExtraAttributes(dependencyArtifactDescriptorArray[i], printWriter, " ");
                printWriter.println("/>");
            }
        }
    }

    private static void printExtraAttributes(ExtendableItem extendableItem, PrintWriter printWriter, String string) {
        String string2 = string;
        PrintWriter printWriter2 = printWriter;
        Map map2 = extendableItem.getQualifiedExtraAttributes();
        if (map2 != null) {
            String string3 = string2;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                printWriter2.print(string3 + entry.getKey() + "=\"" + XMLHelper.escape(entry.getValue().toString()) + "\"");
                string3 = " ";
            }
        }
    }

    private static void printPublications(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        printWriter.println("\t<publications>");
        Artifact[] artifactArray = moduleDescriptor.getAllArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            printWriter.print("\t\t<artifact");
            printWriter.print(" name=\"" + XMLHelper.escape(artifactArray[i].getName()) + "\"");
            printWriter.print(" type=\"" + XMLHelper.escape(artifactArray[i].getType()) + "\"");
            printWriter.print(" ext=\"" + XMLHelper.escape(artifactArray[i].getExt()) + "\"");
            printWriter.print(" conf=\"" + XMLHelper.escape(UpdateOptions.getConfs(moduleDescriptor, artifactArray[i])) + "\"");
            UpdateOptions.printExtraAttributes(artifactArray[i], printWriter, " ");
            printWriter.println("/>");
        }
        printWriter.println("\t</publications>");
    }

    private static void printConfigurations(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        if (configurationArray.length > 0) {
            printWriter.println("\t<configurations>");
            for (int i = 0; i < configurationArray.length; ++i) {
                Configuration configuration = configurationArray[i];
                printWriter.print("\t\t");
                UpdateOptions.printConfiguration(configuration, printWriter);
            }
            printWriter.println("\t</configurations>");
        }
    }

    protected static void printConfiguration(Configuration configuration, PrintWriter printWriter) {
        String[] stringArray;
        printWriter.print("<conf");
        printWriter.print(" name=\"" + XMLHelper.escape(configuration.getName()) + "\"");
        printWriter.print(" visibility=\"" + XMLHelper.escape(configuration.getVisibility().toString()) + "\"");
        if (configuration.getDescription() != null) {
            printWriter.print(" description=\"" + XMLHelper.escape(configuration.getDescription()) + "\"");
        }
        if ((stringArray = configuration.getExtends()).length > 0) {
            printWriter.print(" extends=\"");
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.print(XMLHelper.escape(stringArray[i]));
                if (i + 1 >= stringArray.length) continue;
                printWriter.print(",");
            }
            printWriter.print("\"");
        }
        if (!configuration.isTransitive()) {
            printWriter.println(" transitive=\"false\"");
        }
        if (configuration.getDeprecated() != null) {
            printWriter.print(" deprecated=\"" + XMLHelper.escape(configuration.getDeprecated()) + "\"");
        }
        UpdateOptions.printExtraAttributes(configuration, printWriter, " ");
        printWriter.println("/>");
    }

    private static void printInfoTag(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        ModuleDescriptor moduleDescriptor2;
        ExtendsDescriptor[] extendsDescriptorArray;
        String string;
        printWriter.println("\t<info organisation=\"" + XMLHelper.escape(moduleDescriptor.getModuleRevisionId().getOrganisation()) + "\"");
        printWriter.println("\t\tmodule=\"" + XMLHelper.escape(moduleDescriptor.getModuleRevisionId().getName()) + "\"");
        String string2 = moduleDescriptor.getResolvedModuleRevisionId().getBranch();
        if (string2 != null) {
            printWriter.println("\t\tbranch=\"" + XMLHelper.escape(string2) + "\"");
        }
        if ((string = moduleDescriptor.getResolvedModuleRevisionId().getRevision()) != null) {
            printWriter.println("\t\trevision=\"" + XMLHelper.escape(string) + "\"");
        }
        printWriter.println("\t\tstatus=\"" + XMLHelper.escape(moduleDescriptor.getStatus()) + "\"");
        printWriter.println("\t\tpublication=\"" + LogOptions.format(moduleDescriptor.getResolvedPublicationDate()) + "\"");
        if (moduleDescriptor.isDefault()) {
            printWriter.println("\t\tdefault=\"true\"");
        }
        if (moduleDescriptor instanceof DefaultModuleDescriptor && (extendsDescriptorArray = (ExtendsDescriptor[])moduleDescriptor).getNamespace() != null) {
            extendsDescriptorArray.getNamespace();
            if (!Namespace.getName().equals("system")) {
                StringBuffer stringBuffer = new StringBuffer("\t\tnamespace=\"");
                extendsDescriptorArray.getNamespace();
                printWriter.println(stringBuffer.append(XMLHelper.escape(Namespace.getName())).append("\"").toString());
            }
        }
        if (!moduleDescriptor.getExtraAttributes().isEmpty()) {
            UpdateOptions.printExtraAttributes(moduleDescriptor, printWriter, "\t\t");
            printWriter.println();
        }
        if ((moduleDescriptor2 = moduleDescriptor).getExtraInfo().size() > 0 || moduleDescriptor2.getHomePage() != null || moduleDescriptor2.getDescription() != null && moduleDescriptor2.getDescription().trim().length() > 0 || moduleDescriptor2.getLicenses().length > 0 || moduleDescriptor2.getInheritedDescriptors().length > 0) {
            Map.Entry entry;
            printWriter.println("\t>");
            extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
            for (int i = 0; i < extendsDescriptorArray.length; ++i) {
                ExtendsDescriptor extendsDescriptor = extendsDescriptorArray[i];
                entry = extendsDescriptor.getParentRevisionId();
                printWriter.print("\t\t<extends organisation=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry)).getOrganisation()) + "\" module=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry)).getName()) + "\" revision=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry)).getRevision()) + "\"");
                String string3 = extendsDescriptor.getLocation();
                if (string3 != null) {
                    printWriter.print(" location=\"" + XMLHelper.escape(string3) + "\"");
                }
                printWriter.print(" extendType=\"" + StringUtils.join(extendsDescriptor.getExtendsTypes(), ",") + "\"");
                printWriter.println("/>");
            }
            License[] licenseArray = moduleDescriptor.getLicenses();
            for (int i = 0; i < licenseArray.length; ++i) {
                entry = licenseArray[i];
                printWriter.print("\t\t<license ");
                if (((License)((Object)entry)).getName() != null) {
                    printWriter.print("name=\"" + XMLHelper.escape(((License)((Object)entry)).getName()) + "\" ");
                }
                if (((License)((Object)entry)).getUrl() != null) {
                    printWriter.print("url=\"" + XMLHelper.escape(((License)((Object)entry)).getUrl()) + "\" ");
                }
                printWriter.println("/>");
            }
            if (moduleDescriptor.getHomePage() != null || moduleDescriptor.getDescription() != null) {
                printWriter.print("\t\t<description");
                if (moduleDescriptor.getHomePage() != null) {
                    printWriter.print(" homepage=\"" + XMLHelper.escape(moduleDescriptor.getHomePage()) + "\"");
                }
                if (moduleDescriptor.getDescription() != null && moduleDescriptor.getDescription().trim().length() > 0) {
                    printWriter.println(">");
                    printWriter.println("\t\t" + XMLHelper.escape(moduleDescriptor.getDescription()));
                    printWriter.println("\t\t</description>");
                } else {
                    printWriter.println(" />");
                }
            }
            Iterator iterator2 = moduleDescriptor.getExtraInfo().entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = iterator2.next();
                if (entry.getValue() == null || ((String)entry.getValue()).length() == 0) continue;
                printWriter.print("\t\t<");
                printWriter.print(entry.getKey());
                printWriter.print(">");
                printWriter.print(XMLHelper.escape((String)entry.getValue()));
                printWriter.print("</");
                printWriter.print(entry.getKey());
                printWriter.println(">");
            }
            printWriter.println("\t</info>");
            return;
        }
        printWriter.println("\t/>");
    }

    private static String getConfs(ModuleDescriptor moduleDescriptor, Artifact artifact) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = moduleDescriptor.getConfigurationsNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Arrays.asList(moduleDescriptor.getArtifacts(stringArray[i])).contains(artifact)) continue;
            stringBuffer.append(stringArray[i]).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

