/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import slothLib.NLP.IMorpheme;
import slothLib.NLP.IMorphologicalAnalyzerResult;
import slothLib.NLP.MeCabMorpheme;
import slothLib.NLP.RemainOriginalFilter;
import slothLib.NLP.RemainPosFilter;
import slothLib.NLP.RemainRawFilter;

public class MeCabResult
implements IMorphologicalAnalyzerResult {
    private static Pattern regexResultLine = Pattern.compile("^(.*)\\t(.*,.*,.*,.*),(.*),(.*),(.*),(.*),(.*)$");
    private static Pattern regexResultLine2 = Pattern.compile("^(.*)\\t(.*,.*,.*,.*),(.*),(.*),(.*)$");
    private List<MeCabMorpheme> morphemeList = new ArrayList<MeCabMorpheme>();
    private String rawResult;
    private List<String> sequenceRawResult;
    private static RemainOriginalFilter remainOriginalFilter = new RemainOriginalFilter();
    private static RemainPosFilter remainPosFilter = new RemainPosFilter();
    private static RemainRawFilter remainRawFilter = new RemainRawFilter();

    public MeCabResult(String rawResult) {
        String[] lineList;
        this.rawResult = rawResult;
        this.sequenceRawResult = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        String[] stringArray = lineList = rawResult.split("\\n");
        int n = lineList.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String reading;
                Matcher match;
                String pronunciation;
                Matcher successMatch;
                String line;
                block8: {
                    Matcher match2;
                    block7: {
                        line = stringArray[n2];
                        successMatch = null;
                        pronunciation = "*";
                        match = regexResultLine.matcher(line);
                        if (!match.matches() && line.equals("EOS")) {
                            this.sequenceRawResult.add(sb.toString());
                            sb = new StringBuffer();
                        }
                        match2 = null;
                        if (!match.matches()) break block7;
                        pronunciation = match.group(7);
                        successMatch = match;
                        break block8;
                    }
                    match2 = regexResultLine2.matcher(line);
                    if (!match2.matches()) break block9;
                    successMatch = match2;
                }
                String raw = successMatch.group(1);
                String pos = successMatch.group(2);
                String conjugationPattern = successMatch.group(3);
                String conjugationForm = successMatch.group(4);
                String original = successMatch.group(5);
                if (!match.matches()) {
                    original = raw;
                    reading = raw;
                } else {
                    reading = successMatch.group(6);
                }
                sb.append(line);
                sb.append("\n");
                MeCabMorpheme morpheme = new MeCabMorpheme(raw, pos, conjugationPattern, conjugationForm, original, reading, pronunciation);
                this.morphemeList.add(morpheme);
            }
            ++n2;
        }
    }

    public String getRawResult() {
        return this.rawResult;
    }

    public int getSequenceCount() {
        return this.sequenceRawResult.size();
    }

    public MeCabResult[] getSequenceResults() {
        MeCabResult[] result = new MeCabResult[this.sequenceRawResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new MeCabResult(this.sequenceRawResult.get(i));
            ++i;
        }
        return result;
    }

    public MeCabMorpheme get(int index) {
        return this.morphemeList.get(index);
    }

    public void set(int index, MeCabMorpheme value) {
        this.morphemeList.set(index, value);
    }

    @Override
    public IMorpheme[] getMorphemes() {
        return this.morphemeList.toArray(new IMorpheme[0]);
    }

    @Override
    public String[] getRawArray() {
        return remainRawFilter.doFilter(this.getMorphemes());
    }

    @Override
    public String[] getOriginalArray() {
        return remainOriginalFilter.doFilter(this.getMorphemes());
    }

    @Override
    public String[] getPOSArray() {
        return remainPosFilter.doFilter(this.getMorphemes());
    }
}

