/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import java.util.ArrayList;
import slothLib.linearAlgebra.featureVector.ClusteringDistanceType;
import slothLib.linearAlgebra.featureVector.DendrogramNode;
import slothLib.linearAlgebra.featureVector.HierarchicalClusteringResult;
import slothLib.linearAlgebra.featureVector.ICalculatorScalarFromTwoVectors;
import slothLib.linearAlgebra.featureVector.IDendrogramNode;
import slothLib.linearAlgebra.featureVector.IHierarchicalClusteringProcess;
import slothLib.linearAlgebra.featureVector.IVector;

public abstract class HierarchicalClusteringProcess<T>
implements IHierarchicalClusteringProcess<T> {
    public static final double INFINITE_DISTANCE = Double.MAX_VALUE;
    protected IVector<T>[] vectors;
    private double[][] distanceTable;
    protected int itemCount;
    protected ICalculatorScalarFromTwoVectors<T> calculator;
    protected ClusteringDistanceType dType;
    protected double ds;
    protected int[] clusterID;

    public HierarchicalClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType) {
        this.vectors = vectors;
        this.itemCount = vectors.length;
        this.calculator = calculator;
        this.dType = dType;
        this.ds = 1.0;
        if (dType == ClusteringDistanceType.Similarity) {
            this.ds = -1.0;
        }
        this.distanceTable = this.createDistanceTable(vectors);
        this.clusterID = new int[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            this.clusterID[i] = i;
            ++i;
        }
    }

    protected abstract void union(int var1, int var2);

    @Override
    public HierarchicalClusteringResult<T> doClustering() {
        return this.doClustering(1, Double.MAX_VALUE);
    }

    @Override
    public HierarchicalClusteringResult<T> doClustering(int thresholdClusterCount) {
        return this.doClustering(thresholdClusterCount, Double.MAX_VALUE);
    }

    @Override
    public HierarchicalClusteringResult<T> doClustering(double thresholdDistanceOrSimilarity) {
        return this.doClustering(1, thresholdDistanceOrSimilarity * this.ds);
    }

    @Override
    public HierarchicalClusteringResult<T> doClustering(int thresholdClusterCount, double thresholdDistanceOrSimilarity) {
        if (thresholdClusterCount < 1) {
            throw new IllegalArgumentException("\u30af\u30e9\u30b9\u30bf\u306e\u6700\u7d42\u500b\u6570\u306f1\u4ee5\u4e0a\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002thresholdClusterCount");
        }
        double thresholdDs = thresholdDistanceOrSimilarity;
        int i = 0;
        while (i < this.itemCount) {
            this.clusterID[i] = i;
            ++i;
        }
        ArrayList<IDendrogramNode<T>> nodeList = new ArrayList<IDendrogramNode<T>>();
        int currentClusterCount = this.itemCount;
        while (currentClusterCount > thresholdClusterCount) {
            int cid1 = -1;
            int cid2 = -1;
            double minDistance = Double.MAX_VALUE;
            int i2 = 0;
            while (i2 < this.itemCount - 1) {
                if (this.clusterID[i2] == i2) {
                    int j = i2 + 1;
                    while (j < this.itemCount) {
                        if (this.clusterID[j] == j && this.distanceTable[i2][j] < minDistance) {
                            minDistance = this.distanceTable[i2][j];
                            cid1 = i2;
                            cid2 = j;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            if (minDistance > thresholdDs || cid1 == -1 || cid2 == -1) break;
            this.union(cid1, cid2);
            nodeList.add(this.getDendrogramNode(cid1, cid2, minDistance));
            --currentClusterCount;
        }
        HierarchicalClusteringResult<T> result = new HierarchicalClusteringResult<T>((IDendrogramNode[])nodeList.toArray(), this.vectors, this.dType);
        return result;
    }

    protected IDendrogramNode<T> getDendrogramNode(int cid1, int cid2, double minDistance) {
        return new DendrogramNode(cid1, cid2, minDistance);
    }

    protected double getDistance(int cid1, int cid2) {
        if (cid1 < cid2) {
            return this.distanceTable[cid1][cid2];
        }
        if (cid1 > cid2) {
            return this.distanceTable[cid2][cid1];
        }
        throw new RuntimeException("\u3053\u3053\u306b\u30a2\u30af\u30bb\u30b9\u3057\u306a\u3044\u3088\u3046\u306a\u8a2d\u8a08\u306b\u5909\u3048\u3066\u304f\u3060\u3055\u3044\u3002");
    }

    protected void setDistance(int cid1, int cid2, double distance) {
        if (cid1 < cid2) {
            this.distanceTable[cid1][cid2] = distance;
        } else if (cid1 > cid2) {
            this.distanceTable[cid2][cid1] = distance;
        } else {
            throw new RuntimeException("\u3053\u3053\u306b\u30a2\u30af\u30bb\u30b9\u3057\u306a\u3044\u3088\u3046\u306a\u8a2d\u8a08\u306b\u5909\u3048\u3066\u304f\u3060\u3055\u3044\u3002");
        }
    }

    private double[][] createDistanceTable(IVector<T>[] vectors) {
        int count = vectors.length;
        double[][] distanceTable = new double[count][count];
        int i = 0;
        while (i < count - 1) {
            int j = i + 1;
            while (j < count) {
                distanceTable[i][j] = this.calculator.doCalculate(vectors[i], vectors[j]) * this.ds;
                ++j;
            }
            ++i;
        }
        return distanceTable;
    }
}

