/*
 * Decompiled with CFR 0.152.
 */
package slothLib.portUtil;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import slothLib.web.search.WebSearchException;

public class PortUtil {
    private static String BROWSER = "firefox";

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static <T> List<T> toList(T[] array) {
        ArrayList<T> tmp = new ArrayList<T>();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            tmp.add(t);
            ++n2;
        }
        return tmp;
    }

    public static Proxy createProxy(String uri) {
        try {
            URI tmp = new URI(uri);
            InetSocketAddress addr = new InetSocketAddress(tmp.getHost(), tmp.getPort());
            return new Proxy(Proxy.Type.HTTP, addr);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean fileExists(String filename) {
        return new File(filename).exists();
    }

    public static void fileDelete(String filename) throws IOException {
        new File(filename).delete();
    }

    public static boolean processExited(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public static String getHttpVersion(HttpURLConnection con) {
        return con.getHeaderField("HTTP-Version");
    }

    public static List<HttpCookie> getCookies(HttpURLConnection con) {
        return new ArrayList<HttpCookie>();
    }

    public static String getCharacterSet(HttpURLConnection con) {
        return con.getHeaderField("charset");
    }

    public static Document getDocumentFromURL(String requestURL, Proxy proxy) throws WebSearchException {
        int statusCode;
        Document xmlDoc = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = dbfactory.newDocumentBuilder();
            HttpURLConnection con = proxy != null ? (HttpURLConnection)new URL(requestURL).openConnection(proxy) : (HttpURLConnection)new URL(requestURL).openConnection();
            InputStream is = con.getInputStream();
            xmlDoc = builder.parse(is);
            statusCode = con.getResponseCode();
        }
        catch (IOException e) {
            throw new WebSearchException(e);
        }
        catch (ParserConfigurationException e) {
            throw new WebSearchException(e);
        }
        catch (SAXException e) {
            throw new WebSearchException(e);
        }
        if (statusCode != 200) {
            Element xmlRoot = xmlDoc.getDocumentElement();
            String errorMessage = PortUtil.getElementString(xmlRoot.getElementsByTagName("Message"));
            PortUtil.throwException(statusCode, errorMessage);
        }
        return xmlDoc;
    }

    private static String getElementString(NodeList nodeList) {
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0).getTextContent();
    }

    private static void throwException(int errorCode, String errorMessage) throws WebSearchException {
        switch (errorCode) {
            case 400: {
                throw new WebSearchException(WebSearchException.HttpCode.BadRequest, errorMessage);
            }
            case 403: {
                throw new WebSearchException(WebSearchException.HttpCode.Forbidden, errorMessage);
            }
            case 503: {
                throw new WebSearchException(WebSearchException.HttpCode.ServiceUnavailable, errorMessage);
            }
        }
        throw new WebSearchException(WebSearchException.HttpCode.Unknown, "YahooWebSearch\u3067\u60f3\u5b9a\u5916\u306eHTTP\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\uff08\u30a8\u30e9\u30fc\u30b3\u30fc\u30c9: " + errorCode + "\uff09" + errorMessage);
    }

    public static String absoluteUri(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return uriString;
        }
        String result = uri.normalize().toString();
        return result;
    }

    public static String getProxyURL(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        InetSocketAddress addr = (InetSocketAddress)proxy.address();
        String tmp = "http://" + addr.getHostName() + ":" + addr.getPort() + "/";
        return tmp;
    }

    public static String readFully(InputStream is, String encoding) throws IOException {
        String tmp;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(is, encoding));
        StringBuffer sb = new StringBuffer();
        while ((tmp = reader.readLine()) != null) {
            sb.append(String.valueOf(tmp) + "\n");
        }
        return sb.toString();
    }

    public static int readFully(InputStream is, byte[] buffer, int off, int len) throws IOException {
        int orgOff = off;
        while (len > 0) {
            int num = is.read(buffer, off, len);
            if (num < 0) break;
            off += num;
            len -= num;
        }
        return off - orgOff;
    }

    public static void openUrl(String openURL) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(BROWSER, openURL);
        try {
            pb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

