/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.IWebSearch;
import slothLib.web.search.WebSearchException;
import slothLib.web.search.YahooJpWebElement;
import slothLib.web.search.YahooJpWebSearchResult;

public class YahooJpWebSearch
implements IWebSearch {
    private static int MAX_NUM = 20;
    private String applicationID;
    private String baseRequestURL;
    private static String DEFAULT_URL = "http://search.yahooapis.jp/WebSearchService/V2/webSearch";
    private SearchType type;
    private int start;
    private SearchFormat format;
    private boolean adultOk;
    private boolean similarOk;
    private String language;
    private String country;
    private String[] site;
    Map<String, Boolean> alreadyGotURL = new HashMap<String, Boolean>();
    private Proxy proxy;

    public YahooJpWebSearch(String applicationID, String baseRequestURL) {
        this.applicationID = applicationID;
        this.baseRequestURL = baseRequestURL;
        this.type = SearchType.all;
        this.start = 1;
        this.format = SearchFormat.any;
        this.adultOk = false;
        this.similarOk = false;
        this.language = "ja";
        this.country = null;
        this.site = null;
    }

    public YahooJpWebSearch(String applicationID) {
        this(applicationID, DEFAULT_URL);
    }

    @Override
    public YahooJpWebSearchResult doSearch(String query, int maxNumber) throws WebSearchException {
        this.alreadyGotURL.clear();
        return this.doSearchOver(query, maxNumber);
    }

    public long getTotalNumber(String query) throws WebSearchException {
        return this.doSearch(query, 1).getTotalResultsAvailable();
    }

    public SearchType getType() {
        return this.type;
    }

    public void setType(SearchType value) {
        this.type = value;
    }

    public SearchFormat getFormat() {
        return this.format;
    }

    public void setFormat(SearchFormat value) {
        this.format = value;
    }

    public boolean getAdultOk() {
        return this.adultOk;
    }

    public void setAdultOk(boolean value) {
        this.adultOk = value;
    }

    public boolean getSimilarOk() {
        return this.similarOk;
    }

    public void setSimilarOk(boolean value) {
        this.similarOk = value;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        this.language = value;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String value) {
        this.country = value;
    }

    public String[] getSite() {
        return this.site;
    }

    public void setSite(String[] value) {
        this.site = value;
    }

    public void setProxy(String value) {
        this.proxy = PortUtil.isNullOrEmpty(value) ? null : PortUtil.createProxy(value);
    }

    public String getProxy() {
        return PortUtil.getProxyURL(this.proxy);
    }

    private YahooJpWebSearchResult doSearchOriginal(String query, int results, int start) throws WebSearchException {
        String requestURL = this.makeRequestURL(query, this.type, results, start, this.format, this.adultOk, this.similarOk, this.language, this.country, this.site);
        System.err.println(requestURL);
        Document xmlDoc = PortUtil.getDocumentFromURL(requestURL, this.proxy);
        Element xmlRoot = xmlDoc.getDocumentElement();
        long totalResultsAvailable = Long.parseLong(xmlRoot.getAttribute("totalResultsAvailable"));
        int totalResultsReturned = Integer.parseInt(xmlRoot.getAttribute("totalResultsReturned"));
        int firstResultPosition = Integer.parseInt(xmlRoot.getAttribute("firstResultPosition"));
        ArrayList<YahooJpWebElement> ResultElementList = new ArrayList<YahooJpWebElement>();
        NodeList xmlResultList = xmlRoot.getElementsByTagName("Result");
        int rank = start - 1;
        String firstURL = this.getElementString(((Element)xmlResultList.item(0)).getElementsByTagName("Url"));
        if (this.alreadyGotURL.containsKey(firstURL)) {
            return new YahooJpWebSearchResult(query, 0L, 0, -1, new YahooJpWebElement[0]);
        }
        this.alreadyGotURL.put(firstURL, true);
        int i = 0;
        while (i < xmlResultList.getLength()) {
            Element xmlResult = (Element)xmlResultList.item(i);
            ++rank;
            String title = this.getElementString(xmlResult.getElementsByTagName("Title"));
            String summary = this.getElementString(xmlResult.getElementsByTagName("Summary"));
            String url = this.getElementString(xmlResult.getElementsByTagName("Url"));
            String date = this.getElementString(xmlResult.getElementsByTagName("ModificationDate"));
            String clickurl = this.getElementString(xmlResult.getElementsByTagName("ClickUrl"));
            String mimetype = this.getElementString(xmlResult.getElementsByTagName("MimeType"));
            String cacheUrl = null;
            String cacheSize = null;
            NodeList xmlCacheNode = xmlResult.getElementsByTagName("Cache");
            if (xmlCacheNode != null) {
                int j = 0;
                while (j < xmlCacheNode.getLength()) {
                    Element xmlCacheElement = (Element)xmlCacheNode.item(j);
                    cacheUrl = this.getElementString(xmlCacheElement.getElementsByTagName("Url"));
                    cacheSize = this.getElementString(xmlCacheElement.getElementsByTagName("Size"));
                    ++j;
                }
            }
            YahooJpWebElement result = new YahooJpWebElement(rank, title, summary, url, clickurl, mimetype, date, cacheUrl, cacheSize);
            ResultElementList.add(result);
            ++i;
        }
        return new YahooJpWebSearchResult(query, totalResultsAvailable, totalResultsReturned, firstResultPosition, ResultElementList.toArray(new YahooJpWebElement[0]));
    }

    private YahooJpWebSearchResult doSearchOver(String query, int results) throws WebSearchException {
        YahooJpWebSearchResult r;
        int loop = (results - 1) / MAX_NUM;
        ArrayList<YahooJpWebElement> resultElementList = new ArrayList<YahooJpWebElement>();
        long totalResultsAvailable = 0L;
        int i = 0;
        while (i < loop) {
            r = this.doSearchOriginal(query, MAX_NUM, i * MAX_NUM + this.start);
            if (r.getFirstResultPosition() == -1) break;
            totalResultsAvailable = r.getTotalResultsAvailable();
            resultElementList.addAll(PortUtil.toList(r.getResultElements()));
            ++i;
        }
        r = this.doSearchOriginal(query, results - loop * MAX_NUM, loop * MAX_NUM + this.start);
        resultElementList.addAll(PortUtil.toList(r.getResultElements()));
        if (r.getFirstResultPosition() != -1) {
            totalResultsAvailable = r.getTotalResultsAvailable();
        }
        return new YahooJpWebSearchResult(query, totalResultsAvailable, resultElementList.size(), 1, resultElementList.toArray(new YahooJpWebElement[0]));
    }

    private String getElementString(NodeList nodeList) {
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0).getTextContent();
    }

    private String makeRequestURL(String query, SearchType type, int results, int start, SearchFormat format, boolean adultOk, boolean similarOk, String language, String country, String[] site) {
        String strType = "";
        String strFormat = "";
        String strAdult = "";
        String strSimilar = "";
        String strLanguage = "";
        String strCountry = "";
        String strSite = "";
        switch (type) {
            case all: {
                break;
            }
            case any: {
                strType = "&type=any";
                break;
            }
            case phrase: {
                strType = "&type=phrase";
            }
        }
        switch (format) {
            case any: {
                break;
            }
            case html: {
                strFormat = "&format=html";
                break;
            }
            case msword: {
                strFormat = "&format=msword";
                break;
            }
            case pdf: {
                strFormat = "&format=pdf";
                break;
            }
            case ppt: {
                strFormat = "&format=ppt";
                break;
            }
            case rss: {
                strFormat = "&format=rss";
                break;
            }
            case txt: {
                strFormat = "&format=txt";
                break;
            }
            case xls: {
                strFormat = "&format=xls";
            }
        }
        if (adultOk) {
            strAdult = "&adulat_ok=1";
        }
        if (similarOk) {
            strSimilar = "&similar_ok=1";
        }
        strLanguage = PortUtil.isNullOrEmpty(language) ? "&language=ja" : "&language=" + language;
        if (!PortUtil.isNullOrEmpty(country)) {
            strCountry = "&country=" + country;
        }
        if (site != null) {
            if (site.length > 30) {
                throw new IllegalArgumentException("site\u306b\u6307\u5b9a\u3067\u304d\u308b\u30c9\u30e1\u30a4\u30f3\u306f30\u500b\u307e\u3067\u3067\u3059 " + site);
            }
            String[] stringArray = site;
            int n = site.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                strSite = String.valueOf(strSite) + "&site=" + s;
                ++n2;
            }
        }
        String codedQuery = query;
        try {
            codedQuery = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        String uriString = String.valueOf(this.baseRequestURL) + "?appid=" + this.applicationID + "&query=" + codedQuery + strType + "&results=" + results + "&start=" + start + strFormat + strAdult + strSimilar + strLanguage + strCountry + strSite;
        String result = PortUtil.absoluteUri(uriString);
        return result;
    }

    public static enum SearchFormat {
        any,
        html,
        msword,
        pdf,
        ppt,
        rss,
        txt,
        xls;

    }

    public static enum SearchType {
        all,
        any,
        phrase;

    }
}

