/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.FileHeader;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class FileWindow
extends JInternalFrame
implements ActionListener {
    Main db;
    SourceInfo sourceInfo;
    FileTextArea textArea;
    FileHeader fileHeader;
    JScrollPane p;
    int currentPos;
    JLabel statusBar;

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!cmd.equals("Cut")) {
            if (cmd.equals("Copy")) {
                this.textArea.copy();
            } else if (cmd.equals("Paste")) {
                // empty if block
            }
        }
    }

    void runToCursor(ActionEvent e) {
        try {
            this.db.runToCursor(this.getUrl(), this.textArea.getLineOfOffset(this.textArea.getCaretPosition()) + 1, e);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void load() {
        Scriptable scope = this.db.getScope();
        if (scope == null) {
            MessageDialogWrapper.showMessageDialog(this.db, "Can't load scripts: no scope available", "Run", 0);
        } else {
            String url = this.getUrl();
            if (url != null) {
                new Thread(new LoadFile(this.db, scope, url)).start();
            }
        }
    }

    public int getPosition(int line) {
        int result = -1;
        try {
            result = this.textArea.getLineStartOffset(line);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return result;
    }

    boolean isBreakPoint(int line) {
        return this.sourceInfo.hasBreakpoint(line);
    }

    void toggleBreakPoint(int line) {
        if (!this.isBreakPoint(line)) {
            this.setBreakPoint(line);
        } else {
            this.clearBreakPoint(line);
        }
    }

    void setBreakPoint(int line) {
        if (this.sourceInfo.placeBreakpoint(line)) {
            this.fileHeader.repaint();
        }
    }

    void clearBreakPoint(int line) {
        if (this.sourceInfo.removeBreakpoint(line)) {
            this.fileHeader.repaint();
        }
    }

    FileWindow(Main db, SourceInfo sourceInfo) {
        super(SourceInfo.getShortName(sourceInfo.getUrl()), true, true, true, true);
        this.db = db;
        this.sourceInfo = sourceInfo;
        this.updateToolTip();
        this.currentPos = -1;
        this.textArea = new FileTextArea(this);
        this.textArea.setRows(24);
        this.textArea.setColumns(80);
        this.p = new JScrollPane();
        this.fileHeader = new FileHeader(this);
        this.p.setViewportView(this.textArea);
        this.p.setRowHeaderView(this.fileHeader);
        this.setContentPane(this.p);
        this.pack();
        this.updateText();
        this.textArea.select(0);
    }

    private void updateToolTip() {
        Component c = this.getComponent(1);
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(this.getUrl());
        }
    }

    public String getUrl() {
        return this.sourceInfo.getUrl();
    }

    void updateText() {
        String newText = this.sourceInfo.getSource();
        if (!this.textArea.getText().equals(newText)) {
            this.textArea.setText(newText);
            int pos = 0;
            if (this.currentPos != -1) {
                pos = this.currentPos;
            }
            this.textArea.select(pos);
        }
        this.fileHeader.update();
        this.fileHeader.repaint();
    }

    void setPosition(int pos) {
        this.textArea.select(pos);
        this.currentPos = pos;
        this.fileHeader.repaint();
    }

    void select(int start, int end) {
        int docEnd = this.textArea.getDocument().getLength();
        this.textArea.select(docEnd, docEnd);
        this.textArea.select(start, end);
    }

    public void dispose() {
        this.db.removeWindow(this);
        super.dispose();
    }
}

