/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Pack {
    private static final String sSp10 = "          ";
    private static final String sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final int IS_STAR = -1;
    private static final String NATIVE_CODES = "sSiIlL";
    private static final String sTooFew = "too few arguments";
    private static final byte[] hex_table;
    private static final byte[] uu_table;
    private static final byte[] b64_table;
    private static final byte[] sHexDigits;
    private static final int[] b64_xtable;
    private static final Converter[] converters;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static StringBuffer encodes(Ruby runtime, StringBuffer io2Append, String stringToEncode, int charCount, char encodingType) {
        char lNextChar;
        char lCurChar;
        char lPadding;
        charCount = charCount < stringToEncode.length() ? charCount : stringToEncode.length();
        io2Append.ensureCapacity(charCount * 4 / 3 + 6);
        int i = 0;
        byte[] lTranslationTable = encodingType == 'u' ? uu_table : b64_table;
        char[] charsToEncode = stringToEncode.toCharArray();
        if (encodingType == 'u') {
            if (charCount >= lTranslationTable.length) {
                throw runtime.newArgumentError("" + charCount + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + lTranslationTable.length);
            }
            io2Append.append((char)lTranslationTable[charCount]);
            lPadding = '`';
        } else {
            lPadding = '=';
        }
        while (charCount >= 3) {
            lCurChar = charsToEncode[i++];
            lNextChar = charsToEncode[i++];
            char lNextNextChar = charsToEncode[i++];
            io2Append.append((char)lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append((char)lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append((char)lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append((char)lTranslationTable[0x3F & lNextNextChar]);
            charCount -= 3;
        }
        if (charCount == 2) {
            lCurChar = charsToEncode[i++];
            lNextChar = charsToEncode[i++];
            io2Append.append((char)lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append((char)lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append((char)lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(lPadding);
        } else if (charCount == 1) {
            lCurChar = charsToEncode[i++];
            io2Append.append((char)lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append((char)lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(lPadding);
            io2Append.append(lPadding);
        }
        io2Append.append('\n');
        return io2Append;
    }

    private static StringBuffer qpencode(StringBuffer io2Append, String i2Encode, int iLength) {
        io2Append.ensureCapacity(1024);
        int lCurLineLength = 0;
        int lPrevChar = -1;
        char[] l2Encode = i2Encode.toCharArray();
        try {
            int i = 0;
            while (true) {
                int lCurChar;
                if ((lCurChar = l2Encode[i]) > 126 || lCurChar < 32 && lCurChar != 10 && lCurChar != 9 || lCurChar == 61) {
                    io2Append.append('=');
                    io2Append.append((char)hex_table[lCurChar >> 4]);
                    io2Append.append((char)hex_table[lCurChar & 0xF]);
                    lCurLineLength += 3;
                    lPrevChar = -1;
                } else if (lCurChar == 10) {
                    if (lPrevChar == 32 || lPrevChar == 9) {
                        io2Append.append('=');
                        io2Append.append((char)lCurChar);
                    }
                    io2Append.append((char)lCurChar);
                    lCurLineLength = 0;
                    lPrevChar = lCurChar;
                } else {
                    io2Append.append((char)lCurChar);
                    ++lCurLineLength;
                    lPrevChar = lCurChar;
                }
                if (lCurLineLength > iLength) {
                    io2Append.append('=');
                    io2Append.append('\n');
                    lCurLineLength = 0;
                    lPrevChar = 10;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (lCurLineLength > 0) {
                io2Append.append('=');
                io2Append.append('\n');
            }
            return io2Append;
        }
    }

    public static RubyArray unpack(Ruby runtime, ByteList encodedString, ByteList formatString) {
        RubyArray result = runtime.newArray();
        ByteBuffer format = ByteBuffer.wrap(formatString.unsafeBytes(), formatString.begin(), formatString.length());
        ByteBuffer encode = ByteBuffer.wrap(encodedString.unsafeBytes(), encodedString.begin(), encodedString.length());
        byte type = 0;
        byte next = Pack.safeGet(format);
        block23: while (next != 0) {
            type = next;
            next = Pack.safeGet(format);
            if (next == 95 || next == 33) {
                if (NATIVE_CODES.indexOf(type) == -1) {
                    throw runtime.newArgumentError("'" + next + "' allowed only after types " + NATIVE_CODES);
                }
                next = Pack.safeGet(format);
            }
            int occurrences = 0;
            if (next == 0) {
                occurrences = 1;
            } else if (next == 42) {
                occurrences = -1;
                next = Pack.safeGet(format);
            } else if (Character.isDigit((char)(next & 0xFF))) {
                occurrences = 0;
                do {
                    occurrences = occurrences * 10 + Character.digit((char)(next & 0xFF), 10);
                } while ((next = Pack.safeGet(format)) != 0 && Character.isDigit((char)(next & 0xFF)));
            } else {
                occurrences = type == 64 ? 0 : 1;
            }
            Converter converter = converters[type];
            if (converter != null) {
                Pack.decode(runtime, encode, occurrences, result, converter);
                type = next;
                continue;
            }
            switch (type) {
                case 64: {
                    encode.position(occurrences);
                    break;
                }
                case 37: {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 65: {
                    byte c;
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    int t = occurrences - 1;
                    while (occurrences > 0 && ((c = potential[t]) == 0 || c == 32)) {
                        --occurrences;
                        --t;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(potential, 0, occurrences, false)));
                    break;
                }
                case 90: {
                    char c;
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    int t = occurrences - 1;
                    while (occurrences > 0 && (c = (char)potential[t]) == '\u0000') {
                        --occurrences;
                        --t;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(potential, 0, occurrences, false)));
                    break;
                }
                case 97: {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    result.append(RubyString.newString(runtime, new ByteList(potential, false)));
                    break;
                }
                case 98: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)encode.get();
                        lElem[lCurByte] = (bits & 1) != 0 ? 49 : 48;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 66: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)encode.get();
                        lElem[lCurByte] = (bits & 0x80) != 0 ? 49 : 48;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 104: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits >>>= 4) : (int)encode.get();
                        lElem[lCurByte] = sHexDigits[bits & 0xF];
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 72: {
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits <<= 4) : (int)encode.get();
                        lElem[lCurByte] = sHexDigits[bits >>> 4 & 0xF];
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, false)));
                    break;
                }
                case 117: {
                    int length = encode.remaining() * 3 / 4;
                    byte[] lElem = new byte[length];
                    int index = 0;
                    int total = 0;
                    byte s = encode.get();
                    while (encode.hasRemaining() && s > 32 && s < 97) {
                        byte[] hunk = new byte[3];
                        int len = s - 32 & 0x3F;
                        s = Pack.safeGet(encode);
                        if ((total += len) > length) {
                            len -= total - length;
                            total = length;
                        }
                        while (len > 0) {
                            int d;
                            int c;
                            int b;
                            int a;
                            int mlen;
                            int n = mlen = len > 3 ? 3 : len;
                            if (encode.hasRemaining() && s >= 32) {
                                a = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                a = 0;
                            }
                            if (encode.hasRemaining() && s >= 32) {
                                b = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                b = 0;
                            }
                            if (encode.hasRemaining() && s >= 32) {
                                c = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                c = 0;
                            }
                            if (encode.hasRemaining() && s >= 32) {
                                d = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                d = 0;
                            }
                            hunk[0] = (byte)((a << 2 | b >> 4) & 0xFF);
                            hunk[1] = (byte)((b << 4 | c >> 2) & 0xFF);
                            hunk[2] = (byte)((c << 6 | d) & 0xFF);
                            for (int i = 0; i < mlen; ++i) {
                                lElem[index++] = hunk[i];
                            }
                            len -= mlen;
                        }
                        if (s == 13) {
                            s = Pack.safeGet(encode);
                        }
                        if (s == 10) {
                            s = Pack.safeGet(encode);
                            continue;
                        }
                        if (!encode.hasRemaining()) continue;
                        if (Pack.safeGet(encode) == 10) {
                            Pack.safeGet(encode);
                            continue;
                        }
                        if (!encode.hasRemaining()) continue;
                        encode.position(encode.position() - 1);
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, 0, index, false)));
                    break;
                }
                case 109: {
                    int length = encode.remaining() * 3 / 4;
                    byte[] lElem = new byte[length];
                    int a = -1;
                    int b = -1;
                    int c = 0;
                    int index = 0;
                    while (encode.hasRemaining()) {
                        int d;
                        byte s;
                        while ((s = Pack.safeGet(encode)) == 13 || s == 10) {
                        }
                        a = b64_xtable[s];
                        if (a == -1 || (b = b64_xtable[s = Pack.safeGet(encode)]) == -1 || (c = b64_xtable[s = Pack.safeGet(encode)]) == -1 || (d = b64_xtable[s = Pack.safeGet(encode)]) == -1) break;
                        lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                        lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                        lElem[index++] = (byte)((c << 6 | d) & 0xFF);
                        a = -1;
                    }
                    if (a != -1 && b != -1) {
                        lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                        if (c != -1) {
                            lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                        }
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, 0, index, false)));
                    break;
                }
                case 77: {
                    byte[] lElem = new byte[Math.max(encode.remaining(), 0)];
                    int index = 0;
                    while (true) {
                        byte c = Pack.safeGet(encode);
                        if (!encode.hasRemaining()) break;
                        if (c != 61) {
                            lElem[index++] = c;
                            continue;
                        }
                        byte c1 = Pack.safeGet(encode);
                        if (!encode.hasRemaining()) break;
                        if (c1 == 10) continue;
                        byte c2 = Pack.safeGet(encode);
                        if (!encode.hasRemaining()) break;
                        byte value = (byte)(Character.digit((char)(c1 & 0xFF), 16) * 16 + Character.digit((char)(c2 & 0xFF), 16));
                        lElem[index++] = value;
                    }
                    result.append(RubyString.newString(runtime, new ByteList(lElem, 0, index, false)));
                    break;
                }
                case 85: {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] toUnpack = new byte[occurrences];
                    encode.get(toUnpack);
                    CharBuffer lUtf8 = null;
                    try {
                        Charset utf8 = Charset.forName("UTF-8");
                        CharsetDecoder utf8Decoder = utf8.newDecoder();
                        utf8Decoder.onMalformedInput(CodingErrorAction.REPORT);
                        utf8Decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                        ByteBuffer buffer = ByteBuffer.wrap(toUnpack);
                        lUtf8 = utf8Decoder.decode(buffer);
                    }
                    catch (CharacterCodingException cce) {
                        throw runtime.newArgumentError("malformed UTF-8 character");
                    }
                    while (occurrences-- > 0 && lUtf8.hasRemaining()) {
                        long lCurChar = lUtf8.get();
                        result.append(runtime.newFixnum(lCurChar));
                    }
                    continue block23;
                }
                case 88: {
                    if (occurrences == -1) {
                        occurrences = encode.limit() - encode.remaining();
                    }
                    try {
                        encode.position(encode.position() - occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': X outside of string");
                    }
                }
                case 120: {
                    if (occurrences == -1) {
                        occurrences = encode.remaining();
                    }
                    try {
                        encode.position(encode.position() + occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': x outside of string");
                    }
                }
            }
        }
        return result;
    }

    private static byte safeGet(ByteBuffer encode) {
        return encode.hasRemaining() ? encode.get() : (byte)0;
    }

    public static void decode(Ruby runtime, ByteBuffer encode, int occurrences, RubyArray result, Converter converter) {
        int lPadLength = 0;
        if (occurrences == -1) {
            occurrences = encode.remaining() / converter.size;
        } else if (occurrences > encode.remaining() / converter.size) {
            lPadLength = occurrences - encode.remaining() / converter.size;
            occurrences = encode.remaining() / converter.size;
        }
        while (occurrences-- > 0) {
            result.append(converter.decode(runtime, encode));
        }
        while (lPadLength-- > 0) {
            result.append(runtime.getNil());
        }
    }

    public static int encode(Ruby runtime, int occurrences, StringBuffer result, RubyArray list, int index, Converter converter) {
        int listSize = list.size();
        while (occurrences-- > 0) {
            if (listSize-- <= 0) {
                throw runtime.newArgumentError(sTooFew);
            }
            IRubyObject from = list.eltInternal(index++);
            converter.encode(runtime, from, result);
        }
        return index;
    }

    private static final StringBuffer shrink(StringBuffer i2Shrink, int iLength) {
        iLength = i2Shrink.length() - iLength;
        if (iLength < 0) {
            throw new IllegalArgumentException();
        }
        i2Shrink.setLength(iLength);
        return i2Shrink;
    }

    private static final StringBuffer grow(StringBuffer i2Grow, String iPads, int iLength) {
        int lPadLength = iPads.length();
        while (iLength >= lPadLength) {
            i2Grow.append(iPads);
            iLength -= lPadLength;
        }
        i2Grow.append(iPads.substring(0, iLength));
        return i2Grow;
    }

    public static RubyString pack(Ruby runtime, RubyArray list, ByteList formatString) {
        ByteBuffer format = ByteBuffer.wrap(formatString.unsafeBytes(), formatString.begin(), formatString.length());
        StringBuffer result = new StringBuffer();
        int listSize = list.size();
        byte type = 0;
        byte next = Pack.safeGet(format);
        int idx = 0;
        block22: while (next != 0) {
            Converter converter;
            type = next;
            next = Pack.safeGet(format);
            while (Character.isWhitespace((char)(type & 0xFF))) {
                if (next == 0) break block22;
                type = next;
                next = Pack.safeGet(format);
            }
            if (next == 33 || next == 95) {
                if (NATIVE_CODES.indexOf(type) == -1) {
                    throw runtime.newArgumentError("'" + next + "' allowed only after types " + NATIVE_CODES);
                }
                next = Pack.safeGet(format);
            }
            int occurrences = 1;
            boolean isStar = false;
            if (next != 0) {
                if (next == 42) {
                    if ("@Xxu".indexOf(type) != -1) {
                        occurrences = 0;
                    } else {
                        occurrences = listSize;
                        isStar = true;
                    }
                    next = Pack.safeGet(format);
                } else if (Character.isDigit((char)(next & 0xFF))) {
                    occurrences = 0;
                    do {
                        occurrences = occurrences * 10 + Character.digit((char)(next & 0xFF), 10);
                    } while ((next = Pack.safeGet(format)) != 0 && Character.isDigit((char)(next & 0xFF)));
                }
            }
            if ((converter = converters[type]) != null) {
                idx = Pack.encode(runtime, occurrences, result, list, idx, converter);
                continue;
            }
            block2 : switch (type) {
                case 37: {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 65: 
                case 66: 
                case 72: 
                case 90: 
                case 97: 
                case 98: 
                case 104: {
                    IRubyObject from;
                    String lCurElemString;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String string = lCurElemString = (from = list.eltInternal(idx++)) == runtime.getNil() ? "" : from.convertToString().toString();
                    if (isStar) {
                        occurrences = lCurElemString.length();
                    }
                    switch (type) {
                        case 65: 
                        case 90: 
                        case 97: {
                            if (lCurElemString.length() >= occurrences) {
                                result.append(lCurElemString.toCharArray(), 0, occurrences);
                                break block2;
                            }
                            result.append(lCurElemString);
                            Pack.grow(result, type == 97 ? sNil10 : sSp10, occurrences -= lCurElemString.length());
                            break block2;
                        }
                        case 98: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                if ((lCurElemString.charAt(i++) & '\u0001') != 0) {
                                    currentByte |= 0x80;
                                }
                                if ((i & 7) == 0) {
                                    result.append((char)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte >>= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result.append((char)((currentByte >>= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break block2;
                        }
                        case 66: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte |= lCurElemString.charAt(i++) & '\u0001';
                                if ((i & 7) == 0) {
                                    result.append((char)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte <<= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result.append((char)((currentByte <<= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break block2;
                        }
                        case 104: {
                            char currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = lCurElemString.charAt(i++)) ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) << 4);
                                if ((i & 1) != 0) {
                                    currentByte >>= 4;
                                    continue;
                                }
                                result.append((char)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result.append((char)(currentByte & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                            break block2;
                        }
                        case 72: {
                            char currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length();
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = lCurElemString.charAt(i++)) ? (currentByte |= (currentChar & 0xF) + 9 & 0xF) : (currentByte |= currentChar & 0xF);
                                if ((i & 1) != 0) {
                                    currentByte <<= 4;
                                    continue;
                                }
                                result.append((char)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result.append((char)(currentByte & 0xFF));
                            }
                            result.setLength(result.length() + padLength);
                        }
                    }
                    break;
                }
                case 120: {
                    Pack.grow(result, sNil10, occurrences);
                    break;
                }
                case 88: {
                    try {
                        Pack.shrink(result, occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `pack': X outside of string");
                    }
                }
                case 64: {
                    if ((occurrences -= result.length()) > 0) {
                        Pack.grow(result, sNil10, occurrences);
                    }
                    if ((occurrences = -occurrences) <= 0) break;
                    Pack.shrink(result, occurrences);
                    break;
                }
                case 109: 
                case 117: {
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String lCurElemString = (from = list.eltInternal(idx++)) == runtime.getNil() ? "" : from.convertToString().toString();
                    occurrences = occurrences <= 2 ? 45 : occurrences / 3 * 3;
                    while (true) {
                        Pack.encodes(runtime, result, lCurElemString, occurrences, (char)type);
                        if (occurrences >= lCurElemString.length()) break block2;
                        lCurElemString = lCurElemString.substring(occurrences);
                    }
                }
                case 77: {
                    IRubyObject from;
                    String lCurElemString;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    String string = lCurElemString = (from = list.eltInternal(idx++)) == runtime.getNil() ? "" : from.asString().toString();
                    if (occurrences <= 1) {
                        occurrences = 72;
                    }
                    Pack.qpencode(result, lCurElemString, occurrences);
                    break;
                }
                case 85: {
                    char[] c = new char[occurrences];
                    int cIndex = 0;
                    while (occurrences-- > 0) {
                        IRubyObject from;
                        if (listSize-- <= 0) {
                            throw runtime.newArgumentError(sTooFew);
                        }
                        long l = (from = list.eltInternal(idx++)) == runtime.getNil() ? 0L : RubyNumeric.num2long(from);
                        c[cIndex] = (char)l;
                        ++cIndex;
                    }
                    try {
                        byte[] bytes = new String(c).getBytes("UTF8");
                        result.append(RubyString.bytesToString(bytes));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"can't convert to UTF8");
                        }
                        continue block22;
                    }
                }
                case 119: {
                    IRubyObject from = list.eltInternal(idx++);
                    String stringVal = from == runtime.getNil() ? "0" : from.asString().toString();
                    BigInteger bigInt = new BigInteger(stringVal);
                    if (bigInt.compareTo(new BigInteger("0")) < 0) break;
                    int bitLength = bigInt.toString(2).length();
                    byte[] bytes = bigInt.toByteArray();
                    byte[] buf = new byte[bitLength / 7 + (bitLength % 7 > 0 ? 1 : 0)];
                    int b = 0;
                    int destBit = 0;
                    int destByte = 0;
                    for (int srcByte = bytes.length - 1; srcByte >= 0; --srcByte) {
                        int srcBit = 0;
                        while (srcBit < 8) {
                            if (destBit == 7) {
                                buf[buf.length - 1 - destByte++] = (byte)(b & 0xFF);
                                b = 128;
                                destBit = 0;
                            }
                            int val = bytes[srcByte] & 1 << srcBit;
                            if (destBit > srcBit) {
                                val = 0xFF & val << destBit - srcBit;
                            } else if (destBit < srcBit) {
                                val = 0xFF & val >> srcBit - destBit;
                            }
                            b |= 0xFF & val;
                            ++srcBit;
                            ++destBit;
                        }
                    }
                    if (b != 128) {
                        buf[destByte] = (byte)(b & 0xFF);
                    }
                    result.append(RubyString.bytesToString(buf));
                }
            }
        }
        return runtime.newString(result.toString());
    }

    private static int decodeIntLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        int value = encode.getInt();
        encode.order(ByteOrder.BIG_ENDIAN);
        return value;
    }

    private static int decodeIntBigEndian(ByteBuffer encode) {
        return encode.getInt();
    }

    private static long decodeIntUnsignedBigEndian(ByteBuffer encode) {
        return (long)encode.getInt() & 0xFFFFFFFFL;
    }

    private static long decodeIntUnsignedLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        long value = (long)encode.getInt() & 0xFFFFFFFFL;
        encode.order(ByteOrder.BIG_ENDIAN);
        return value;
    }

    private static void encodeIntLittleEndian(StringBuffer result, int s) {
        result.append((char)(s & 0xFF)).append((char)(s >> 8 & 0xFF));
        result.append((char)(s >> 16 & 0xFF)).append((char)(s >> 24 & 0xFF));
    }

    private static void encodeIntBigEndian(StringBuffer result, int s) {
        result.append((char)(s >> 24 & 0xFF)).append((char)(s >> 16 & 0xFF));
        result.append((char)(s >> 8 & 0xFF)).append((char)(s & 0xFF));
    }

    private static long decodeLongBigEndian(ByteBuffer encode) {
        int c1 = Pack.decodeIntBigEndian(encode);
        int c2 = Pack.decodeIntBigEndian(encode);
        return ((long)c1 << 32) + ((long)c2 & 0xFFFFFFFFL);
    }

    private static long decodeLongLittleEndian(ByteBuffer encode) {
        int c1 = Pack.decodeIntLittleEndian(encode);
        int c2 = Pack.decodeIntLittleEndian(encode);
        return ((long)c2 << 32) + ((long)c1 & 0xFFFFFFFFL);
    }

    private static void encodeLongLittleEndian(StringBuffer result, long l) {
        Pack.encodeIntLittleEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        Pack.encodeIntLittleEndian(result, (int)(l >>> 32));
    }

    private static void encodeLongBigEndian(StringBuffer result, long l) {
        Pack.encodeIntBigEndian(result, (int)(l >>> 32));
        Pack.encodeIntBigEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    private static double decodeDoubleLittleEndian(ByteBuffer encode) {
        return Double.longBitsToDouble(Pack.decodeLongLittleEndian(encode));
    }

    private static double decodeDoubleBigEndian(ByteBuffer encode) {
        return Double.longBitsToDouble(Pack.decodeLongBigEndian(encode));
    }

    private static void encodeDoubleLittleEndian(StringBuffer result, double d) {
        Pack.encodeLongLittleEndian(result, Double.doubleToLongBits(d));
    }

    private static void encodeDoubleBigEndian(StringBuffer result, double d) {
        Pack.encodeLongBigEndian(result, Double.doubleToLongBits(d));
    }

    private static float decodeFloatBigEndian(ByteBuffer encode) {
        return Float.intBitsToFloat(Pack.decodeIntBigEndian(encode));
    }

    private static float decodeFloatLittleEndian(ByteBuffer encode) {
        return Float.intBitsToFloat(Pack.decodeIntLittleEndian(encode));
    }

    private static void encodeFloatLittleEndian(StringBuffer result, float f) {
        Pack.encodeIntLittleEndian(result, Float.floatToIntBits(f));
    }

    private static void encodeFloatBigEndian(StringBuffer result, float f) {
        Pack.encodeIntBigEndian(result, Float.floatToIntBits(f));
    }

    private static int decodeShortUnsignedLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        int value = encode.getShort() & 0xFFFF;
        encode.order(ByteOrder.BIG_ENDIAN);
        return value;
    }

    private static int decodeShortUnsignedBigEndian(ByteBuffer encode) {
        int value = encode.getShort() & 0xFFFF;
        return value;
    }

    private static short decodeShortBigEndian(ByteBuffer encode) {
        return encode.getShort();
    }

    private static void encodeShortLittleEndian(StringBuffer result, int s) {
        result.append((char)(s & 0xFF)).append((char)((s & 0xFF00) >> 8));
    }

    private static void encodeShortBigEndian(StringBuffer result, int s) {
        result.append((char)((s & 0xFF00) >> 8)).append((char)(s & 0xFF));
    }

    static {
        Converter tmp;
        int i;
        $assertionsDisabled = !Pack.class.desiredAssertionStatus();
        b64_xtable = new int[256];
        converters = new Converter[256];
        hex_table = ByteList.plain("0123456789ABCDEF");
        uu_table = ByteList.plain("`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        b64_table = ByteList.plain("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        sHexDigits = ByteList.plain("0123456789abcdef0123456789ABCDEFx");
        for (i = 0; i < 256; ++i) {
            Pack.b64_xtable[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Pack.b64_xtable[Pack.b64_table[i]] = i;
        }
        Pack.converters[118] = new Converter(2){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedLittleEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortLittleEndian(result, s);
            }
        };
        Pack.converters[101] = new Converter(4){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatLittleEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                float f = o == runtime.getNil() ? 0.0f : (float)RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeFloatLittleEndian(result, f);
            }
        };
        Pack.converters[70] = tmp = new Converter(4){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatBigEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                float f = o == runtime.getNil() ? 0.0f : (float)RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeFloatBigEndian(result, f);
            }
        };
        Pack.converters[102] = tmp;
        Pack.converters[103] = tmp;
        Pack.converters[69] = new Converter(8){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleLittleEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                double d = o == runtime.getNil() ? 0.0 : RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeDoubleLittleEndian(result, d);
            }
        };
        Pack.converters[68] = tmp = new Converter(8){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleBigEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                double d = o == runtime.getNil() ? 0.0 : RubyKernel.new_float(o, o).convertToFloat().getDoubleValue();
                Pack.encodeDoubleBigEndian(result, d);
            }
        };
        Pack.converters[100] = tmp;
        Pack.converters[71] = tmp;
        Pack.converters[115] = new Converter(2){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortBigEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        };
        Pack.converters[83] = tmp = new Converter(2){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedBigEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)(RubyNumeric.num2long(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        };
        Pack.converters[110] = tmp;
        Pack.converters[99] = new Converter(1){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                byte c = enc.get();
                return runtime.newFixnum(c > 127 ? (long)(c - 256) : (long)c);
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                char c = o == runtime.getNil() ? (char)'\u0000' : (char)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        };
        Pack.converters[67] = new Converter(1){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(enc.get() & 0xFF);
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                char c = o == runtime.getNil() ? (char)'\u0000' : (char)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        };
        Pack.converters[86] = new Converter(4){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntLittleEndian(result, s);
            }
        };
        Pack.converters[73] = tmp = new Converter(4){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        Pack.converters[76] = tmp;
        Pack.converters[78] = tmp;
        Pack.converters[108] = tmp = new Converter(4){

            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntBigEndian(enc));
            }

            public void encode(Ruby runtime, IRubyObject o, StringBuffer result) {
                int s = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        Pack.converters[105] = tmp;
    }

    static class PtrList {
        private byte[] buffer;
        private int index;

        public PtrList(byte[] bufferString) {
            this.buffer = bufferString;
            this.index = 0;
        }

        public int remaining() {
            return this.buffer.length - this.index;
        }

        public String nextSubstring(int length) {
            if (this.index + length > this.buffer.length) {
                throw new IllegalArgumentException();
            }
            String substring = null;
            substring = new String(ByteList.plain(this.buffer, this.index, length));
            this.index += length;
            return substring;
        }

        public void setPosition(int position) {
            if (position < this.buffer.length) {
                this.index = position;
            }
        }

        public int nextAsciiNumber() {
            int i;
            for (i = this.index; i < this.buffer.length && Character.isDigit((char)(this.buffer[i] & 0xFF)); ++i) {
            }
            int number = 0;
            Integer.parseInt(new String(ByteList.plain(this.buffer, this.index, i - this.index)));
            this.index = i;
            return number;
        }

        public int getLength() {
            return this.buffer.length;
        }

        public int nextByte() {
            int next = 0;
            if (this.index < this.buffer.length) {
                next = this.buffer[this.index++];
            } else if (this.index == this.buffer.length) {
                ++this.index;
            }
            return next & 0xFF;
        }

        public void backup(int occurrences) {
            this.index -= occurrences;
            if (this.index < 0) {
                throw new IllegalArgumentException();
            }
        }

        public boolean isAtEnd() {
            return this.index > this.buffer.length;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static abstract class Converter {
        public int size;

        public Converter(int size) {
            this.size = size;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, StringBuffer var3);
    }
}

