/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.xml.TestNGContentHandler;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String DEPRECATED_TESTNG_DTD_URL = "http://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "http://testng.org/testng-1.0.dtd";
    public static final String DEFAULT_FILENAME = "testng.xml";
    private final String m_fileName;
    private final InputStream m_inputStream;
    private boolean m_lookInJar = false;

    private Parser(String filename, InputStream inputStream) {
        this.m_fileName = filename;
        this.m_inputStream = inputStream;
    }

    public Parser(String fileName) throws FileNotFoundException {
        this(fileName, new FileInputStream(new File(fileName)));
    }

    public Parser(InputStream inputStream) {
        this(null, inputStream);
    }

    public Parser() throws FileNotFoundException {
        this(DEFAULT_FILENAME, Parser.getDefault());
    }

    private static InputStream getDefault() throws FileNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream in = classLoader != null ? classLoader.getResourceAsStream(DEFAULT_FILENAME) : Parser.class.getResourceAsStream(DEFAULT_FILENAME);
        if (in == null) {
            throw new FileNotFoundException("Default property file of testng.xml was not found");
        }
        return in;
    }

    public Collection<XmlSuite> parse() throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, XmlSuite> mapResult = new HashMap<String, XmlSuite>();
        SAXParserFactory spf = this.loadSAXParserFactory();
        if (this.supportsValidation(spf)) {
            spf.setValidating(true);
        }
        SAXParser saxParser = spf.newSAXParser();
        File parentFile = null;
        String mainFilePath = null;
        if (this.m_fileName != null) {
            File mainFile = new File(this.m_fileName);
            mainFilePath = mainFile.getCanonicalPath();
            parentFile = mainFile.getParentFile();
        }
        ArrayList<String> toBeParsed = new ArrayList<String>();
        ArrayList<String> toBeAdded = new ArrayList<String>();
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        toBeParsed.add(mainFilePath);
        while (toBeParsed.size() > 0) {
            for (String currentFile : toBeParsed) {
                XmlSuite result;
                TestNGContentHandler ch = new TestNGContentHandler(currentFile);
                InputStream inputStream = currentFile != null ? new FileInputStream(currentFile) : this.m_inputStream;
                saxParser.parse(inputStream, (DefaultHandler)ch);
                if (currentFile != null) {
                    inputStream.close();
                }
                XmlSuite currentXmlSuite = result = ch.getSuite();
                mapResult.put(currentFile, currentXmlSuite);
                toBeRemoved.add(currentFile);
                List<String> suiteFiles = currentXmlSuite.getSuiteFiles();
                if (suiteFiles.size() <= 0) continue;
                for (String path : suiteFiles) {
                    String canonicalPath = parentFile != null && new File(parentFile, path).exists() ? new File(parentFile, path).getCanonicalPath() : new File(path).getCanonicalPath();
                    if (mapResult.containsKey(canonicalPath)) continue;
                    toBeAdded.add(canonicalPath);
                }
            }
            for (String s : toBeRemoved) {
                toBeParsed.remove(s);
            }
            toBeRemoved = new ArrayList();
            for (String s : toBeAdded) {
                toBeParsed.add(s);
            }
            toBeAdded = new ArrayList();
        }
        return mapResult.values();
    }

    public List<XmlSuite> parseToList() throws ParserConfigurationException, SAXException, IOException {
        ArrayList<XmlSuite> result = new ArrayList<XmlSuite>();
        Collection<XmlSuite> suites = this.parse();
        for (XmlSuite suite : suites) {
            result.add(suite);
        }
        return result;
    }

    private SAXParserFactory loadSAXParserFactory() {
        Class<?> factoryClass;
        SAXParserFactory spf = null;
        StringBuffer errorLog = new StringBuffer();
        try {
            factoryClass = ClassHelper.forName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            spf = (SAXParserFactory)factoryClass.newInstance();
        }
        catch (Exception ex) {
            errorLog.append("JDK5 SAXParserFactory cannot be loaded: " + ex.getMessage());
        }
        if (null == spf) {
            try {
                factoryClass = ClassHelper.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                spf = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception ex) {
                errorLog.append("\n").append("JDK1.4 SAXParserFactory cannot be loaded: " + ex.getMessage());
            }
        }
        FactoryConfigurationError cause = null;
        if (null == spf) {
            try {
                spf = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError fcerr) {
                cause = fcerr;
            }
        }
        if (null == spf) {
            throw new TestNGException("Cannot initialize a SAXParserFactory\n" + errorLog.toString(), cause);
        }
        return spf;
    }

    private boolean supportsValidation(SAXParserFactory spf) {
        try {
            return spf.getFeature("http://xml.org/sax/features/validation");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

