/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.util.Map;
import org.springframework.ui.ModelMap;

public class ModelAndView {
    private Object view;
    private ModelMap model;
    private boolean cleared;

    public ModelAndView() {
    }

    public ModelAndView(String viewName) {
        this.view = viewName;
    }

    public ModelAndView(Object view) {
        this.view = view;
    }

    public ModelAndView(String viewName, Map model) {
        this.view = viewName;
        if (model != null) {
            this.getModelMap().addAllAttributes(model);
        }
    }

    public ModelAndView(Object view, Map model) {
        this.view = view;
        if (model != null) {
            this.getModelMap().addAllAttributes(model);
        }
    }

    public ModelAndView(String viewName, String modelName, Object modelObject) {
        this.view = viewName;
        this.addObject(modelName, modelObject);
    }

    public ModelAndView(Object view, String modelName, Object modelObject) {
        this.view = view;
        this.addObject(modelName, modelObject);
    }

    public void setViewName(String viewName) {
        this.view = viewName;
    }

    public String getViewName() {
        return this.view instanceof String ? (String)this.view : null;
    }

    public void setView(Object view) {
        this.view = view;
    }

    public Object getView() {
        return !(this.view instanceof String) ? this.view : null;
    }

    public boolean hasView() {
        return this.view != null;
    }

    public boolean isReference() {
        return this.view instanceof String;
    }

    protected Map getModelInternal() {
        return this.model;
    }

    public ModelMap getModelMap() {
        if (this.model == null) {
            this.model = new ModelMap();
        }
        return this.model;
    }

    public Map getModel() {
        return this.getModelMap();
    }

    public ModelAndView addObject(String attributeName, Object attributeValue) {
        this.getModelMap().addAttribute(attributeName, attributeValue);
        return this;
    }

    public ModelAndView addObject(Object attributeValue) {
        this.getModelMap().addAttribute(attributeValue);
        return this;
    }

    public ModelAndView addAllObjects(Map modelMap) {
        this.getModelMap().addAllAttributes(modelMap);
        return this;
    }

    public void clear() {
        this.view = null;
        this.model = null;
        this.cleared = true;
    }

    public boolean isEmpty() {
        return this.view == null && this.model == null;
    }

    public boolean wasCleared() {
        return this.cleared && this.isEmpty();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ModelAndView: ");
        if (this.isReference()) {
            buf.append("reference to view with name '").append(this.view).append("'");
        } else {
            buf.append("materialized View is [").append(this.view).append(']');
        }
        buf.append("; model is ").append(this.model);
        return buf.toString();
    }
}

